/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.ISubCtx;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.js.IJsObjectRef;

public class VjoSerializationCtx
extends BaseSubCtx {
    private String m_registryScope = "_dr";
    private Stack<Object> m_serStack;
    private Map<Object, Object> m_serCache;
    private Map<Object, Map<Object, String>> m_serBrokenReferences;
    private Map<IJsObjectRef, Object> m_serRegistry;
    private boolean m_withinCallStack;
    private boolean m_hasVjoList;
    private boolean m_hasVjoMap;
    private boolean m_hasVjoSet;

    public String getRegistryScope() {
        return this.m_registryScope;
    }

    public void setRegistryScope(String scope) {
        this.m_registryScope = scope;
    }

    public Map<Object, String> getBrokenReference(Object referTo) {
        if (referTo == null || this.m_serBrokenReferences == null) {
            return Collections.emptyMap();
        }
        if (this.m_serBrokenReferences.get(referTo) == null) {
            return Collections.emptyMap();
        }
        return this.m_serBrokenReferences.get(referTo);
    }

    public boolean hasBrokenReference(Object referTo) {
        return this.getBrokenReference(referTo).size() > 0;
    }

    public void addBrokenReference(Object referTo, Object broken, String prop) {
        Map<Object, String> referenceMap;
        if (referTo == null || broken == null) {
            return;
        }
        if (this.m_serBrokenReferences == null) {
            this.m_serBrokenReferences = new HashMap<Object, Map<Object, String>>();
        }
        if ((referenceMap = this.m_serBrokenReferences.get(referTo)) == null) {
            referenceMap = new HashMap<Object, String>();
            this.m_serBrokenReferences.put(referTo, referenceMap);
        }
        referenceMap.put(broken, prop);
    }

    public boolean inStack(Object toSer) {
        if (this.m_serStack == null) {
            return false;
        }
        return this.m_serStack.contains(toSer);
    }

    public void push(Object toSer) {
        if (this.m_serStack == null) {
            this.m_serStack = new Stack();
        }
        this.m_serStack.add(toSer);
    }

    public Object peek() {
        if (this.m_serStack == null) {
            return null;
        }
        return this.m_serStack.peek();
    }

    public void pop(Object toSer) {
        if (this.m_serStack != null) {
            this.m_serStack.remove(toSer);
        }
    }

    public boolean withinCallStack() {
        return this.m_withinCallStack;
    }

    public void setWithinCallStack(boolean stackEntry) {
        this.m_withinCallStack = stackEntry;
    }

    public boolean getHasVjoList() {
        return this.m_hasVjoList;
    }

    public void setHasVjoList(boolean has) {
        this.m_hasVjoList = has;
    }

    public boolean getHasVjoMap() {
        return this.m_hasVjoMap;
    }

    public void setHasVjoMap(boolean has) {
        this.m_hasVjoMap = has;
    }

    public boolean getHasVjoSet() {
        return this.m_hasVjoSet;
    }

    public void setHasVjoSet(boolean has) {
        this.m_hasVjoSet = has;
    }

    public void cache(Object toSer, Object result) {
        if (toSer == null || result == null) {
            throw new DsfRuntimeException("can't cache null json result");
        }
        if (this.m_serCache == null) {
            this.m_serCache = new HashMap<Object, Object>();
        }
        this.m_serCache.put(toSer, result);
    }

    public Object getCached(Object toSer) {
        if (this.m_serCache == null) {
            return null;
        }
        return this.m_serCache.get(toSer);
    }

    public void clearCache() {
        if (this.m_serCache != null) {
            this.m_serCache.clear();
        }
    }

    public void bindJsRef(IJsObjectRef ref, Object object) {
        if (this.m_serRegistry == null) {
            this.m_serRegistry = new HashMap<IJsObjectRef, Object>();
        }
        this.m_serRegistry.put(ref, object);
    }

    public Object getByJsRef(IJsObjectRef ref) {
        if (this.m_serRegistry == null) {
            return null;
        }
        return this.m_serRegistry.get(ref);
    }

    public void reset() {
        VjoSerializationCtx.setCtx(new VjoSerializationCtx());
    }

    public static VjoSerializationCtx setCtx(VjoSerializationCtx ctx) {
        CtxAssociator.setCtx(ctx);
        return ctx;
    }

    public static VjoSerializationCtx ctx() {
        VjoSerializationCtx ctx = CtxAssociator.getCtx();
        return ctx != null ? ctx : VjoSerializationCtx.setCtx(new VjoSerializationCtx());
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = VjoSerializationCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static VjoSerializationCtx getCtx() {
            return (VjoSerializationCtx)((Object)CtxAssociator.getSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME));
        }

        protected static void setCtx(VjoSerializationCtx ctx) {
            CtxAssociator.setSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME, (ISubCtx)ctx);
        }
    }
}

