/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.serializer.VjoAbstractSerializer;
import org.eclipse.vjet.dsf.serializer.VjoArraySerializer;
import org.eclipse.vjet.dsf.serializer.VjoBeanSerializer;
import org.eclipse.vjet.dsf.serializer.VjoEnumSerializer;
import org.eclipse.vjet.dsf.serializer.VjoListSerializer;
import org.eclipse.vjet.dsf.serializer.VjoMapSerializer;
import org.eclipse.vjet.dsf.serializer.VjoPrimitiveSerializer;
import org.eclipse.vjet.dsf.serializer.VjoSerializableSerializer;
import org.eclipse.vjet.dsf.serializer.VjoSerializationCtx;
import org.eclipse.vjet.dsf.serializer.VjoSetSerializer;
import org.eclipse.vjet.dsf.serializers.IVjoSerializer;

public class VjoSerializer
extends VjoAbstractSerializer {
    protected static final String VJO_DATA_REGISTRY = "vjo.DataRegistry";
    protected static final String VJO_DATA_REGISTRY_FULL = "new function(){var t=this,m=[];t.put=function(k,j,r){var p,b;m[k]=j;if(r){for(p in r){b=t.get(p);if(b){b[r[p]]=j;}}}}; t.get=function(k){return m[k];};}()";
    protected static final String VJO_DATA_REGISTRY_LOCAL = "_dr";
    protected static final String VJO_HASHMAP_UTIL = "org.eclipse.vjet.vjo.java.util.HashMapUtil";
    protected static final String VJO_HASHMAP_UTIL_CREATE = "create";
    protected static final String VJO_HASHMAP_UTIL_LOCAL = "$mU";
    protected static final String VJO_ARRAYLIST_UTIL = "org.eclipse.vjet.vjo.java.util.ArrayListUtil";
    protected static final String VJO_ARRAYLIST_UTIL_CREATE = "create";
    protected static final String VJO_ARRAYLIST_UTIL_LOCAL = "$lU";
    protected static final String VJO_HASHSET_UTIL = "org.eclipse.vjet.vjo.java.util.HashSetUtil";
    protected static final String VJO_HASHSET_UTIL_CREATE = "create";
    protected static final String VJO_HASHSET_UTIL_LOCAL = "$sU";
    private static final VjoSerializer s_instance = new VjoSerializer();
    private List<IVjoSerializer> m_serializerList = new LinkedList<IVjoSerializer>();
    private String m_dataRegistry = "vjo.DataRegistry";
    private String m_dataRegistryLocal = "_dr";
    private String m_hashMapUtil = "org.eclipse.vjet.vjo.java.util.HashMapUtil";
    private String m_hashMapUtilLocal = "$mU";
    private String m_hashMapUtilCreate = "create";
    private String m_arrayListUtil = "org.eclipse.vjet.vjo.java.util.ArrayListUtil";
    private String m_arrayListUtilLocal = "$lU";
    private String m_arrayListUtilCreate = "create";
    private String m_hashSetUtil = "org.eclipse.vjet.vjo.java.util.HashSetUtil";
    private String m_hashSetUtilLocal = "$sU";
    private String m_hashSetUtilCreate = "create";

    public static final VjoSerializer getInstance() {
        return s_instance;
    }

    private VjoSerializer() {
        this.registerSerializer(new VjoPrimitiveSerializer());
        this.registerSerializer(new VjoEnumSerializer());
        this.registerSerializer(new VjoBeanSerializer());
        this.registerSerializer(new VjoArraySerializer());
        this.registerSerializer(new VjoSerializableSerializer());
        this.registerSerializer(new VjoMapSerializer());
        this.registerSerializer(new VjoListSerializer());
        this.registerSerializer(new VjoSetSerializer());
    }

    private void registerSerializer(VjoAbstractSerializer ser) {
        ser.setOwner(this);
        this.m_serializerList.add(ser);
    }

    public String getVjoDataRegistry() {
        return this.m_dataRegistry;
    }

    public VjoSerializer setVjoDataRegistry(String dR) {
        if (dR == null) {
            DsfExceptionHelper.chuck((String)"can't use a null data registry value");
        }
        this.m_dataRegistry = dR;
        return this;
    }

    public String getVjoDataRegistryLocal() {
        return this.m_dataRegistryLocal;
    }

    public VjoSerializer setVjoDataRegistryLocal(String dRLocal) {
        if (dRLocal == null) {
            DsfExceptionHelper.chuck((String)"can't use a null local data registry value");
        }
        this.m_dataRegistryLocal = dRLocal;
        return this;
    }

    public String getVjoHashMapUtil() {
        return this.m_hashMapUtil;
    }

    public VjoSerializer setVjoHashMapUtil(String mU) {
        if (mU == null) {
            DsfExceptionHelper.chuck((String)"can't use a null hashmap util value");
        }
        this.m_hashMapUtil = mU;
        return this;
    }

    public String getVjoHashMapUtilLocal() {
        return this.m_hashMapUtilLocal;
    }

    public VjoSerializer setVjoHashMapUtilLocal(String mULocal) {
        if (mULocal == null) {
            DsfExceptionHelper.chuck((String)"can't use a null local hashmap util value");
        }
        this.m_hashMapUtilLocal = mULocal;
        return this;
    }

    public String getVjoHashMapUtilCreate() {
        return this.m_hashMapUtilCreate;
    }

    public VjoSerializer setVjoHashMapUtilCreate(String mUCreate) {
        if (mUCreate == null) {
            DsfExceptionHelper.chuck((String)"can't use a null hashmap util create value");
        }
        this.m_hashMapUtilCreate = mUCreate;
        return this;
    }

    public String getVjoArrayListUtil() {
        return this.m_arrayListUtil;
    }

    public VjoSerializer setVjoArrayListUtil(String lU) {
        if (lU == null) {
            DsfExceptionHelper.chuck((String)"can't use a null arraylist util value");
        }
        this.m_arrayListUtil = lU;
        return this;
    }

    public String getVjoArrayListUtilLocal() {
        return this.m_arrayListUtilLocal;
    }

    public VjoSerializer setVjoArrayListUtilLocal(String lULocal) {
        if (lULocal == null) {
            DsfExceptionHelper.chuck((String)"can't use a null local arraylist util value");
        }
        this.m_arrayListUtilLocal = lULocal;
        return this;
    }

    public String getVjoArrayListUtilCreate() {
        return this.m_arrayListUtilCreate;
    }

    public VjoSerializer setVjoArrayListUtilCreate(String lUCreate) {
        if (lUCreate == null) {
            DsfExceptionHelper.chuck((String)"can't use a null arraylist util create value");
        }
        this.m_arrayListUtilCreate = lUCreate;
        return this;
    }

    public String getVjoHashSetUtil() {
        return this.m_hashSetUtil;
    }

    public VjoSerializer setVjoHashSetUtil(String sU) {
        if (sU == null) {
            DsfExceptionHelper.chuck((String)"can't use a null hashset util value");
        }
        this.m_hashSetUtil = sU;
        return this;
    }

    public String getVjoHashSetUtilLocal() {
        return this.m_hashSetUtilLocal;
    }

    public VjoSerializer setVjoHashSetUtilLocal(String sULocal) {
        if (sULocal == null) {
            DsfExceptionHelper.chuck((String)"can't use a null local hashset util value");
        }
        this.m_hashSetUtilLocal = sULocal;
        return this;
    }

    public String getVjoHashSetUtilCreate() {
        return this.m_hashSetUtilCreate;
    }

    public VjoSerializer setVjoHashSetUtilCreate(String sUCreate) {
        if (sUCreate == null) {
            DsfExceptionHelper.chuck((String)"can't use a null hashset util create value");
        }
        this.m_hashSetUtilCreate = sUCreate;
        return this;
    }

    @Override
    public boolean canSerialize(Object toSer) {
        return true;
    }

    private void appendDataRegistryAssignment(StringBuilder sb) {
        this.appendAssignmentUtil(sb, this.getVjoDataRegistryLocal(), this.getVjoDataRegistry());
    }

    private void appendMapUtilAssignment(StringBuilder sb) {
        this.appendAssignmentUtil(sb, this.getVjoHashMapUtilLocal(), this.toUtilCreateFunction(this.getVjoHashMapUtil(), this.getVjoHashMapUtilCreate()));
    }

    private void appendListUtilAssignment(StringBuilder sb) {
        this.appendAssignmentUtil(sb, this.getVjoArrayListUtilLocal(), this.toUtilCreateFunction(this.getVjoArrayListUtil(), this.getVjoArrayListUtilCreate()));
    }

    private void appendSetUtilAssignment(StringBuilder sb) {
        this.appendAssignmentUtil(sb, this.getVjoHashSetUtilLocal(), this.toUtilCreateFunction(this.getVjoHashSetUtil(), this.getVjoHashSetUtilCreate()));
    }

    private void appendAssignmentUtil(StringBuilder sb, String target, String source) {
        sb.append("var ");
        sb.append(target);
        sb.append("=");
        sb.append(source);
        sb.append(";");
    }

    private String toUtilCreateFunction(String util, String create) {
        StringBuilder sb = new StringBuilder("function(_data){return ");
        sb.append(util);
        sb.append(".");
        sb.append(create);
        sb.append("(_data);}");
        return sb.toString();
    }

    public String toVjo(Object toSer, VjoSerializerOption option) {
        return this.toVjo(toSer, option, "utf-8");
    }

    public String toVjo(Object toSer, VjoSerializerOption option, String encoding) {
        VjoSerializationCtx ctx = VjoSerializationCtx.ctx();
        if (!VjoSerializerOption.DFEAULT.equals((Object)option)) {
            ctx.reset();
        } else {
            ctx.setHasVjoList(false);
            ctx.setHasVjoMap(false);
            ctx.setHasVjoSet(false);
        }
        if (VjoSerializerOption.DATA_REGISTRY_FREE.equals((Object)option)) {
            this.setVjoDataRegistry(VJO_DATA_REGISTRY_FULL);
        }
        ctx.setRegistryScope(this.getVjoDataRegistryLocal());
        Object vjo = null;
        try {
            vjo = this.serialize(toSer);
        }
        catch (SerializationException serializationException) {
            vjo = null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(function(){");
        this.appendDataRegistryAssignment(sb);
        if (ctx.getHasVjoMap()) {
            this.appendMapUtilAssignment(sb);
        }
        if (ctx.getHasVjoList()) {
            this.appendListUtilAssignment(sb);
        }
        if (ctx.getHasVjoSet()) {
            this.appendSetUtilAssignment(sb);
        }
        if (!VjoSerializerOption.DFEAULT.equals((Object)option)) {
            sb.append("var _2r=");
        } else {
            sb.append("return ");
        }
        sb.append(vjo);
        sb.append(";");
        if (!VjoSerializerOption.DFEAULT.equals((Object)option)) {
            if (VjoSerializerOption.RESET_CTX.equals((Object)option)) {
                sb.append(this.getVjoDataRegistryLocal());
                sb.append(".clear();");
            }
            sb.append("return _2r;");
        }
        sb.append("})()");
        try {
            byte[] encodedBytes = sb.toString().getBytes(encoding);
            return new String(encodedBytes, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return sb.toString();
        }
    }

    public String toVjo(Object toSer) {
        return this.toVjo(toSer, VjoSerializerOption.DFEAULT);
    }

    public String toVjo(Object toSer, String encoding) {
        return this.toVjo(toSer, VjoSerializerOption.DFEAULT, encoding);
    }

    @Override
    public Object doSerialize(Object toSer) throws SerializationException {
        Object json = null;
        for (IVjoSerializer dedicatedSerializer : this.m_serializerList) {
            if (!dedicatedSerializer.canSerialize(toSer)) continue;
            json = dedicatedSerializer.serialize(toSer);
            break;
        }
        return json;
    }

    @Override
    protected Object toCache(Object toSerialize, Object result) {
        return result;
    }

    @Override
    protected boolean canCache(Object toSerialize) {
        return false;
    }

    @Override
    protected Object restoreBrokenReference(Object toSerialize, Object result) {
        return result;
    }

    public static enum VjoSerializerOption {
        DFEAULT,
        RESET_CTX,
        DATA_REGISTRY_FREE;

    }
}

