/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.spec.app;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.spec.app.IAppSpec;
import org.eclipse.vjet.dsf.spec.app.IStateSpec;
import org.eclipse.vjet.dsf.spec.module.IModuleSpec;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;

public class DefaultStateSpec
implements IStateSpec {
    private final String m_name;
    private final Map<IAppSpec.Option, List<IModuleSpec>> m_modules = new HashMap<IAppSpec.Option, List<IModuleSpec>>(3);

    public DefaultStateSpec(String name) {
        if (name == null) {
            DsfExceptionHelper.chuck((String)"stateId is null");
        }
        this.m_name = name;
        this.m_modules.put(IAppSpec.Option.IN_ONLY, new ArrayList(1));
        this.m_modules.put(IAppSpec.Option.OUT_ONLY, new ArrayList(1));
        this.m_modules.put(IAppSpec.Option.IN_OUT, new ArrayList(1));
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public List<IModuleSpec> getAllInboundModuleSpecs() {
        List<IModuleSpec> ilist = this.m_modules.get((Object)IAppSpec.Option.IN_ONLY);
        List<IModuleSpec> iolist = this.m_modules.get((Object)IAppSpec.Option.IN_OUT);
        ArrayList<IModuleSpec> allList = new ArrayList<IModuleSpec>(ilist.size() + iolist.size());
        allList.addAll(ilist);
        allList.addAll(iolist);
        return allList;
    }

    @Override
    public List<IModuleSpec> getAllOutboundModuleSpecs() {
        List<IModuleSpec> olist = this.m_modules.get((Object)IAppSpec.Option.OUT_ONLY);
        List<IModuleSpec> iolist = this.m_modules.get((Object)IAppSpec.Option.IN_OUT);
        ArrayList<IModuleSpec> allList = new ArrayList<IModuleSpec>(olist.size() + iolist.size());
        allList.addAll(olist);
        allList.addAll(iolist);
        return allList;
    }

    @Override
    public List<IModuleSpec> getModuleSpecs(IAppSpec.Option option) {
        if (option == null || this.m_modules.get((Object)option).size() == 0) {
            return Collections.emptyList();
        }
        return new ArrayList<IModuleSpec>((Collection)this.m_modules.get((Object)option));
    }

    @Override
    public List<IModuleSpec> getAllModuleSpecs() {
        List<IModuleSpec> ilist = this.m_modules.get((Object)IAppSpec.Option.IN_ONLY);
        List<IModuleSpec> olist = this.m_modules.get((Object)IAppSpec.Option.OUT_ONLY);
        List<IModuleSpec> iolist = this.m_modules.get((Object)IAppSpec.Option.IN_OUT);
        ArrayList<IModuleSpec> allList = new ArrayList<IModuleSpec>(ilist.size() + olist.size() + iolist.size());
        allList.addAll(ilist);
        allList.addAll(olist);
        allList.addAll(iolist);
        return allList;
    }

    @Override
    public List<IViewSpec> getAllViewSpecs() {
        List<IModuleSpec> modules = this.getModuleSpecs(IAppSpec.Option.OUT_ONLY);
        if (modules == null || modules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IViewSpec> views = new ArrayList<IViewSpec>(modules.size());
        Iterator<IModuleSpec> itr = modules.iterator();
        while (itr.hasNext()) {
            views.addAll(itr.next().getAllViewSpecs());
        }
        return views;
    }

    public DefaultStateSpec add(IModuleSpec moduleSpec, IAppSpec.Option option) {
        if (moduleSpec == null) {
            DsfExceptionHelper.chuck((String)"moduleSpec is null");
        }
        if (option == null) {
            DsfExceptionHelper.chuck((String)"option is null");
        }
        this.m_modules.get((Object)option).add(moduleSpec);
        return this;
    }
}

