/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DProcessingInstruction;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DFrameSet;
import org.eclipse.vjet.dsf.html.dom.DHead;
import org.eclipse.vjet.dsf.html.dom.DHtml;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DHtmlDOMImplementation;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocType;
import org.eclipse.vjet.dsf.html.dom.DTitle;
import org.eclipse.vjet.dsf.html.dom.Html;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DHtmlDocument
extends DDocument {
    private static final long serialVersionUID = 3258132457579427892L;
    private static final Html s_html = new Html();

    public DHtmlDocument() {
    }

    public DHtmlDocument(DHtmlDocType.Type docType) {
        this();
        this.setDocType(docType);
    }

    public NodeList getElementsByTagName(HtmlTypeEnum type) {
        return this.getElementsByTagName(type.getName());
    }

    protected DDocument setDOMImplementation(DHtmlDOMImplementation impl) {
        super.setDOMImplementation((DOMImplementation)impl);
        return this;
    }

    public DElement createElement(String tagName) {
        return s_html.domCreateDynamicElement(tagName);
    }

    public DElement createElementNS(DNamespace namespace, String tagName) {
        return this.createElement(tagName).setDsfNamespace(namespace);
    }

    public DElement createElementNS(String namespaceUri, String possibleQualifiedTagName) {
        return s_html.domCreateDynamicElement(namespaceUri, possibleQualifiedTagName);
    }

    public DHtmlDocument add(DNamespace ns) {
        this.getDsfNamespaceDeclarations().add(ns);
        return this;
    }

    public DHtmlDocument add(DNode newChild) throws DOMException {
        this.appendChild((Node)newChild);
        return this;
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (newChild == null) {
            super.appendChild(null);
            return this;
        }
        Class<?> newChildsClass = newChild.getClass();
        if (DHtmlDocType.class.isAssignableFrom(newChildsClass) || DHtml.class.isAssignableFrom(newChildsClass) || DComment.class.isAssignableFrom(newChildsClass) || DProcessingInstruction.class.isAssignableFrom(newChildsClass)) {
            super.appendChild(newChild);
            return this;
        }
        throw new DOMException(16, "A DHtmlDocuments children can be DHtmlDocType(0..1), DHtml(0..1), DProcessingInstruction(0..n), DComment(0..n)");
    }

    public DHtmlDocType getDoctype() {
        return (DHtmlDocType)super.getDoctype();
    }

    public void setDocType(DHtmlDocType.Type desiredDocType) {
        DHtmlDocType oldDocType = this.getDoctype();
        DHtmlDocType docType = DHtmlDocType.createDocType(this, desiredDocType);
        if (docType == null) {
            if (oldDocType != null) {
                this.removeChild((Node)((Object)oldDocType));
            }
        } else if (oldDocType == null) {
            this.insertBefore((Node)((Object)docType), this.getFirstChild());
        } else {
            this.replaceChild((Node)((Object)docType), (Node)((Object)oldDocType));
        }
    }

    public DHtmlDocType createDocumentType(String qualifiedName, String publicId, String systemId) {
        return new DHtmlDocType(this, qualifiedName, publicId, systemId);
    }

    public DHtml getDomDocumentElement() {
        return this.getHtml();
    }

    public DHtml getHtml() {
        Node node = this.getFirstChild();
        while (node != null) {
            if (node instanceof DHtml) {
                return (DHtml)((Object)node);
            }
            node = node.getNextSibling();
        }
        DHtml html = new DHtml(this);
        Node node2 = this.getFirstChild();
        while (node2 != null) {
            if (!(node2 instanceof DocumentType)) {
                html.appendChild(node2);
            }
            node2 = node2.getNextSibling();
        }
        this.add((DNode)html);
        return html;
    }

    public DHead getHead() {
        DHtml html = this.getHtml();
        Object head = html.getFirstChild();
        while (head != null && !(head instanceof DHead)) {
            head = head.getNextSibling();
        }
        if (head != null) {
            Node child = html.getFirstChild();
            Node firstChild = head.getFirstChild();
            while (child != null && child != head) {
                Node next = child.getNextSibling();
                head.insertBefore(child, firstChild);
                child = next;
            }
            return (DHead)((Object)head);
        }
        head = new DHead(this);
        html.insertBefore((Node)head, html.getFirstChild());
        return (DHead)((Object)head);
    }

    public String getTitle() {
        DHead head = this.getHead();
        NodeList list = head.getElementsByTagName(HtmlTypeEnum.TITLE);
        if (list.getLength() > 0) {
            DTitle title = (DTitle)((Object)list.item(0));
            return title.getHtmlText();
        }
        return "";
    }

    public DBody getBody() {
        DHtml html = this.getHtml();
        DHead head = this.getHead();
        Object body = head.getNextSibling();
        while (body != null && !(body instanceof DBody) && !(body instanceof DFrameSet)) {
            body = body.getNextSibling();
        }
        if (body != null) {
            Node child = head.getNextSibling();
            Node firstChild = body.getFirstChild();
            while (child != null && child != body) {
                Node next = child.getNextSibling();
                body.insertBefore(child, firstChild);
                child = next;
            }
            return (DBody)((Object)body);
        }
        body = new DBody(this);
        html.appendChild((Node)body);
        return (DBody)((Object)body);
    }

    public DHtmlCollection getImages() {
        return new DHtmlCollection(this.getBody(), 3);
    }

    public DHtmlCollection getApplets() {
        return new DHtmlCollection(this.getBody(), 4);
    }

    public DHtmlCollection getLinks() {
        return new DHtmlCollection(this.getBody(), 5);
    }

    public DHtmlCollection getForms() {
        return new DHtmlCollection(this.getBody(), 2);
    }

    public DHtmlCollection getAnchors() {
        return new DHtmlCollection(this.getBody(), 1);
    }

    public Object clone() throws CloneNotSupportedException {
        DHtmlDocument newDoc = new DHtmlDocument();
        super.cloneNode((DDocument)newDoc);
        return newDoc;
    }

    public DHtmlDocument jif(String jif) {
        super.jif(jif);
        return this;
    }
}

