/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.eclipse.vjet.dsf.css.dom.impl.DCssStyleRule;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.eclipse.vjet.dsf.css.sac.CssException;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;

public class DStyleRulesPropertyEditor
extends PropertyEditorSupport {
    TextField m_textField;
    JPanel m_panel;
    DefaultTableModel m_tableModel;
    DCssBuilder m_cssParser = new DCssBuilder();

    private void initEditor() {
        this.m_tableModel = new DefaultTableModel(new Object[]{"Selectors", "Style Rule Declaration"}, 2);
        JTable table = new JTable(this.m_tableModel);
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.add(new JScrollPane(table));
        this.m_textField = new TextField(20);
        this.m_textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextField source = (TextField)e.getSource();
                String value = source.getText();
                String cssText = DStyleRulesPropertyEditor.this.updateStyle(value);
                source.setText(cssText);
                DStyleRulesPropertyEditor.this.setValue(cssText);
            }
        });
        this.m_panel.add((Component)this.m_textField, "South");
    }

    @Override
    public Component getCustomEditor() {
        if (this.m_textField == null) {
            this.initEditor();
        }
        this.m_textField.setText((String)super.getValue());
        return this.m_panel;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
    }

    @Override
    public Object getValue() {
        if (this.m_textField != null) {
            return this.m_textField.getText();
        }
        return super.getValue();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        gfx.drawChars("Edit".toCharArray(), 0, 4, box.x + 5, box.y + box.height - 5);
    }

    private String updateStyle(String text) {
        if (text == null || text.length() == 0) {
            this.m_tableModel.setRowCount(0);
            return "";
        }
        try {
            CSSStyleSheet cssStyleSheet = this.m_cssParser.parseStyleSheet(text);
            CSSRuleList rules = cssStyleSheet.getCssRules();
            this.m_tableModel.setRowCount(rules.getLength());
            int i = 0;
            while (i < rules.getLength()) {
                DCssStyleRule rule = (DCssStyleRule)rules.item(i);
                String selector = rule.getSelectorText();
                String ruleDecl = rule.getStyle().getCssText();
                this.m_tableModel.setValueAt(selector, i, 0);
                this.m_tableModel.setValueAt(ruleDecl, i, 1);
                ++i;
            }
            String css = cssStyleSheet.toString();
            int endIndex = css.lastIndexOf("}");
            if (endIndex != -1) {
                css = css.substring(0, endIndex + 1);
            }
            return css;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "alert", 0);
        }
        catch (CssException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "alert", 0);
        }
        return "";
    }
}

