/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.css.CssClassConstant;
import org.eclipse.vjet.dsf.css.CssIdConstant;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseTableSection;
import org.eclipse.vjet.dsf.html.dom.DCaption;
import org.eclipse.vjet.dsf.html.dom.DColGroup;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DTBody;
import org.eclipse.vjet.dsf.html.dom.DTFoot;
import org.eclipse.vjet.dsf.html.dom.DTHead;
import org.eclipse.vjet.dsf.html.dom.DTd;
import org.eclipse.vjet.dsf.html.dom.DTr;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.IDBlock;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DTable
extends BaseAttrsHtmlElement
implements IDBlock {
    private static final long serialVersionUID = 0x3733393333373733L;
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_RIGHT = "right";
    public static final String FRAME_VOID = "void";
    public static final String FRAME_ABOVE = "above";
    public static final String FRAME_BELOW = "below";
    public static final String FRAME_HSIDES = "hsides";
    public static final String FRAME_LHS = "lhs";
    public static final String FRAME_RHS = "rhs";
    public static final String FRAME_VSIDES = "vsides";
    public static final String FRAME_BOX = "box";
    public static final String FRAME_BORDER = "border";
    public static final String RULES_NONE = "none";
    public static final String RULES_GROUPS = "groups";
    public static final String RULES_ROWS = "rows";
    public static final String RULES_COLS = "cols";
    public static final String RULES_ALL = "all";
    private DHtmlCollection m_rows;
    private DHtmlCollection m_bodies;

    public DTable() {
        super(HtmlTypeEnum.TABLE);
    }

    public DTable(DHtmlDocument doc) {
        super(doc, HtmlTypeEnum.TABLE);
    }

    public DTable(String jif) {
        this();
        this.jif(jif);
    }

    public DTable(BaseHtmlElement ... elems) {
        this();
        this.add(elems);
    }

    @Override
    public HtmlTypeEnum htmlType() {
        return HtmlTypeEnum.TABLE;
    }

    public DCaption getHtmlCaption() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DCaption) {
                return (DCaption)((Object)child);
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public DTable setHtmlCaption(DCaption caption) {
        this.htmlDeleteCaption();
        if (caption != null) {
            this.add((DNode)caption);
        }
        return this;
    }

    public DCaption htmlCreateCaption() {
        DCaption section = this.getHtmlCaption();
        if (section != null) {
            return section;
        }
        section = new DCaption();
        this.add((DNode)section);
        return section;
    }

    public DTable htmlDeleteCaption() {
        DCaption old = this.getHtmlCaption();
        if (old != null) {
            this.removeChild((Node)((Object)old));
        }
        return this;
    }

    public DTHead getHtmlTHead() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DTHead) {
                return (DTHead)((Object)child);
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public DTable setHtmlTHead(DTHead tHead) {
        this.htmlDeleteTHead();
        if (tHead != null) {
            this.add((DNode)tHead);
        }
        return this;
    }

    public DTHead htmlCreateTHead() {
        DTHead section = this.getHtmlTHead();
        if (section != null) {
            return section;
        }
        section = new DTHead();
        this.add((DNode)section);
        return section;
    }

    public DTable htmlDeleteTHead() {
        DTHead old = this.getHtmlTHead();
        if (old != null) {
            this.removeChild((Node)((Object)old));
        }
        return this;
    }

    public DTFoot getHtmlTFoot() {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DTFoot) {
                return (DTFoot)((Object)child);
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public DTable setHtmlTFoot(DTFoot tFoot) {
        this.htmlDeleteTFoot();
        if (tFoot != null) {
            this.add((DNode)tFoot);
        }
        return this;
    }

    public DTFoot htmlCreateTFoot() {
        DTFoot section = this.getHtmlTFoot();
        if (section != null) {
            return section;
        }
        section = new DTFoot();
        this.add((DNode)section);
        return section;
    }

    public DTable htmlDeleteTFoot() {
        DTFoot old = this.getHtmlTFoot();
        if (old != null) {
            this.removeChild((Node)((Object)old));
        }
        return this;
    }

    public DHtmlCollection getHtmlRows() {
        if (this.m_rows == null) {
            this.m_rows = new DHtmlCollection(this, 7);
        }
        return this.m_rows;
    }

    public DHtmlCollection getHtmlTBodies() {
        if (this.m_bodies == null) {
            this.m_bodies = new DHtmlCollection(this, -2);
        }
        return this.m_bodies;
    }

    public String getHtmlAlign() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.align));
    }

    public DTable setHtmlAlign(String align) {
        this.setHtmlAttribute(EHtmlAttr.align, align);
        return this;
    }

    public String getHtmlBgColor() {
        return this.getHtmlAttribute(EHtmlAttr.bgcolor);
    }

    public DTable setHtmlBgColor(String bgColor) {
        this.setHtmlAttribute(EHtmlAttr.bgcolor, bgColor);
        return this;
    }

    public String getHtmlBorder() {
        return this.getHtmlAttribute(EHtmlAttr.border);
    }

    public DTable setHtmlBorder(String border) {
        this.setHtmlAttribute(EHtmlAttr.border, border);
        return this;
    }

    public DTable setHtmlBorder(int border) {
        return this.setHtmlBorder(Integer.toString(border));
    }

    public String getHtmlCellPadding() {
        return this.getHtmlAttribute(EHtmlAttr.cellpadding);
    }

    public DTable setHtmlCellPadding(String cellPadding) {
        this.setHtmlAttribute(EHtmlAttr.cellpadding, cellPadding);
        return this;
    }

    public DTable setHtmlCellPadding(int cellPadding) {
        return this.setHtmlCellPadding(Integer.toString(cellPadding));
    }

    public String getHtmlCellSpacing() {
        return this.getHtmlAttribute(EHtmlAttr.cellspacing);
    }

    public DTable setHtmlCellSpacing(String cellSpacing) {
        this.setHtmlAttribute(EHtmlAttr.cellspacing, cellSpacing);
        return this;
    }

    public DTable setHtmlCellSpacing(int spacing) {
        return this.setHtmlCellSpacing(String.valueOf(spacing));
    }

    public String getHtmlFrame() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.frame));
    }

    public DTable setHtmlFrame(String frame) {
        this.setHtmlAttribute(EHtmlAttr.frame, frame);
        return this;
    }

    public String getHtmlRules() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.rules));
    }

    public DTable setHtmlRules(String rules) {
        this.setHtmlAttribute(EHtmlAttr.rules, rules);
        return this;
    }

    public String getHtmlSummary() {
        return this.getHtmlAttribute(EHtmlAttr.summary);
    }

    public DTable setHtmlSummary(String summary) {
        this.setHtmlAttribute(EHtmlAttr.summary, summary);
        return this;
    }

    public String getHtmlWidth() {
        return this.getHtmlAttribute(EHtmlAttr.width);
    }

    public DTable setHtmlWidth(String width) {
        this.setHtmlAttribute(EHtmlAttr.width, width);
        return this;
    }

    public DTable setHtmlWidth(int width) {
        return this.setHtmlWidth(String.valueOf(width));
    }

    public DTr htmlInsertRow(int index) {
        DTr newRow = new DTr();
        this.insertRowX(index, newRow);
        return newRow;
    }

    void insertRowX(int index, DTr newRow) {
        Node lastSection = null;
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DTr) {
                if (index == 0) {
                    this.insertBefore((Node)((Object)newRow), child);
                    return;
                }
                --index;
            } else if (child instanceof BaseTableSection && ((BaseTableSection)((Object)child)).isHtmlTableBody()) {
                lastSection = child;
                if ((index = ((BaseTableSection)((Object)child)).insertRowX(index, newRow)) < 0) {
                    return;
                }
            }
            child = child.getNextSibling();
        }
        if (lastSection != null) {
            lastSection.appendChild((Node)((Object)newRow));
        } else {
            this.appendChild((Node)((Object)newRow));
        }
    }

    public DTable htmlDeleteRow(int index) {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DTr) {
                if (index == 0) {
                    this.removeChild(child);
                    return this;
                }
                --index;
            } else if (child instanceof BaseTableSection && (index = ((BaseTableSection)((Object)child)).deleteRowX(index)) < 0) {
                return this;
            }
            child = child.getNextSibling();
        }
        return this;
    }

    public DColGroup htmlAddColGroup() {
        DColGroup colGroup = new DColGroup();
        this.add((DNode)colGroup);
        return colGroup;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)EHtmlAttr.align.getAttributeName(), (Object)this.getHtmlAlign()) + Z.fmt((String)EHtmlAttr.bgcolor.getAttributeName(), (Object)this.getHtmlBgColor()) + Z.fmt((String)EHtmlAttr.border.getAttributeName(), (Object)this.getHtmlBorder()) + Z.fmt((String)HtmlTypeEnum.CAPTION.getName(), (Object)("" + (Object)((Object)this.getHtmlCaption()))) + Z.fmt((String)EHtmlAttr.cellpadding.getAttributeName(), (Object)this.getHtmlCellPadding()) + Z.fmt((String)EHtmlAttr.cellspacing.getAttributeName(), (Object)this.getHtmlCellSpacing()) + Z.fmt((String)EHtmlAttr.frame.getAttributeName(), (Object)this.getHtmlFrame()) + Z.fmt((String)EHtmlAttr.rules.getAttributeName(), (Object)this.getHtmlRules()) + Z.fmt((String)EHtmlAttr.summary.getAttributeName(), (Object)this.getHtmlSummary()) + Z.fmt((String)EHtmlAttr.width.getAttributeName(), (Object)this.getHtmlWidth());
    }

    public Object clone() throws CloneNotSupportedException {
        DTable clonedNode = (DTable)super.clone();
        clonedNode.m_rows = null;
        clonedNode.m_bodies = null;
        return clonedNode;
    }

    public DTable add(DNode newChild) throws DOMException {
        super.add(newChild);
        return this;
    }

    @Override
    public DTable add(BaseHtmlElement ... elems) throws DOMException {
        super.add(elems);
        return this;
    }

    public DTable add(String value) throws DOMException {
        super.add(value);
        return this;
    }

    public DTable addRaw(String value) throws DOMException {
        super.addRaw(value);
        return this;
    }

    public DTable dsfAccept(IDNodeVisitor visitor) {
        super.dsfAccept(visitor);
        return this;
    }

    public DTable dsfBroadcast(DsfEvent event) throws AbortDsfEventProcessingException {
        super.dsfBroadcast(event);
        return this;
    }

    public DTable setDsfRelationshipVerifier(IDNodeRelationshipVerifier relationshipVerifier) {
        super.setDsfRelationshipVerifier(relationshipVerifier);
        return this;
    }

    public DTable cloned() {
        return (DTable)super.cloned();
    }

    public DTable setDsfNamespace(DNamespace namespace) {
        super.setDsfNamespace(namespace);
        return this;
    }

    @Override
    public DTable setHtmlAccessKey(String accessKey) {
        super.setHtmlAccessKey(accessKey);
        return this;
    }

    @Override
    public DTable setHtmlClassName(String className) {
        super.setHtmlClassName(className);
        return this;
    }

    @Override
    public DTable setHtmlClassName(CssClassConstant ccc) {
        super.setHtmlClassName(ccc);
        return this;
    }

    @Override
    public DTable setHtmlContentEditable(String editable) {
        super.setHtmlContentEditable(editable);
        return this;
    }

    @Override
    public DTable setHtmlContextMenu(String contextMenu) {
        super.setHtmlContextMenu(contextMenu);
        return this;
    }

    @Override
    public DTable setHtmlDir(String dir) {
        super.setHtmlDir(dir);
        return this;
    }

    @Override
    public DTable setHtmlDraggable(String draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DTable setHtmlDraggable(boolean draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DTable setHtmlHidden(String hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DTable setHtmlHidden(boolean hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DTable setHtmlId(String id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DTable setHtmlId(CssIdConstant id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DTable setHtmlItem(String item) {
        super.setHtmlItem(item);
        return this;
    }

    @Override
    public DTable setHtmlItemProp(String itemProp) {
        super.setHtmlItemProp(itemProp);
        return this;
    }

    @Override
    public DTable setHtmlLang(String lang) {
        super.setHtmlLang(lang);
        return this;
    }

    @Override
    public DTable setHtmlSpellCheck(String spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DTable setHtmlSpellCheck(boolean spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DTable setHtmlStyleAsString(String styleString) {
        super.setHtmlStyleAsString(styleString);
        return this;
    }

    @Override
    public DTable setHtmlStyle(CSSStyleDeclaration style) {
        super.setHtmlStyle(style);
        return this;
    }

    @Override
    public DTable setHtmlSubject(String subject) {
        super.setHtmlSubject(subject);
        return this;
    }

    @Override
    public DTable setHtmlTabIndex(String tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DTable setHtmlTabIndex(int tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DTable setHtmlTitle(String title) {
        super.setHtmlTitle(title);
        return this;
    }

    @Override
    public DTable setHtmlOnAbort(String script) {
        super.setHtmlOnAbort(script);
        return this;
    }

    @Override
    public DTable setHtmlOnBlur(String onBlur) {
        super.setHtmlOnBlur(onBlur);
        return this;
    }

    @Override
    public DTable setHtmlOnCanPlay(String script) {
        super.setHtmlOnCanPlay(script);
        return this;
    }

    @Override
    public DTable setHtmlOnCanPlayThrough(String script) {
        super.setHtmlOnCanPlayThrough(script);
        return this;
    }

    @Override
    public DTable setHtmlOnChange(String script) {
        super.setHtmlOnChange(script);
        return this;
    }

    @Override
    public DTable setHtmlOnClick(String script) {
        super.setHtmlOnClick(script);
        return this;
    }

    @Override
    public DTable setHtmlOnContextMenu(String script) {
        super.setHtmlOnContextMenu(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDblClick(String script) {
        super.setHtmlOnDblClick(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDrag(String script) {
        super.setHtmlOnDrag(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDragEnd(String script) {
        super.setHtmlOnDragEnd(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDragEnter(String script) {
        super.setHtmlOnDragEnter(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDragLeave(String script) {
        super.setHtmlOnDragLeave(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDragOver(String script) {
        super.setHtmlOnDragOver(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDragStart(String script) {
        super.setHtmlOnDragStart(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDrop(String script) {
        super.setHtmlOnDrop(script);
        return this;
    }

    @Override
    public DTable setHtmlOnDurationChange(String script) {
        super.setHtmlOnDurationChange(script);
        return this;
    }

    @Override
    public DTable setHtmlOnEmptied(String script) {
        super.setHtmlOnEmptied(script);
        return this;
    }

    @Override
    public DTable setHtmlOnEnded(String script) {
        super.setHtmlOnEnded(script);
        return this;
    }

    @Override
    public DTable setHtmlOnError(String script) {
        super.setHtmlOnError(script);
        return this;
    }

    @Override
    public DTable setHtmlOnFocus(String script) {
        super.setHtmlOnFocus(script);
        return this;
    }

    @Override
    public DTable setHtmlOnFormChange(String script) {
        super.setHtmlOnFormChange(script);
        return this;
    }

    @Override
    public DTable setHtmlOnFormInput(String script) {
        super.setHtmlOnFormInput(script);
        return this;
    }

    @Override
    public DTable setHtmlOnInput(String script) {
        super.setHtmlOnInput(script);
        return this;
    }

    @Override
    public DTable setHtmlOnInvalid(String script) {
        super.setHtmlOnInvalid(script);
        return this;
    }

    @Override
    public DTable setHtmlOnKeyDown(String script) {
        super.setHtmlOnKeyDown(script);
        return this;
    }

    @Override
    public DTable setHtmlOnKeyPress(String script) {
        super.setHtmlOnKeyPress(script);
        return this;
    }

    @Override
    public DTable setHtmlOnKeyUp(String script) {
        super.setHtmlOnKeyUp(script);
        return this;
    }

    @Override
    public DTable setHtmlOnLoad(String script) {
        super.setHtmlOnLoad(script);
        return this;
    }

    @Override
    public DTable setHtmlOnLoadedData(String script) {
        super.setHtmlOnLoadedData(script);
        return this;
    }

    @Override
    public DTable setHtmlOnLoadedMetadata(String script) {
        super.setHtmlOnLoadedMetadata(script);
        return this;
    }

    @Override
    public DTable setHtmlOnLoadStart(String script) {
        super.setHtmlOnLoadStart(script);
        return this;
    }

    @Override
    public DTable setHtmlOnMouseDown(String script) {
        super.setHtmlOnMouseDown(script);
        return this;
    }

    @Override
    public DTable setHtmlOnMouseMove(String script) {
        super.setHtmlOnMouseMove(script);
        return this;
    }

    @Override
    public DTable setHtmlOnMouseOut(String script) {
        super.setHtmlOnMouseOut(script);
        return this;
    }

    @Override
    public DTable setHtmlOnMouseOver(String script) {
        super.setHtmlOnMouseOver(script);
        return this;
    }

    @Override
    public DTable setHtmlOnMouseUp(String script) {
        super.setHtmlOnMouseUp(script);
        return this;
    }

    @Override
    public DTable setHtmlOnMouseWheel(String script) {
        super.setHtmlOnMouseWheel(script);
        return this;
    }

    @Override
    public DTable setHtmlOnPause(String script) {
        super.setHtmlOnPause(script);
        return this;
    }

    @Override
    public DTable setHtmlOnPlay(String script) {
        super.setHtmlOnPlay(script);
        return this;
    }

    @Override
    public DTable setHtmlOnPlaying(String script) {
        super.setHtmlOnPlaying(script);
        return this;
    }

    @Override
    public DTable setHtmlOnProgress(String script) {
        super.setHtmlOnProgress(script);
        return this;
    }

    @Override
    public DTable setHtmlOnRateChange(String script) {
        super.setHtmlOnRateChange(script);
        return this;
    }

    @Override
    public DTable setHtmlOnReadyStateChange(String script) {
        super.setHtmlOnReadyStateChange(script);
        return this;
    }

    @Override
    public DTable setHtmlOnScroll(String script) {
        super.setHtmlOnScroll(script);
        return this;
    }

    @Override
    public DTable setHtmlOnSeeked(String script) {
        super.setHtmlOnSeeked(script);
        return this;
    }

    @Override
    public DTable setHtmlOnSeeking(String script) {
        super.setHtmlOnSeeking(script);
        return this;
    }

    @Override
    public DTable setHtmlOnSelect(String script) {
        super.setHtmlOnSelect(script);
        return this;
    }

    @Override
    public DTable setHtmlOnShow(String script) {
        super.setHtmlOnShow(script);
        return this;
    }

    @Override
    public DTable setHtmlOnStalled(String script) {
        super.setHtmlOnStalled(script);
        return this;
    }

    @Override
    public DTable setHtmlOnSubmit(String script) {
        super.setHtmlOnSubmit(script);
        return this;
    }

    @Override
    public DTable setHtmlOnSuspend(String script) {
        super.setHtmlOnSuspend(script);
        return this;
    }

    @Override
    public DTable setHtmlOnTimeUpdate(String script) {
        super.setHtmlOnTimeUpdate(script);
        return this;
    }

    @Override
    public DTable setHtmlOnVolumeChange(String script) {
        super.setHtmlOnVolumeChange(script);
        return this;
    }

    @Override
    public DTable setHtmlOnWaiting(String script) {
        super.setHtmlOnWaiting(script);
        return this;
    }

    @Override
    public DTable add(EventType eventType, ISimpleJsEventHandler handler) {
        super.add(eventType, handler);
        return this;
    }

    @Override
    public DTable add(EventType eventType, IJsFunc func) {
        super.add(eventType, func);
        return this;
    }

    @Override
    public DTable add(EventType eventType, String jsText) {
        super.add(eventType, jsText);
        return this;
    }

    @Override
    public DTable addBr() {
        super.addBr();
        return this;
    }

    @Override
    public DTable addBr(int howMany) {
        super.addBr(howMany);
        return this;
    }

    @Override
    public DTable addHtmlClassName(String className) {
        super.addHtmlClassName(className);
        return this;
    }

    @Override
    public DTable addHtmlClassName(CssClassConstant ccc) {
        super.addHtmlClassName(ccc);
        return this;
    }

    @Override
    public DTable jif(String jif) {
        super.jif(jif);
        return this;
    }

    public DCaption _caption() {
        return this._caption(-1);
    }

    public DCaption _caption(int count) {
        return (DCaption)((Object)this.getOrCreate(DCaption.class, count));
    }

    public DCaption _caption(String textValue) {
        return this._caption().setHtmlExtTextValue(textValue);
    }

    public DColGroup _colgroup() {
        return this._colgroup(-1);
    }

    public DColGroup _colgroup(int count) {
        return (DColGroup)((Object)this.getOrCreate(DColGroup.class, count));
    }

    public DTBody _tbody() {
        return this._tbody(-1);
    }

    public DTBody _tbody(int count) {
        return (DTBody)((Object)this.getOrCreate(DTBody.class, count));
    }

    public DTFoot _tfoot() {
        return this._tfoot(-1);
    }

    public DTFoot _tfoot(int count) {
        return (DTFoot)((Object)this.getOrCreate(DTFoot.class, count));
    }

    public DTHead _thead() {
        return this._thead(-1);
    }

    public DTHead _thead(int count) {
        return (DTHead)((Object)this.getOrCreate(DTHead.class, count));
    }

    public DTr _tr() {
        return this._tr(-1);
    }

    public DTr _tr(int count) {
        return (DTr)((Object)this.getOrCreate(DTr.class, count));
    }

    public DTr _tr(DTd ... cells) {
        DTr answer = this._tr();
        DTd[] dTdArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            DTd cell = dTdArray[n2];
            answer.add((DNode)cell);
            ++n2;
        }
        return answer;
    }
}

