/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

final class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;

    ObjectFactory() {
    }

    static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        String factoryClassName;
        ClassLoader cl;
        block43: {
            block44: {
                block41: {
                    cl = ObjectFactory.findClassLoader();
                    try {
                        String systemProp = System.getProperty(factoryId);
                        if (systemProp != null) {
                            return ObjectFactory.newInstance(systemProp, cl, true);
                        }
                    }
                    catch (SecurityException securityException) {}
                    factoryClassName = null;
                    if (propertiesFilename != null) break block44;
                    File propertiesFile = null;
                    boolean propertiesFileExists = false;
                    try {
                        String javah = System.getProperty("java.home");
                        propertiesFilename = String.valueOf(javah) + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                        propertiesFile = new File(propertiesFilename);
                        propertiesFileExists = propertiesFile.exists();
                    }
                    catch (SecurityException securityException) {
                        fLastModified = -1L;
                        fXercesProperties = null;
                    }
                    Class<ObjectFactory> clazz = ObjectFactory.class;
                    // MONITORENTER : org.eclipse.vjet.dsf.html.dom.ObjectFactory.class
                    boolean loadProperties = false;
                    FileInputStream fis = null;
                    try {
                        try {
                            block46: {
                                block45: {
                                    if (fLastModified < 0L) break block45;
                                    if (propertiesFileExists && fLastModified < (fLastModified = propertiesFile.lastModified())) {
                                        loadProperties = true;
                                        break block46;
                                    } else if (!propertiesFileExists) {
                                        fLastModified = -1L;
                                        fXercesProperties = null;
                                    }
                                    break block46;
                                }
                                if (propertiesFileExists) {
                                    loadProperties = true;
                                    fLastModified = propertiesFile.lastModified();
                                }
                            }
                            if (loadProperties) {
                                fXercesProperties = new Properties();
                                fis = new FileInputStream(propertiesFile);
                                fXercesProperties.load(fis);
                            }
                        }
                        catch (Exception exception) {
                            fXercesProperties = null;
                            fLastModified = -1L;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block41;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fis == null) throw throwable;
                        try {
                            fis.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                // MONITOREXIT : clazz
                if (fXercesProperties != null) {
                    factoryClassName = fXercesProperties.getProperty(factoryId);
                }
                break block43;
            }
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(new File(propertiesFilename));
                    Properties props = new Properties();
                    props.load(fis);
                    factoryClassName = props.getProperty(factoryId);
                }
                catch (Exception exception) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block43;
                }
            }
            catch (Throwable throwable) {
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (factoryClassName != null) {
            return ObjectFactory.newInstance(factoryClassName, cl, true);
        }
        Object provider = ObjectFactory.findJarServiceProvider(factoryId);
        if (provider != null) {
            return provider;
        }
        if (fallbackClassName != null) return ObjectFactory.newInstance(fallbackClassName, cl, true);
        throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
    }

    private static void debugPrintln(String msg) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader system;
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        ClassLoader chain = system = ClassLoader.getSystemClassLoader();
        while (true) {
            if (context == chain) {
                ClassLoader current = ObjectFactory.class.getClassLoader();
                chain = system;
                while (true) {
                    if (current == chain) {
                        return system;
                    }
                    if (chain == null) break;
                    chain = chain.getParent();
                }
                return current;
            }
            if (chain == null) break;
            chain = chain.getParent();
        }
        return context;
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class providerClass = ObjectFactory.findProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Class findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        Class<?> providerClass;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            int lastDot = className.lastIndexOf(".");
            String packageName = className;
            if (lastDot != -1) {
                packageName = className.substring(0, lastDot);
            }
            security.checkPackageAccess(packageName);
        }
        if (cl == null) {
            providerClass = Class.forName(className);
        } else {
            try {
                providerClass = cl.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                if (doFallback) {
                    ClassLoader current = ObjectFactory.class.getClassLoader();
                    if (current == null) {
                        providerClass = Class.forName(className);
                    }
                    if (cl != current) {
                        cl = current;
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
                throw x;
            }
        }
        return providerClass;
    }

    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        ClassLoader current;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ObjectFactory.findClassLoader();
        is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
        if (is == null && cl != (current = ObjectFactory.class.getClassLoader())) {
            cl = current;
            is = cl.getResourceAsStream(serviceId);
        }
        if (is == null) {
            return null;
        }
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            rd = new BufferedReader(new InputStreamReader(is), 80);
        }
        String factoryClassName = null;
        try {
            try {
                factoryClassName = rd.readLine();
            }
            catch (IOException iOException) {
                try {
                    rd.close();
                }
                catch (IOException iOException2) {}
                return null;
            }
        }
        catch (Throwable throwable) {
            try {
                rd.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            rd.close();
        }
        catch (IOException iOException) {}
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            return ObjectFactory.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    static final class ConfigurationError
    extends Error {
        static final long serialVersionUID = 2646822752226280048L;
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

