/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.schemas;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.schemas.IAttributeInfo;
import org.eclipse.vjet.dsf.html.schemas.IAttributeInfoMap;

public class AttributeInfoMapImpl
implements IAttributeInfoMap {
    private final Map<String, IAttributeInfo> m_attributeMap = new HashMap<String, IAttributeInfo>();

    @Override
    public IAttributeInfo get(String attributeName) {
        return this.m_attributeMap.get(attributeName);
    }

    @Override
    public void put(IAttributeInfo attributeInfo) {
        this.m_attributeMap.put(attributeInfo.getName(), attributeInfo);
    }

    @Override
    public Iterator<IAttributeInfo> iterator() {
        return this.m_attributeMap.values().iterator();
    }

    public static IAttributeInfoMap createUnmodifiable(final IAttributeInfoMap map) {
        return new IAttributeInfoMap(){

            @Override
            public IAttributeInfo get(String attributeName) {
                return map.get(attributeName);
            }

            @Override
            public void put(IAttributeInfo attributeInfo) {
                throw new DsfRuntimeException("can't modify unmodifiable map");
            }

            @Override
            public Iterator<IAttributeInfo> iterator() {
                return map.iterator();
            }
        };
    }
}

