/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class FetchType
extends AbstractEnumerator {
    public static final int DEFAULT = 0;
    public static final int EAGER = 1;
    public static final int LAZY = 2;
    public static final FetchType DEFAULT_LITERAL = new FetchType(0, "Default", "Default (Eager)");
    public static final FetchType EAGER_LITERAL = new FetchType(1, "Eager", "Eager");
    public static final FetchType LAZY_LITERAL = new FetchType(2, "Lazy", "Lazy");
    private static final FetchType[] VALUES_ARRAY = new FetchType[]{DEFAULT_LITERAL, EAGER_LITERAL, LAZY_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static FetchType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FetchType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FetchType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FetchType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FetchType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT_LITERAL;
            }
            case 1: {
                return EAGER_LITERAL;
            }
            case 2: {
                return LAZY_LITERAL;
            }
        }
        return null;
    }

    private FetchType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

