/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.ITableModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractAnnotationElementAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.dali.orm.adapters.java.StringAnnotationElementAdapter;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaTableModelAdapter
implements ITableModelAdapter {
    private Table table;
    private StringAnnotationElementAdapter specifiedNameAdapter = new StringAnnotationElementAdapter(this.buildSpecifiedNameElementInfo());
    private static final String TABLE_ANNOTATION = "Table";

    JavaTableModelAdapter() {
    }

    public void setTable(Table table) {
        this.table = table;
    }

    private AbstractAnnotationElementAdapter.AnnotationElementInfo buildSpecifiedNameElementInfo() {
        return new AbstractAnnotationElementAdapter.AnnotationElementInfo(){

            public void setPersValue(String newValue) {
                JavaTableModelAdapter.this.table.setSpecifiedName(newValue);
            }

            public String persValue() {
                return JavaTableModelAdapter.this.table.getSpecifiedName();
            }

            public String annotationElementName() {
                return "name";
            }

            public String annotationName() {
                return JavaTableModelAdapter.this.annotationName();
            }

            public Member member() {
                return JavaTableModelAdapter.this.member();
            }

            public String defaultValue() {
                return null;
            }
        };
    }

    protected Table getTable() {
        return this.table;
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.table.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.table.setDefaultName(name);
        }
    }

    protected String defaultName() {
        Entity entity = (Entity)this.table.eContainer();
        return entity.getName();
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        this.specifiedNameAdapter.updatePersElement(astRoot);
    }

    public void specifiedNameChanged() {
        this.specifiedNameAdapter.updateJavaElement();
    }

    protected Member member() {
        JavaPersistentTypeModelAdapter modelAdapter = (JavaPersistentTypeModelAdapter)((TypeMapping)this.table.eContainer()).getPersistentType().getModelAdapter();
        return modelAdapter.getType();
    }

    public ITextRange getTextRange() {
        return this.member().getTextRange(this.annotationName());
    }

    public ITextRange nameTextRange() {
        return this.specifiedNameAdapter.getTextRange();
    }

    protected String annotationName() {
        return TABLE_ANNOTATION;
    }
}

