/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.BasicMapping;
import org.eclipse.dali.orm.FetchType;
import org.eclipse.dali.orm.Optional;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.provider.BasicMappingItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class BasicMappingComposite
extends Composite
implements IPersistenceComposite {
    private boolean populating;
    private BasicMapping basicMapping;
    private EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private BasicMappingItemProvider mappingItemProvider;
    private ColumnComposite columnComposite;
    private ComboViewer fetchTypeComboViewer;
    private ComboViewer optionalComboViewer;
    private INotifyChangedListener mappingListener;
    static /* synthetic */ Class class$0;

    protected BasicMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.mappingItemProvider = (BasicMappingItemProvider)this.adapterFactory.createBasicMappingAdapter();
    }

    private void initializeLayout() {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(this, this.editingDomain, this.adapterFactory, "org.eclipse.dali.ui.mapping_column");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
        Label fetchTypeLabel = new Label((Composite)this, 16384);
        fetchTypeLabel.setText(DaliUiMessages.BasicMappingComposite_fetchType);
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.fetchTypeComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_fetchType");
        Label optionalLabel = new Label((Composite)this, 16384);
        optionalLabel.setText(DaliUiMessages.BasicMappingComposite_optional);
        this.optionalComboViewer = this.buildOptionalCombo(this);
        this.optionalComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.optionalComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_optional");
    }

    private ComboViewer buildFetchTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(FetchType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (BasicMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    FetchType fetchType = (FetchType)selection.getFirstElement();
                    if (!BasicMappingComposite.this.basicMapping.getFetchType().equals(fetchType)) {
                        BasicMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)BasicMappingComposite.this.editingDomain, (Object)BasicMappingComposite.this.basicMapping, (Object)OrmPackage.eINSTANCE.getBasicMapping_FetchType(), (Object)fetchType));
                    }
                }
            }
        });
        return viewer;
    }

    private ComboViewer buildOptionalCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(Optional.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (BasicMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    Optional optional = (Optional)selection.getFirstElement();
                    if (!BasicMappingComposite.this.basicMapping.getOptional().equals(optional)) {
                        BasicMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)BasicMappingComposite.this.editingDomain, (Object)BasicMappingComposite.this.basicMapping, (Object)OrmPackage.eINSTANCE.getBasicMapping_Optional(), (Object)optional));
                    }
                }
            }
        });
        return viewer;
    }

    public void populate(EObject model) {
        Optional optional;
        if (this.basicMapping != null) {
            this.mappingItemProvider.removeListener(this.getMappingListener());
            this.basicMapping.eAdapters().remove((Object)this.mappingItemProvider);
        }
        if (model == null) {
            this.basicMapping = null;
            this.columnComposite.populate(null);
            this.populating = false;
            return;
        }
        this.basicMapping = (BasicMapping)((PersistentAttribute)model).getAttributeMapping();
        this.mappingItemProvider.addListener(this.getMappingListener());
        this.basicMapping.eAdapters().add((Object)this.mappingItemProvider);
        if (this.basicMapping.getFetchType() == FetchType.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.DEFAULT_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.DEFAULT_LITERAL));
            }
        } else if (this.basicMapping.getFetchType() == FetchType.EAGER_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.EAGER_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.EAGER_LITERAL));
            }
        } else if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.LAZY_LITERAL) {
            this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.LAZY_LITERAL));
        }
        if ((optional = this.basicMapping.getOptional()) != ((StructuredSelection)this.optionalComboViewer.getSelection()).getFirstElement()) {
            this.optionalComboViewer.setSelection((ISelection)new StructuredSelection((Object)optional));
        }
        this.columnComposite.populate((EObject)this.basicMapping.getColumn());
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    if (((ViewerNotification)notification).getElement() instanceof BasicMapping) {
                        Class<?> clazz;
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("org.eclipse.dali.orm.BasicMapping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (notification.getFeatureID((Class)clazz2) == 2) {
                            FetchType fetchType = (FetchType)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, fetchType){
                                final /* synthetic */ 3 this$1;
                                private final /* synthetic */ FetchType val$fetchType;
                                {
                                    this.this$1 = var1_1;
                                    this.val$fetchType = fetchType;
                                }

                                public void run() {
                                    if (((StructuredSelection)BasicMappingComposite.access$3(3.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$fetchType) {
                                        BasicMappingComposite.access$3(3.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$fetchType));
                                    }
                                }
                            });
                        }
                        if ((clazz = class$0) == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.dali.orm.BasicMapping");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (notification.getFeatureID((Class)clazz) == 3) {
                            Optional optional = (Optional)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, optional){
                                final /* synthetic */ 3 this$1;
                                private final /* synthetic */ Optional val$optional;
                                {
                                    this.this$1 = var1_1;
                                    this.val$optional = optional;
                                }

                                public void run() {
                                    if (((StructuredSelection)BasicMappingComposite.access$4(3.access$0(this.this$1)).getSelection()).getFirstElement() != this.val$optional) {
                                        BasicMappingComposite.access$4(3.access$0(this.this$1)).setSelection((ISelection)new StructuredSelection((Object)this.val$optional));
                                    }
                                }
                            });
                        }
                    }
                }

                static /* synthetic */ BasicMappingComposite access$0(3 var0) {
                    return var0.BasicMappingComposite.this;
                }
            };
        }
        return this.mappingListener;
    }

    public boolean setFocus() {
        super.setFocus();
        return this.fetchTypeComboViewer.getCombo().setFocus();
    }

    public void dispose() {
        this.mappingItemProvider.removeListener(this.mappingListener);
        super.dispose();
    }

    static /* synthetic */ ComboViewer access$3(BasicMappingComposite basicMappingComposite) {
        return basicMappingComposite.fetchTypeComboViewer;
    }

    static /* synthetic */ ComboViewer access$4(BasicMappingComposite basicMappingComposite) {
        return basicMappingComposite.optionalComboViewer;
    }

    public static class BasicMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
            return new BasicMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

