/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.composites.action.ToggleLinkingAction;
import org.eclipse.dali.ui.selection.listener.PersistentOutlineSelectionListener;
import org.eclipse.dali.ui.views.PersistenceView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;

public class PersistenceOutlineView
extends PersistenceView {
    private static final String EMPTY_STRING = DaliUiMessages.PersistenceOutlineView_outlineNotAvailable;
    private boolean linkingWithEditorEnabled;

    public PersistenceOutlineView() {
        super(EMPTY_STRING);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IActionBars actionBars = ((IViewSite)this.getSite()).getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new ToggleLinkingAction(this));
        }
        this.listener = new PersistentOutlineSelectionListener(this.pageBookManager, OrmPackage.eINSTANCE.getPersistenceFile(), this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            Integer i = memento.getInteger("org.eclipse.dali.linkpropertiestoeditor");
            this.linkingWithEditorEnabled = i != null && i == 1;
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        memento.putInteger("org.eclipse.dali.linkpropertiestoeditor", this.linkingWithEditorEnabled ? 1 : 0);
        super.saveState(memento);
    }

    public boolean isLinkingWithEditorEnabled() {
        return this.linkingWithEditorEnabled;
    }

    public void setLinkingWithEditorEnabled(boolean linkingWithEditorEnabled) {
        this.linkingWithEditorEnabled = linkingWithEditorEnabled;
    }
}

