(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-json-languageservice/lib/umd/services/jsonDocumentSymbols", "../parser/yaml-documents"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Red Hat, Inc. All rights reserved.
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.YAMLDocumentSymbols = void 0;
    const jsonDocumentSymbols_1 = require("vscode-json-languageservice/lib/umd/services/jsonDocumentSymbols");
    const yaml_documents_1 = require("../parser/yaml-documents");
    class YAMLDocumentSymbols {
        constructor(schemaService) {
            this.jsonDocumentSymbols = new jsonDocumentSymbols_1.JSONDocumentSymbols(schemaService);
            const origKeyLabel = this.jsonDocumentSymbols.getKeyLabel;
            // override 'getKeyLabel' to handle complex mapping
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            this.jsonDocumentSymbols.getKeyLabel = (property) => {
                if (typeof property.keyNode.value === 'object') {
                    return property.keyNode.value.value;
                }
                else {
                    return origKeyLabel.call(this.jsonDocumentSymbols, property);
                }
            };
        }
        findDocumentSymbols(document, context = { resultLimit: Number.MAX_VALUE }) {
            const doc = yaml_documents_1.yamlDocumentsCache.getYamlDocument(document);
            if (!doc || doc['documents'].length === 0) {
                return null;
            }
            let results = [];
            for (const yamlDoc of doc['documents']) {
                if (yamlDoc.root) {
                    results = results.concat(this.jsonDocumentSymbols.findDocumentSymbols(document, yamlDoc, context));
                }
            }
            return results;
        }
        findHierarchicalDocumentSymbols(document, context = { resultLimit: Number.MAX_VALUE }) {
            const doc = yaml_documents_1.yamlDocumentsCache.getYamlDocument(document);
            if (!doc || doc['documents'].length === 0) {
                return null;
            }
            let results = [];
            for (const yamlDoc of doc['documents']) {
                if (yamlDoc.root) {
                    results = results.concat(this.jsonDocumentSymbols.findDocumentSymbols2(document, yamlDoc, context));
                }
            }
            return results;
        }
    }
    exports.YAMLDocumentSymbols = YAMLDocumentSymbols;
});
//# sourceMappingURL=documentSymbols.js.map