/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.joni.constants.internal.NodeType;

public abstract class Node
implements NodeType {
    public Node parent;
    protected int type;

    Node(int type) {
        this.type = type;
    }

    public final int getType() {
        return this.type;
    }

    public final int getType2Bit() {
        return 1 << this.getType();
    }

    protected void setChild(Node tgt) {
    }

    protected Node getChild() {
        return null;
    }

    public void replaceWith(Node with) {
        with.parent = this.parent;
        this.parent.setChild(with);
        this.parent = null;
    }

    public abstract String getName();

    protected abstract String toString(int var1);

    public String getAddressName() {
        return this.getName() + ":0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public final String toString() {
        StringBuilder s = new StringBuilder();
        s.append("<" + this.getAddressName() + " (" + (this.parent == null ? "NULL" : this.parent.getAddressName()) + ")>");
        return s + this.toString(0);
    }

    protected static String pad(Object value, int level) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder pad = new StringBuilder("  ");
        for (int i = 0; i < level; ++i) {
            pad.append((CharSequence)pad);
        }
        return value.toString().replace("\n", "\n" + pad);
    }

    public final boolean isSimple() {
        return (this.getType2Bit() & 0x1F) != 0;
    }

    public static TopNode newTop(Node root) {
        return new TopNode(root);
    }

    public static final class TopNode
    extends Node {
        private Node root;

        TopNode(Node root) {
            super(-1);
            root.parent = this;
            this.setChild(root);
        }

        public Node getRoot() {
            return this.root;
        }

        @Override
        public void setChild(Node node) {
            node.parent = this;
            this.root = node;
        }

        @Override
        public Node getChild() {
            return this.root;
        }

        @Override
        public String getName() {
            return "ROOT";
        }

        @Override
        public String toString(int level) {
            return "\n" + TopNode.pad(this.root, level + 1);
        }
    }
}

