import type { URI } from 'vscode-uri';
export type UriMap<T> = ReturnType<typeof createUriMap<T>>;
export declare function createUriMap<T>(caseSensitive?: boolean): {
    clear: () => void;
    values: () => IterableIterator<T>;
    keys: () => Generator<URI, void, unknown>;
    delete: (uri: URI) => boolean;
    get: (uri: URI) => T | undefined;
    has: (uri: URI) => boolean;
    set: (uri: URI, item: T) => Map<string, T>;
};
