/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.events;

import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.draw2d.FigureCanvas;

public final class MouseEvent {
    public final int button;
    public final int stateMask;
    public final int x;
    public final int y;
    public final Figure source;
    private boolean m_consumed;

    public MouseEvent(FigureCanvas canvas, org.eclipse.swt.events.MouseEvent event, Figure source) {
        this.button = event.button;
        this.stateMask = event.stateMask;
        this.source = source;
        Rectangle bounds = source.getBounds();
        Point location = new Point(event.x - bounds.x, event.y - bounds.y);
        location.x += canvas.getHorizontalScrollModel().getSelection();
        location.y += canvas.getVerticalScrollModel().getSelection();
        FigureUtils.translateAbsoluteToFigure(source, location);
        this.x = location.x;
        this.y = location.y;
    }

    public void consume() {
        this.m_consumed = true;
    }

    public boolean isConsumed() {
        return this.m_consumed;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("MouseEvent{source=");
        buffer.append(this.source);
        buffer.append(" button=");
        buffer.append(this.button);
        buffer.append(" stateMask=");
        buffer.append(this.stateMask);
        buffer.append(" x=");
        buffer.append(this.x);
        buffer.append(" y=");
        buffer.append(this.y);
        buffer.append('}');
        return buffer.toString();
    }
}

