/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.bindings;

import java.text.MessageFormat;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.databinding.Messages;

public final class UpdateStrategyInfo {
    public static final String[] VALUES = new String[]{"READ_ONCE", "READ", "READ_WRITE"};
    private Value m_strategyValue;

    public UpdateStrategyInfo(String value) {
        this.setStrategyValue(value);
        Assert.isNotNull((Object)((Object)this.m_strategyValue));
    }

    public UpdateStrategyInfo(Value strategyValue) {
        this.m_strategyValue = strategyValue;
    }

    public String getStrategySourceCode() {
        switch (this.m_strategyValue) {
            case READ_ONCE: {
                return "org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_ONCE";
            }
            case READ: {
                return "org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ";
            }
            case READ_WRITE: {
                return "org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE";
            }
        }
        Assert.fail((String)MessageFormat.format(Messages.UpdateStrategyInfo_errUndefined, new Object[]{this.m_strategyValue}));
        return null;
    }

    public String getStrategyValue() {
        switch (this.m_strategyValue) {
            case READ_ONCE: {
                return "READ_ONCE";
            }
            case READ: {
                return "READ";
            }
            case READ_WRITE: {
                return "READ_WRITE";
            }
        }
        Assert.fail((String)MessageFormat.format(Messages.UpdateStrategyInfo_errUndefined, new Object[]{this.m_strategyValue}));
        return null;
    }

    public void setStrategyValue(String value) {
        if (value.endsWith("READ_ONCE")) {
            this.m_strategyValue = Value.READ_ONCE;
        } else if (value.endsWith("READ")) {
            this.m_strategyValue = Value.READ;
        } else if (value.endsWith("READ_WRITE")) {
            this.m_strategyValue = Value.READ_WRITE;
        }
    }

    public static enum Value {
        READ_ONCE,
        READ,
        READ_WRITE;

    }
}

