/* ====================================================================
 * Copyright (c) 2002 Johnny Shelley.  All rights reserved.
 *
 * Bcrypt is licensed under the BSD software license. See the file
 * called 'LICENSE' that you should have received with this software
 * for details
 * ====================================================================
 */

#include "includes.h"
#include "defines.h"
#include "functions.h"

int getremain(uLong sz, int dv) {
  int r;

  r = sz / dv;
  r++;
  r = r * dv;
  r = r - sz;
  return(r);
}

int deletefile(char *file, BCoptions options, char *key, struct stat statbuf) {
  int lsize;
  long g;
  uLong j = 0, k = 0;
  signed char i;
  char *state, *garbage;
  FILE *fd;

  if (options.securedelete > 0) {
    lsize = sizeof(long);
    k = (statbuf.st_size / lsize) + 1;
    if ((state = malloc(257)) == NULL)
      memerror();

    initstate((unsigned long) key, state, 256);
    if ((garbage = malloc(lsize)) == NULL)
      memerror();

    fd = fopen(file, "r+b");
    if (!fd) {
        fprintf(stderr, "Error deleting file %s: %s\n", file, strerror(errno));
        return(1);
    }
    for (i = options.securedelete; i > 0; i--) {
      fseek(fd, 0, SEEK_SET);

      for (j = 0; j < k; j += lsize) {
        g = random();
        memcpy(garbage, &g, lsize);
        fwrite(garbage, lsize, 1, fd);
      }
      fflush(fd);
    }
    fclose(fd);
  }

  if (unlink(file)) {
    fprintf(stderr, "Error deleting file %s: %s\n", file, strerror(errno));
    return(1);
  }
  return(0);
}
