// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

#include "google/cloud/baremetalsolution/v2/internal/bare_metal_solution_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace baremetalsolution_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

BareMetalSolutionTracingStub::BareMetalSolutionTracingStub(
    std::shared_ptr<BareMetalSolutionStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::baremetalsolution::v2::ListInstancesResponse>
BareMetalSolutionTracingStub::ListInstances(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListInstancesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ListInstances");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListInstances(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionTracingStub::GetInstance(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::GetInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetInstance(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncUpdateInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::UpdateInstanceRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "UpdateInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateInstance(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::baremetalsolution::v2::Instance>
BareMetalSolutionTracingStub::RenameInstance(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::RenameInstanceRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "RenameInstance");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RenameInstance(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncResetInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::ResetInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ResetInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncResetInstance(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncStartInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::StartInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "StartInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStartInstance(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncStopInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::StopInstanceRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "StopInstance");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncStopInstance(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncEnableInteractiveSerialConsole(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::
        EnableInteractiveSerialConsoleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "EnableInteractiveSerialConsole");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncEnableInteractiveSerialConsole(cq, context, options,
                                                       request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncDisableInteractiveSerialConsole(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::
        DisableInteractiveSerialConsoleRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "DisableInteractiveSerialConsole");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDisableInteractiveSerialConsole(cq, context, options,
                                                        request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncDetachLun(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::DetachLunRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "DetachLun");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDetachLun(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::baremetalsolution::v2::ListSSHKeysResponse>
BareMetalSolutionTracingStub::ListSSHKeys(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListSSHKeysRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ListSSHKeys");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListSSHKeys(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::SSHKey>
BareMetalSolutionTracingStub::CreateSSHKey(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::CreateSSHKeyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "CreateSSHKey");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateSSHKey(context, request));
}

Status BareMetalSolutionTracingStub::DeleteSSHKey(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::DeleteSSHKeyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "DeleteSSHKey");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteSSHKey(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ListVolumesResponse>
BareMetalSolutionTracingStub::ListVolumes(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListVolumesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ListVolumes");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListVolumes(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionTracingStub::GetVolume(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::GetVolumeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "GetVolume");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetVolume(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncUpdateVolume(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::UpdateVolumeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "UpdateVolume");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateVolume(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::baremetalsolution::v2::Volume>
BareMetalSolutionTracingStub::RenameVolume(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::RenameVolumeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "RenameVolume");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RenameVolume(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncEvictVolume(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::EvictVolumeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "EvictVolume");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncEvictVolume(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncResizeVolume(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::ResizeVolumeRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ResizeVolume");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncResizeVolume(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::baremetalsolution::v2::ListNetworksResponse>
BareMetalSolutionTracingStub::ListNetworks(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListNetworksRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ListNetworks");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListNetworks(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ListNetworkUsageResponse>
BareMetalSolutionTracingStub::ListNetworkUsage(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListNetworkUsageRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "ListNetworkUsage");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListNetworkUsage(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionTracingStub::GetNetwork(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::GetNetworkRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "GetNetwork");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetNetwork(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncUpdateNetwork(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::UpdateNetworkRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "UpdateNetwork");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateNetwork(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionTracingStub::CreateVolumeSnapshot(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::CreateVolumeSnapshotRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "CreateVolumeSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateVolumeSnapshot(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncRestoreVolumeSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::RestoreVolumeSnapshotRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "RestoreVolumeSnapshot");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRestoreVolumeSnapshot(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

Status BareMetalSolutionTracingStub::DeleteVolumeSnapshot(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::DeleteVolumeSnapshotRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "DeleteVolumeSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteVolumeSnapshot(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::VolumeSnapshot>
BareMetalSolutionTracingStub::GetVolumeSnapshot(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::GetVolumeSnapshotRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "GetVolumeSnapshot");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetVolumeSnapshot(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ListVolumeSnapshotsResponse>
BareMetalSolutionTracingStub::ListVolumeSnapshots(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListVolumeSnapshotsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "ListVolumeSnapshots");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListVolumeSnapshots(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::Lun>
BareMetalSolutionTracingStub::GetLun(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::GetLunRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "GetLun");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetLun(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ListLunsResponse>
BareMetalSolutionTracingStub::ListLuns(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListLunsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ListLuns");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->ListLuns(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncEvictLun(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::EvictLunRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "EvictLun");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncEvictLun(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionTracingStub::GetNfsShare(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::GetNfsShareRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "GetNfsShare");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetNfsShare(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ListNfsSharesResponse>
BareMetalSolutionTracingStub::ListNfsShares(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListNfsSharesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ListNfsShares");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListNfsShares(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncUpdateNfsShare(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::UpdateNfsShareRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "UpdateNfsShare");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateNfsShare(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncCreateNfsShare(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::CreateNfsShareRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "CreateNfsShare");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateNfsShare(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::baremetalsolution::v2::NfsShare>
BareMetalSolutionTracingStub::RenameNfsShare(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::RenameNfsShareRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "RenameNfsShare");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RenameNfsShare(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncDeleteNfsShare(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::baremetalsolution::v2::DeleteNfsShareRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "DeleteNfsShare");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteNfsShare(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::baremetalsolution::v2::ListProvisioningQuotasResponse>
BareMetalSolutionTracingStub::ListProvisioningQuotas(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListProvisioningQuotasRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "ListProvisioningQuotas");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListProvisioningQuotas(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::SubmitProvisioningConfigResponse>
BareMetalSolutionTracingStub::SubmitProvisioningConfig(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::SubmitProvisioningConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "SubmitProvisioningConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SubmitProvisioningConfig(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionTracingStub::GetProvisioningConfig(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::GetProvisioningConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "GetProvisioningConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetProvisioningConfig(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionTracingStub::CreateProvisioningConfig(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::CreateProvisioningConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "CreateProvisioningConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateProvisioningConfig(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ProvisioningConfig>
BareMetalSolutionTracingStub::UpdateProvisioningConfig(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::UpdateProvisioningConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution",
      "UpdateProvisioningConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateProvisioningConfig(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::Network>
BareMetalSolutionTracingStub::RenameNetwork(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::RenameNetworkRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "RenameNetwork");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RenameNetwork(context, request));
}

StatusOr<google::cloud::baremetalsolution::v2::ListOSImagesResponse>
BareMetalSolutionTracingStub::ListOSImages(
    grpc::ClientContext& context,
    google::cloud::baremetalsolution::v2::ListOSImagesRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.baremetalsolution.v2.BareMetalSolution", "ListOSImages");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListOSImages(context, request));
}

future<StatusOr<google::longrunning::Operation>>
BareMetalSolutionTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> BareMetalSolutionTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<BareMetalSolutionStub> MakeBareMetalSolutionTracingStub(
    std::shared_ptr<BareMetalSolutionStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<BareMetalSolutionTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace baremetalsolution_v2_internal
}  // namespace cloud
}  // namespace google
