// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/connection/v1/connection.proto

#include "google/cloud/bigquery/connection/v1/internal/connection_connection_impl.h"
#include "google/cloud/bigquery/connection/v1/internal/connection_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_connection_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<bigquery_connection_v1::ConnectionServiceRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<bigquery_connection_v1::ConnectionServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<bigquery_connection_v1::ConnectionServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    bigquery_connection_v1::ConnectionServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<bigquery_connection_v1::
               ConnectionServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

ConnectionServiceConnectionImpl::ConnectionServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<bigquery_connection_v1_internal::ConnectionServiceStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), ConnectionServiceConnection::options())) {}

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceConnectionImpl::CreateConnection(
    google::cloud::bigquery::connection::v1::CreateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateConnection(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::connection::v1::
                 CreateConnectionRequest const& request) {
        return stub_->CreateConnection(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceConnectionImpl::GetConnection(
    google::cloud::bigquery::connection::v1::GetConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetConnection(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::bigquery::connection::v1::GetConnectionRequest const&
              request) { return stub_->GetConnection(context, request); },
      request, __func__);
}

StreamRange<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceConnectionImpl::ListConnections(
    google::cloud::bigquery::connection::v1::ListConnectionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListConnections(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::bigquery::connection::v1::Connection>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           bigquery_connection_v1::ConnectionServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::bigquery::connection::v1::ListConnectionsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::bigquery::connection::v1::
                       ListConnectionsRequest const& request) {
              return stub->ListConnections(context, request);
            },
            r, function_name);
      },
      [](google::cloud::bigquery::connection::v1::ListConnectionsResponse r) {
        std::vector<google::cloud::bigquery::connection::v1::Connection> result(
            r.connections().size());
        auto& messages = *r.mutable_connections();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::bigquery::connection::v1::Connection>
ConnectionServiceConnectionImpl::UpdateConnection(
    google::cloud::bigquery::connection::v1::UpdateConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateConnection(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::connection::v1::
                 UpdateConnectionRequest const& request) {
        return stub_->UpdateConnection(context, request);
      },
      request, __func__);
}

Status ConnectionServiceConnectionImpl::DeleteConnection(
    google::cloud::bigquery::connection::v1::DeleteConnectionRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteConnection(request),
      [this](grpc::ClientContext& context,
             google::cloud::bigquery::connection::v1::
                 DeleteConnectionRequest const& request) {
        return stub_->DeleteConnection(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> ConnectionServiceConnectionImpl::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::GetIamPolicyRequest const& request) {
        return stub_->GetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::Policy> ConnectionServiceConnectionImpl::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->SetIamPolicy(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::SetIamPolicyRequest const& request) {
        return stub_->SetIamPolicy(context, request);
      },
      request, __func__);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
ConnectionServiceConnectionImpl::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->TestIamPermissions(request),
      [this](grpc::ClientContext& context,
             google::iam::v1::TestIamPermissionsRequest const& request) {
        return stub_->TestIamPermissions(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_connection_v1_internal
}  // namespace cloud
}  // namespace google
