// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V1_CLOUD_BUILD_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V1_CLOUD_BUILD_CONNECTION_H

#include "google/cloud/cloudbuild/v1/cloud_build_connection_idempotency_policy.h"
#include "google/cloud/cloudbuild/v1/internal/cloud_build_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/devtools/cloudbuild/v1/cloudbuild.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace cloudbuild_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `CloudBuildConnection`.
class CloudBuildRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<CloudBuildRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `CloudBuildConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class CloudBuildLimitedErrorCountRetryPolicy : public CloudBuildRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit CloudBuildLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  CloudBuildLimitedErrorCountRetryPolicy(
      CloudBuildLimitedErrorCountRetryPolicy&& rhs) noexcept
      : CloudBuildLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  CloudBuildLimitedErrorCountRetryPolicy(
      CloudBuildLimitedErrorCountRetryPolicy const& rhs) noexcept
      : CloudBuildLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<CloudBuildRetryPolicy> clone() const override {
    return std::make_unique<CloudBuildLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = CloudBuildRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      cloudbuild_v1_internal::CloudBuildRetryTraits>
      impl_;
};

/**
 * A retry policy for `CloudBuildConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class CloudBuildLimitedTimeRetryPolicy : public CloudBuildRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit CloudBuildLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  CloudBuildLimitedTimeRetryPolicy(
      CloudBuildLimitedTimeRetryPolicy&& rhs) noexcept
      : CloudBuildLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  CloudBuildLimitedTimeRetryPolicy(
      CloudBuildLimitedTimeRetryPolicy const& rhs) noexcept
      : CloudBuildLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<CloudBuildRetryPolicy> clone() const override {
    return std::make_unique<CloudBuildLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = CloudBuildRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      cloudbuild_v1_internal::CloudBuildRetryTraits>
      impl_;
};

/**
 * The `CloudBuildConnection` object for `CloudBuildClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `CloudBuildClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `CloudBuildClient`.
 *
 * To create a concrete instance, see `MakeCloudBuildConnection()`.
 *
 * For mocking, see `cloudbuild_v1_mocks::MockCloudBuildConnection`.
 */
class CloudBuildConnection {
 public:
  virtual ~CloudBuildConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::devtools::cloudbuild::v1::Build>> CreateBuild(
      google::devtools::cloudbuild::v1::CreateBuildRequest const& request);

  virtual StatusOr<google::devtools::cloudbuild::v1::Build> GetBuild(
      google::devtools::cloudbuild::v1::GetBuildRequest const& request);

  virtual StreamRange<google::devtools::cloudbuild::v1::Build> ListBuilds(
      google::devtools::cloudbuild::v1::ListBuildsRequest request);

  virtual StatusOr<google::devtools::cloudbuild::v1::Build> CancelBuild(
      google::devtools::cloudbuild::v1::CancelBuildRequest const& request);

  virtual future<StatusOr<google::devtools::cloudbuild::v1::Build>> RetryBuild(
      google::devtools::cloudbuild::v1::RetryBuildRequest const& request);

  virtual future<StatusOr<google::devtools::cloudbuild::v1::Build>>
  ApproveBuild(
      google::devtools::cloudbuild::v1::ApproveBuildRequest const& request);

  virtual StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
  CreateBuildTrigger(
      google::devtools::cloudbuild::v1::CreateBuildTriggerRequest const&
          request);

  virtual StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
  GetBuildTrigger(
      google::devtools::cloudbuild::v1::GetBuildTriggerRequest const& request);

  virtual StreamRange<google::devtools::cloudbuild::v1::BuildTrigger>
  ListBuildTriggers(
      google::devtools::cloudbuild::v1::ListBuildTriggersRequest request);

  virtual Status DeleteBuildTrigger(
      google::devtools::cloudbuild::v1::DeleteBuildTriggerRequest const&
          request);

  virtual StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
  UpdateBuildTrigger(
      google::devtools::cloudbuild::v1::UpdateBuildTriggerRequest const&
          request);

  virtual future<StatusOr<google::devtools::cloudbuild::v1::Build>>
  RunBuildTrigger(
      google::devtools::cloudbuild::v1::RunBuildTriggerRequest const& request);

  virtual StatusOr<
      google::devtools::cloudbuild::v1::ReceiveTriggerWebhookResponse>
  ReceiveTriggerWebhook(
      google::devtools::cloudbuild::v1::ReceiveTriggerWebhookRequest const&
          request);

  virtual future<StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>
  CreateWorkerPool(
      google::devtools::cloudbuild::v1::CreateWorkerPoolRequest const& request);

  virtual StatusOr<google::devtools::cloudbuild::v1::WorkerPool> GetWorkerPool(
      google::devtools::cloudbuild::v1::GetWorkerPoolRequest const& request);

  virtual future<StatusOr<
      google::devtools::cloudbuild::v1::DeleteWorkerPoolOperationMetadata>>
  DeleteWorkerPool(
      google::devtools::cloudbuild::v1::DeleteWorkerPoolRequest const& request);

  virtual future<StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>
  UpdateWorkerPool(
      google::devtools::cloudbuild::v1::UpdateWorkerPoolRequest const& request);

  virtual StreamRange<google::devtools::cloudbuild::v1::WorkerPool>
  ListWorkerPools(
      google::devtools::cloudbuild::v1::ListWorkerPoolsRequest request);
};

/**
 * A factory function to construct an object of type `CloudBuildConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of CloudBuildClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `CloudBuildConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::cloudbuild_v1::CloudBuildPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `CloudBuildConnection` created by
 * this function.
 */
std::shared_ptr<CloudBuildConnection> MakeCloudBuildConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_CLOUDBUILD_V1_CLOUD_BUILD_CONNECTION_H
