// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/global_public_delegated_prefixes/v1/global_public_delegated_prefixes.proto

#include "google/cloud/compute/global_public_delegated_prefixes/v1/global_public_delegated_prefixes_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_global_public_delegated_prefixes_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GlobalPublicDelegatedPrefixesClient::GlobalPublicDelegatedPrefixesClient(
    std::shared_ptr<GlobalPublicDelegatedPrefixesConnection> connection,
    Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
GlobalPublicDelegatedPrefixesClient::~GlobalPublicDelegatedPrefixesClient() =
    default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesClient::DeletePublicDelegatedPrefix(
    std::string const& project, std::string const& public_delegated_prefix,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
      DeletePublicDelegatedPrefixRequest request;
  request.set_project(project);
  request.set_public_delegated_prefix(public_delegated_prefix);
  return connection_->DeletePublicDelegatedPrefix(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesClient::DeletePublicDelegatedPrefix(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        DeletePublicDelegatedPrefixRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePublicDelegatedPrefix(request);
}

StatusOr<google::cloud::cpp::compute::v1::PublicDelegatedPrefix>
GlobalPublicDelegatedPrefixesClient::GetPublicDelegatedPrefix(
    std::string const& project, std::string const& public_delegated_prefix,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
      GetPublicDelegatedPrefixRequest request;
  request.set_project(project);
  request.set_public_delegated_prefix(public_delegated_prefix);
  return connection_->GetPublicDelegatedPrefix(request);
}

StatusOr<google::cloud::cpp::compute::v1::PublicDelegatedPrefix>
GlobalPublicDelegatedPrefixesClient::GetPublicDelegatedPrefix(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        GetPublicDelegatedPrefixRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPublicDelegatedPrefix(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesClient::InsertPublicDelegatedPrefix(
    std::string const& project,
    google::cloud::cpp::compute::v1::PublicDelegatedPrefix const&
        public_delegated_prefix_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
      InsertPublicDelegatedPrefixRequest request;
  request.set_project(project);
  *request.mutable_public_delegated_prefix_resource() =
      public_delegated_prefix_resource;
  return connection_->InsertPublicDelegatedPrefix(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesClient::InsertPublicDelegatedPrefix(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        InsertPublicDelegatedPrefixRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertPublicDelegatedPrefix(request);
}

StreamRange<google::cloud::cpp::compute::v1::PublicDelegatedPrefix>
GlobalPublicDelegatedPrefixesClient::ListGlobalPublicDelegatedPrefixes(
    std::string const& project, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
      ListGlobalPublicDelegatedPrefixesRequest request;
  request.set_project(project);
  return connection_->ListGlobalPublicDelegatedPrefixes(request);
}

StreamRange<google::cloud::cpp::compute::v1::PublicDelegatedPrefix>
GlobalPublicDelegatedPrefixesClient::ListGlobalPublicDelegatedPrefixes(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        ListGlobalPublicDelegatedPrefixesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGlobalPublicDelegatedPrefixes(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesClient::PatchPublicDelegatedPrefix(
    std::string const& project, std::string const& public_delegated_prefix,
    google::cloud::cpp::compute::v1::PublicDelegatedPrefix const&
        public_delegated_prefix_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
      PatchPublicDelegatedPrefixRequest request;
  request.set_project(project);
  request.set_public_delegated_prefix(public_delegated_prefix);
  *request.mutable_public_delegated_prefix_resource() =
      public_delegated_prefix_resource;
  return connection_->PatchPublicDelegatedPrefix(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesClient::PatchPublicDelegatedPrefix(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        PatchPublicDelegatedPrefixRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchPublicDelegatedPrefix(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_global_public_delegated_prefixes_v1
}  // namespace cloud
}  // namespace google
