// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/license_codes/v1/license_codes.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_LICENSE_CODES_V1_INTERNAL_LICENSE_CODES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_LICENSE_CODES_V1_INTERNAL_LICENSE_CODES_TRACING_CONNECTION_H

#include "google/cloud/compute/license_codes/v1/license_codes_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_license_codes_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class LicenseCodesTracingConnection
    : public compute_license_codes_v1::LicenseCodesConnection {
 public:
  ~LicenseCodesTracingConnection() override = default;

  explicit LicenseCodesTracingConnection(
      std::shared_ptr<compute_license_codes_v1::LicenseCodesConnection> child);

  Options options() override { return child_->options(); }

  StatusOr<google::cloud::cpp::compute::v1::LicenseCode> GetLicenseCode(
      google::cloud::cpp::compute::license_codes::v1::
          GetLicenseCodeRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
  TestIamPermissions(google::cloud::cpp::compute::license_codes::v1::
                         TestIamPermissionsRequest const& request) override;

 private:
  std::shared_ptr<compute_license_codes_v1::LicenseCodesConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_license_codes_v1::LicenseCodesConnection>
MakeLicenseCodesTracingConnection(
    std::shared_ptr<compute_license_codes_v1::LicenseCodesConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_license_codes_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_LICENSE_CODES_V1_INTERNAL_LICENSE_CODES_TRACING_CONNECTION_H
