// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/machine_types/v1/machine_types.proto

#include "google/cloud/compute/machine_types/v1/machine_types_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_machine_types_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MachineTypesClient::MachineTypesClient(
    std::shared_ptr<MachineTypesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
MachineTypesClient::~MachineTypesClient() = default;

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::MachineTypesScopedList>>
MachineTypesClient::AggregatedListMachineTypes(std::string const& project,
                                               Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_types::v1::
      AggregatedListMachineTypesRequest request;
  request.set_project(project);
  return connection_->AggregatedListMachineTypes(request);
}

StreamRange<std::pair<std::string,
                      google::cloud::cpp::compute::v1::MachineTypesScopedList>>
MachineTypesClient::AggregatedListMachineTypes(
    google::cloud::cpp::compute::machine_types::v1::
        AggregatedListMachineTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregatedListMachineTypes(std::move(request));
}

StatusOr<google::cloud::cpp::compute::v1::MachineType>
MachineTypesClient::GetMachineType(std::string const& project,
                                   std::string const& zone,
                                   std::string const& machine_type,
                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_types::v1::GetMachineTypeRequest request;
  request.set_project(project);
  request.set_zone(zone);
  request.set_machine_type(machine_type);
  return connection_->GetMachineType(request);
}

StatusOr<google::cloud::cpp::compute::v1::MachineType>
MachineTypesClient::GetMachineType(
    google::cloud::cpp::compute::machine_types::v1::GetMachineTypeRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetMachineType(request);
}

StreamRange<google::cloud::cpp::compute::v1::MachineType>
MachineTypesClient::ListMachineTypes(std::string const& project,
                                     std::string const& zone, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::machine_types::v1::ListMachineTypesRequest
      request;
  request.set_project(project);
  request.set_zone(zone);
  return connection_->ListMachineTypes(request);
}

StreamRange<google::cloud::cpp::compute::v1::MachineType>
MachineTypesClient::ListMachineTypes(
    google::cloud::cpp::compute::machine_types::v1::ListMachineTypesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListMachineTypes(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_machine_types_v1
}  // namespace cloud
}  // namespace google
