// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/service.proto

#include "google/cloud/dataplex/v1/internal/dataplex_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DataplexServiceTracingConnection::DataplexServiceTracingConnection(
    std::shared_ptr<dataplex_v1::DataplexServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::dataplex::v1::Lake>>
DataplexServiceTracingConnection::CreateLake(
    google::cloud::dataplex::v1::CreateLakeRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::CreateLake");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateLake(request));
}

future<StatusOr<google::cloud::dataplex::v1::Lake>>
DataplexServiceTracingConnection::UpdateLake(
    google::cloud::dataplex::v1::UpdateLakeRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::UpdateLake");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateLake(request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceTracingConnection::DeleteLake(
    google::cloud::dataplex::v1::DeleteLakeRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::DeleteLake");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteLake(request));
}

StreamRange<google::cloud::dataplex::v1::Lake>
DataplexServiceTracingConnection::ListLakes(
    google::cloud::dataplex::v1::ListLakesRequest request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::ListLakes");
  internal::OTelScope scope(span);
  auto sr = child_->ListLakes(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Lake>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::Lake>
DataplexServiceTracingConnection::GetLake(
    google::cloud::dataplex::v1::GetLakeRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::GetLake");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLake(request));
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceTracingConnection::ListLakeActions(
    google::cloud::dataplex::v1::ListLakeActionsRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::ListLakeActions");
  internal::OTelScope scope(span);
  auto sr = child_->ListLakeActions(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Action>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::dataplex::v1::Zone>>
DataplexServiceTracingConnection::CreateZone(
    google::cloud::dataplex::v1::CreateZoneRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::CreateZone");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateZone(request));
}

future<StatusOr<google::cloud::dataplex::v1::Zone>>
DataplexServiceTracingConnection::UpdateZone(
    google::cloud::dataplex::v1::UpdateZoneRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::UpdateZone");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateZone(request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceTracingConnection::DeleteZone(
    google::cloud::dataplex::v1::DeleteZoneRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::DeleteZone");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteZone(request));
}

StreamRange<google::cloud::dataplex::v1::Zone>
DataplexServiceTracingConnection::ListZones(
    google::cloud::dataplex::v1::ListZonesRequest request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::ListZones");
  internal::OTelScope scope(span);
  auto sr = child_->ListZones(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Zone>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::Zone>
DataplexServiceTracingConnection::GetZone(
    google::cloud::dataplex::v1::GetZoneRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::GetZone");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetZone(request));
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceTracingConnection::ListZoneActions(
    google::cloud::dataplex::v1::ListZoneActionsRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::ListZoneActions");
  internal::OTelScope scope(span);
  auto sr = child_->ListZoneActions(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Action>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::dataplex::v1::Asset>>
DataplexServiceTracingConnection::CreateAsset(
    google::cloud::dataplex::v1::CreateAssetRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::CreateAsset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateAsset(request));
}

future<StatusOr<google::cloud::dataplex::v1::Asset>>
DataplexServiceTracingConnection::UpdateAsset(
    google::cloud::dataplex::v1::UpdateAssetRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::UpdateAsset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateAsset(request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceTracingConnection::DeleteAsset(
    google::cloud::dataplex::v1::DeleteAssetRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::DeleteAsset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteAsset(request));
}

StreamRange<google::cloud::dataplex::v1::Asset>
DataplexServiceTracingConnection::ListAssets(
    google::cloud::dataplex::v1::ListAssetsRequest request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::ListAssets");
  internal::OTelScope scope(span);
  auto sr = child_->ListAssets(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Asset>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::Asset>
DataplexServiceTracingConnection::GetAsset(
    google::cloud::dataplex::v1::GetAssetRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::GetAsset");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAsset(request));
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceTracingConnection::ListAssetActions(
    google::cloud::dataplex::v1::ListAssetActionsRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::ListAssetActions");
  internal::OTelScope scope(span);
  auto sr = child_->ListAssetActions(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Action>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::dataplex::v1::Task>>
DataplexServiceTracingConnection::CreateTask(
    google::cloud::dataplex::v1::CreateTaskRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::CreateTask");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTask(request));
}

future<StatusOr<google::cloud::dataplex::v1::Task>>
DataplexServiceTracingConnection::UpdateTask(
    google::cloud::dataplex::v1::UpdateTaskRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::UpdateTask");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateTask(request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceTracingConnection::DeleteTask(
    google::cloud::dataplex::v1::DeleteTaskRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::DeleteTask");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTask(request));
}

StreamRange<google::cloud::dataplex::v1::Task>
DataplexServiceTracingConnection::ListTasks(
    google::cloud::dataplex::v1::ListTasksRequest request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::ListTasks");
  internal::OTelScope scope(span);
  auto sr = child_->ListTasks(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Task>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::Task>
DataplexServiceTracingConnection::GetTask(
    google::cloud::dataplex::v1::GetTaskRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::GetTask");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTask(request));
}

StreamRange<google::cloud::dataplex::v1::Job>
DataplexServiceTracingConnection::ListJobs(
    google::cloud::dataplex::v1::ListJobsRequest request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::ListJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListJobs(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Job>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::RunTaskResponse>
DataplexServiceTracingConnection::RunTask(
    google::cloud::dataplex::v1::RunTaskRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::RunTask");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RunTask(request));
}

StatusOr<google::cloud::dataplex::v1::Job>
DataplexServiceTracingConnection::GetJob(
    google::cloud::dataplex::v1::GetJobRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::GetJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetJob(request));
}

Status DataplexServiceTracingConnection::CancelJob(
    google::cloud::dataplex::v1::CancelJobRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataplexServiceConnection::CancelJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelJob(request));
}

future<StatusOr<google::cloud::dataplex::v1::Environment>>
DataplexServiceTracingConnection::CreateEnvironment(
    google::cloud::dataplex::v1::CreateEnvironmentRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::CreateEnvironment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEnvironment(request));
}

future<StatusOr<google::cloud::dataplex::v1::Environment>>
DataplexServiceTracingConnection::UpdateEnvironment(
    google::cloud::dataplex::v1::UpdateEnvironmentRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::UpdateEnvironment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateEnvironment(request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceTracingConnection::DeleteEnvironment(
    google::cloud::dataplex::v1::DeleteEnvironmentRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::DeleteEnvironment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEnvironment(request));
}

StreamRange<google::cloud::dataplex::v1::Environment>
DataplexServiceTracingConnection::ListEnvironments(
    google::cloud::dataplex::v1::ListEnvironmentsRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::ListEnvironments");
  internal::OTelScope scope(span);
  auto sr = child_->ListEnvironments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dataplex::v1::Environment>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::Environment>
DataplexServiceTracingConnection::GetEnvironment(
    google::cloud::dataplex::v1::GetEnvironmentRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::GetEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEnvironment(request));
}

StreamRange<google::cloud::dataplex::v1::Session>
DataplexServiceTracingConnection::ListSessions(
    google::cloud::dataplex::v1::ListSessionsRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataplexServiceConnection::ListSessions");
  internal::OTelScope scope(span);
  auto sr = child_->ListSessions(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::Session>(
      std::move(span), std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dataplex_v1::DataplexServiceConnection>
MakeDataplexServiceTracingConnection(
    std::shared_ptr<dataplex_v1::DataplexServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DataplexServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
