// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/context.proto

#include "google/cloud/dialogflow_es/internal/contexts_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/v2/context.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ContextsStub::~ContextsStub() = default;

StatusOr<google::cloud::dialogflow::v2::ListContextsResponse>
DefaultContextsStub::ListContexts(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::ListContextsRequest const& request) {
  google::cloud::dialogflow::v2::ListContextsResponse response;
  auto status = grpc_stub_->ListContexts(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::Context>
DefaultContextsStub::GetContext(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::GetContextRequest const& request) {
  google::cloud::dialogflow::v2::Context response;
  auto status = grpc_stub_->GetContext(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::Context>
DefaultContextsStub::CreateContext(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::CreateContextRequest const& request) {
  google::cloud::dialogflow::v2::Context response;
  auto status = grpc_stub_->CreateContext(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::Context>
DefaultContextsStub::UpdateContext(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::UpdateContextRequest const& request) {
  google::cloud::dialogflow::v2::Context response;
  auto status = grpc_stub_->UpdateContext(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultContextsStub::DeleteContext(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::DeleteContextRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteContext(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

Status DefaultContextsStub::DeleteAllContexts(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::DeleteAllContextsRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteAllContexts(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
