// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/environment.proto

#include "google/cloud/dialogflow_es/internal/environments_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/v2/environment.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EnvironmentsStub::~EnvironmentsStub() = default;

StatusOr<google::cloud::dialogflow::v2::ListEnvironmentsResponse>
DefaultEnvironmentsStub::ListEnvironments(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::ListEnvironmentsRequest const& request) {
  google::cloud::dialogflow::v2::ListEnvironmentsResponse response;
  auto status = grpc_stub_->ListEnvironments(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::Environment>
DefaultEnvironmentsStub::GetEnvironment(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::GetEnvironmentRequest const& request) {
  google::cloud::dialogflow::v2::Environment response;
  auto status = grpc_stub_->GetEnvironment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::Environment>
DefaultEnvironmentsStub::CreateEnvironment(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::CreateEnvironmentRequest const& request) {
  google::cloud::dialogflow::v2::Environment response;
  auto status = grpc_stub_->CreateEnvironment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::dialogflow::v2::Environment>
DefaultEnvironmentsStub::UpdateEnvironment(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::UpdateEnvironmentRequest const& request) {
  google::cloud::dialogflow::v2::Environment response;
  auto status = grpc_stub_->UpdateEnvironment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultEnvironmentsStub::DeleteEnvironment(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::DeleteEnvironmentRequest const& request) {
  google::protobuf::Empty response;
  auto status = grpc_stub_->DeleteEnvironment(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::dialogflow::v2::EnvironmentHistory>
DefaultEnvironmentsStub::GetEnvironmentHistory(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::GetEnvironmentHistoryRequest const&
        request) {
  google::cloud::dialogflow::v2::EnvironmentHistory response;
  auto status = grpc_stub_->GetEnvironmentHistory(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
