// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/privacy/dlp/v2/dlp.proto

#include "google/cloud/dlp/v2/internal/dlp_connection_impl.h"
#include "google/cloud/dlp/v2/internal/dlp_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace dlp_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dlp_v2::DlpServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dlp_v2::DlpServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dlp_v2::DlpServiceBackoffPolicyOption>()->clone();
}

std::unique_ptr<dlp_v2::DlpServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<dlp_v2::DlpServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

DlpServiceConnectionImpl::DlpServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dlp_v2_internal::DlpServiceStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      DlpServiceConnection::options())) {}

StatusOr<google::privacy::dlp::v2::InspectContentResponse>
DlpServiceConnectionImpl::InspectContent(
    google::privacy::dlp::v2::InspectContentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->InspectContent(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::InspectContentRequest const& request) {
        return stub_->InspectContent(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::RedactImageResponse>
DlpServiceConnectionImpl::RedactImage(
    google::privacy::dlp::v2::RedactImageRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RedactImage(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::RedactImageRequest const& request) {
        return stub_->RedactImage(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DeidentifyContentResponse>
DlpServiceConnectionImpl::DeidentifyContent(
    google::privacy::dlp::v2::DeidentifyContentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeidentifyContent(request),
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::DeidentifyContentRequest const& request) {
        return stub_->DeidentifyContent(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::ReidentifyContentResponse>
DlpServiceConnectionImpl::ReidentifyContent(
    google::privacy::dlp::v2::ReidentifyContentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ReidentifyContent(request),
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::ReidentifyContentRequest const& request) {
        return stub_->ReidentifyContent(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::ListInfoTypesResponse>
DlpServiceConnectionImpl::ListInfoTypes(
    google::privacy::dlp::v2::ListInfoTypesRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListInfoTypes(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::ListInfoTypesRequest const& request) {
        return stub_->ListInfoTypes(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceConnectionImpl::CreateInspectTemplate(
    google::privacy::dlp::v2::CreateInspectTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateInspectTemplate(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateInspectTemplateRequest const&
                 request) {
        return stub_->CreateInspectTemplate(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceConnectionImpl::UpdateInspectTemplate(
    google::privacy::dlp::v2::UpdateInspectTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateInspectTemplate(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateInspectTemplateRequest const&
                 request) {
        return stub_->UpdateInspectTemplate(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::InspectTemplate>
DlpServiceConnectionImpl::GetInspectTemplate(
    google::privacy::dlp::v2::GetInspectTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetInspectTemplate(request),
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::GetInspectTemplateRequest const& request) {
        return stub_->GetInspectTemplate(context, request);
      },
      request, __func__);
}

StreamRange<google::privacy::dlp::v2::InspectTemplate>
DlpServiceConnectionImpl::ListInspectTemplates(
    google::privacy::dlp::v2::ListInspectTemplatesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListInspectTemplates(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::InspectTemplate>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dlp_v2::DlpServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::privacy::dlp::v2::ListInspectTemplatesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::privacy::dlp::v2::ListInspectTemplatesRequest const&
                       request) {
              return stub->ListInspectTemplates(context, request);
            },
            r, function_name);
      },
      [](google::privacy::dlp::v2::ListInspectTemplatesResponse r) {
        std::vector<google::privacy::dlp::v2::InspectTemplate> result(
            r.inspect_templates().size());
        auto& messages = *r.mutable_inspect_templates();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status DlpServiceConnectionImpl::DeleteInspectTemplate(
    google::privacy::dlp::v2::DeleteInspectTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteInspectTemplate(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteInspectTemplateRequest const&
                 request) {
        return stub_->DeleteInspectTemplate(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceConnectionImpl::CreateDeidentifyTemplate(
    google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDeidentifyTemplate(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const&
                 request) {
        return stub_->CreateDeidentifyTemplate(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceConnectionImpl::UpdateDeidentifyTemplate(
    google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDeidentifyTemplate(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const&
                 request) {
        return stub_->UpdateDeidentifyTemplate(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceConnectionImpl::GetDeidentifyTemplate(
    google::privacy::dlp::v2::GetDeidentifyTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDeidentifyTemplate(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::GetDeidentifyTemplateRequest const&
                 request) {
        return stub_->GetDeidentifyTemplate(context, request);
      },
      request, __func__);
}

StreamRange<google::privacy::dlp::v2::DeidentifyTemplate>
DlpServiceConnectionImpl::ListDeidentifyTemplates(
    google::privacy::dlp::v2::ListDeidentifyTemplatesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListDeidentifyTemplates(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::DeidentifyTemplate>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dlp_v2::DlpServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::privacy::dlp::v2::ListDeidentifyTemplatesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::privacy::dlp::v2::ListDeidentifyTemplatesRequest const&
                    request) {
              return stub->ListDeidentifyTemplates(context, request);
            },
            r, function_name);
      },
      [](google::privacy::dlp::v2::ListDeidentifyTemplatesResponse r) {
        std::vector<google::privacy::dlp::v2::DeidentifyTemplate> result(
            r.deidentify_templates().size());
        auto& messages = *r.mutable_deidentify_templates();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status DlpServiceConnectionImpl::DeleteDeidentifyTemplate(
    google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDeidentifyTemplate(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const&
                 request) {
        return stub_->DeleteDeidentifyTemplate(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceConnectionImpl::CreateJobTrigger(
    google::privacy::dlp::v2::CreateJobTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateJobTrigger(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateJobTriggerRequest const& request) {
        return stub_->CreateJobTrigger(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceConnectionImpl::UpdateJobTrigger(
    google::privacy::dlp::v2::UpdateJobTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateJobTrigger(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateJobTriggerRequest const& request) {
        return stub_->UpdateJobTrigger(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceConnectionImpl::HybridInspectJobTrigger(
    google::privacy::dlp::v2::HybridInspectJobTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->HybridInspectJobTrigger(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::HybridInspectJobTriggerRequest const&
                 request) {
        return stub_->HybridInspectJobTrigger(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::JobTrigger>
DlpServiceConnectionImpl::GetJobTrigger(
    google::privacy::dlp::v2::GetJobTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetJobTrigger(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::GetJobTriggerRequest const& request) {
        return stub_->GetJobTrigger(context, request);
      },
      request, __func__);
}

StreamRange<google::privacy::dlp::v2::JobTrigger>
DlpServiceConnectionImpl::ListJobTriggers(
    google::privacy::dlp::v2::ListJobTriggersRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListJobTriggers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::JobTrigger>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dlp_v2::DlpServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::privacy::dlp::v2::ListJobTriggersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::privacy::dlp::v2::ListJobTriggersRequest const&
                       request) {
              return stub->ListJobTriggers(context, request);
            },
            r, function_name);
      },
      [](google::privacy::dlp::v2::ListJobTriggersResponse r) {
        std::vector<google::privacy::dlp::v2::JobTrigger> result(
            r.job_triggers().size());
        auto& messages = *r.mutable_job_triggers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status DlpServiceConnectionImpl::DeleteJobTrigger(
    google::privacy::dlp::v2::DeleteJobTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteJobTrigger(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteJobTriggerRequest const& request) {
        return stub_->DeleteJobTrigger(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DlpJob>
DlpServiceConnectionImpl::ActivateJobTrigger(
    google::privacy::dlp::v2::ActivateJobTriggerRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ActivateJobTrigger(request),
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::ActivateJobTriggerRequest const& request) {
        return stub_->ActivateJobTrigger(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceConnectionImpl::CreateDiscoveryConfig(
    google::privacy::dlp::v2::CreateDiscoveryConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDiscoveryConfig(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateDiscoveryConfigRequest const&
                 request) {
        return stub_->CreateDiscoveryConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceConnectionImpl::UpdateDiscoveryConfig(
    google::privacy::dlp::v2::UpdateDiscoveryConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateDiscoveryConfig(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateDiscoveryConfigRequest const&
                 request) {
        return stub_->UpdateDiscoveryConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceConnectionImpl::GetDiscoveryConfig(
    google::privacy::dlp::v2::GetDiscoveryConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDiscoveryConfig(request),
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::GetDiscoveryConfigRequest const& request) {
        return stub_->GetDiscoveryConfig(context, request);
      },
      request, __func__);
}

StreamRange<google::privacy::dlp::v2::DiscoveryConfig>
DlpServiceConnectionImpl::ListDiscoveryConfigs(
    google::privacy::dlp::v2::ListDiscoveryConfigsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListDiscoveryConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::DiscoveryConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dlp_v2::DlpServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::privacy::dlp::v2::ListDiscoveryConfigsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::privacy::dlp::v2::ListDiscoveryConfigsRequest const&
                       request) {
              return stub->ListDiscoveryConfigs(context, request);
            },
            r, function_name);
      },
      [](google::privacy::dlp::v2::ListDiscoveryConfigsResponse r) {
        std::vector<google::privacy::dlp::v2::DiscoveryConfig> result(
            r.discovery_configs().size());
        auto& messages = *r.mutable_discovery_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status DlpServiceConnectionImpl::DeleteDiscoveryConfig(
    google::privacy::dlp::v2::DeleteDiscoveryConfigRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDiscoveryConfig(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteDiscoveryConfigRequest const&
                 request) {
        return stub_->DeleteDiscoveryConfig(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::DlpJob>
DlpServiceConnectionImpl::CreateDlpJob(
    google::privacy::dlp::v2::CreateDlpJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateDlpJob(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateDlpJobRequest const& request) {
        return stub_->CreateDlpJob(context, request);
      },
      request, __func__);
}

StreamRange<google::privacy::dlp::v2::DlpJob>
DlpServiceConnectionImpl::ListDlpJobs(
    google::privacy::dlp::v2::ListDlpJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListDlpJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::DlpJob>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dlp_v2::DlpServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::privacy::dlp::v2::ListDlpJobsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::privacy::dlp::v2::ListDlpJobsRequest const& request) {
              return stub->ListDlpJobs(context, request);
            },
            r, function_name);
      },
      [](google::privacy::dlp::v2::ListDlpJobsResponse r) {
        std::vector<google::privacy::dlp::v2::DlpJob> result(r.jobs().size());
        auto& messages = *r.mutable_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::privacy::dlp::v2::DlpJob> DlpServiceConnectionImpl::GetDlpJob(
    google::privacy::dlp::v2::GetDlpJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetDlpJob(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::GetDlpJobRequest const& request) {
        return stub_->GetDlpJob(context, request);
      },
      request, __func__);
}

Status DlpServiceConnectionImpl::DeleteDlpJob(
    google::privacy::dlp::v2::DeleteDlpJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteDlpJob(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteDlpJobRequest const& request) {
        return stub_->DeleteDlpJob(context, request);
      },
      request, __func__);
}

Status DlpServiceConnectionImpl::CancelDlpJob(
    google::privacy::dlp::v2::CancelDlpJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelDlpJob(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CancelDlpJobRequest const& request) {
        return stub_->CancelDlpJob(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceConnectionImpl::CreateStoredInfoType(
    google::privacy::dlp::v2::CreateStoredInfoTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateStoredInfoType(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::CreateStoredInfoTypeRequest const&
                 request) {
        return stub_->CreateStoredInfoType(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceConnectionImpl::UpdateStoredInfoType(
    google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateStoredInfoType(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const&
                 request) {
        return stub_->UpdateStoredInfoType(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::StoredInfoType>
DlpServiceConnectionImpl::GetStoredInfoType(
    google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetStoredInfoType(request),
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request) {
        return stub_->GetStoredInfoType(context, request);
      },
      request, __func__);
}

StreamRange<google::privacy::dlp::v2::StoredInfoType>
DlpServiceConnectionImpl::ListStoredInfoTypes(
    google::privacy::dlp::v2::ListStoredInfoTypesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListStoredInfoTypes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::privacy::dlp::v2::StoredInfoType>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dlp_v2::DlpServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::privacy::dlp::v2::ListStoredInfoTypesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::privacy::dlp::v2::ListStoredInfoTypesRequest const&
                       request) {
              return stub->ListStoredInfoTypes(context, request);
            },
            r, function_name);
      },
      [](google::privacy::dlp::v2::ListStoredInfoTypesResponse r) {
        std::vector<google::privacy::dlp::v2::StoredInfoType> result(
            r.stored_info_types().size());
        auto& messages = *r.mutable_stored_info_types();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status DlpServiceConnectionImpl::DeleteStoredInfoType(
    google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteStoredInfoType(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const&
                 request) {
        return stub_->DeleteStoredInfoType(context, request);
      },
      request, __func__);
}

StatusOr<google::privacy::dlp::v2::HybridInspectResponse>
DlpServiceConnectionImpl::HybridInspectDlpJob(
    google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->HybridInspectDlpJob(request),
      [this](
          grpc::ClientContext& context,
          google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request) {
        return stub_->HybridInspectDlpJob(context, request);
      },
      request, __func__);
}

Status DlpServiceConnectionImpl::FinishDlpJob(
    google::privacy::dlp::v2::FinishDlpJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->FinishDlpJob(request),
      [this](grpc::ClientContext& context,
             google::privacy::dlp::v2::FinishDlpJobRequest const& request) {
        return stub_->FinishDlpJob(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dlp_v2_internal
}  // namespace cloud
}  // namespace google
