// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/v2/policy.proto

#include "google/cloud/iam/v2/policies_connection.h"
#include "google/cloud/iam/v2/internal/policies_connection_impl.h"
#include "google/cloud/iam/v2/internal/policies_option_defaults.h"
#include "google/cloud/iam/v2/internal/policies_stub_factory.h"
#include "google/cloud/iam/v2/internal/policies_tracing_connection.h"
#include "google/cloud/iam/v2/policies_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace iam_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PoliciesConnection::~PoliciesConnection() = default;

StreamRange<google::iam::v2::Policy> PoliciesConnection::ListPolicies(
    google::iam::v2::
        ListPoliciesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::iam::v2::Policy>>();
}

StatusOr<google::iam::v2::Policy> PoliciesConnection::GetPolicy(
    google::iam::v2::GetPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::iam::v2::Policy>> PoliciesConnection::CreatePolicy(
    google::iam::v2::CreatePolicyRequest const&) {
  return google::cloud::make_ready_future<StatusOr<google::iam::v2::Policy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::iam::v2::Policy>> PoliciesConnection::UpdatePolicy(
    google::iam::v2::UpdatePolicyRequest const&) {
  return google::cloud::make_ready_future<StatusOr<google::iam::v2::Policy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::iam::v2::Policy>> PoliciesConnection::DeletePolicy(
    google::iam::v2::DeletePolicyRequest const&) {
  return google::cloud::make_ready_future<StatusOr<google::iam::v2::Policy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<PoliciesConnection> MakePoliciesConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 PoliciesPolicyOptionList>(options, __func__);
  options = iam_v2_internal::PoliciesDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      iam_v2_internal::CreateDefaultPoliciesStub(background->cq(), options);
  return iam_v2_internal::MakePoliciesTracingConnection(
      std::make_shared<iam_v2_internal::PoliciesConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iam_v2
}  // namespace cloud
}  // namespace google
