// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/memcache/v1/cloud_memcache.proto

#include "google/cloud/memcache/v1/internal/cloud_memcache_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace memcache_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudMemcacheTracingConnection::CloudMemcacheTracingConnection(
    std::shared_ptr<memcache_v1::CloudMemcacheConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::memcache::v1::Instance>
CloudMemcacheTracingConnection::ListInstances(
    google::cloud::memcache::v1::ListInstancesRequest request) {
  auto span =
      internal::MakeSpan("memcache_v1::CloudMemcacheConnection::ListInstances");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstances(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::memcache::v1::Instance>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::memcache::v1::Instance>
CloudMemcacheTracingConnection::GetInstance(
    google::cloud::memcache::v1::GetInstanceRequest const& request) {
  auto span =
      internal::MakeSpan("memcache_v1::CloudMemcacheConnection::GetInstance");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInstance(request));
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheTracingConnection::CreateInstance(
    google::cloud::memcache::v1::CreateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "memcache_v1::CloudMemcacheConnection::CreateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateInstance(request));
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheTracingConnection::UpdateInstance(
    google::cloud::memcache::v1::UpdateInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "memcache_v1::CloudMemcacheConnection::UpdateInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateInstance(request));
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheTracingConnection::UpdateParameters(
    google::cloud::memcache::v1::UpdateParametersRequest const& request) {
  auto span = internal::MakeSpan(
      "memcache_v1::CloudMemcacheConnection::UpdateParameters");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateParameters(request));
}

future<StatusOr<google::cloud::memcache::v1::OperationMetadata>>
CloudMemcacheTracingConnection::DeleteInstance(
    google::cloud::memcache::v1::DeleteInstanceRequest const& request) {
  auto span = internal::MakeSpan(
      "memcache_v1::CloudMemcacheConnection::DeleteInstance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteInstance(request));
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheTracingConnection::ApplyParameters(
    google::cloud::memcache::v1::ApplyParametersRequest const& request) {
  auto span = internal::MakeSpan(
      "memcache_v1::CloudMemcacheConnection::ApplyParameters");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ApplyParameters(request));
}

future<StatusOr<google::cloud::memcache::v1::Instance>>
CloudMemcacheTracingConnection::RescheduleMaintenance(
    google::cloud::memcache::v1::RescheduleMaintenanceRequest const& request) {
  auto span = internal::MakeSpan(
      "memcache_v1::CloudMemcacheConnection::RescheduleMaintenance");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->RescheduleMaintenance(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<memcache_v1::CloudMemcacheConnection>
MakeCloudMemcacheTracingConnection(
    std::shared_ptr<memcache_v1::CloudMemcacheConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<CloudMemcacheTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace memcache_v1_internal
}  // namespace cloud
}  // namespace google
