// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/uptime_service.proto

#include "google/cloud/monitoring/v3/internal/uptime_check_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

UptimeCheckServiceTracingStub::UptimeCheckServiceTracingStub(
    std::shared_ptr<UptimeCheckServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::monitoring::v3::ListUptimeCheckConfigsResponse>
UptimeCheckServiceTracingStub::ListUptimeCheckConfigs(
    grpc::ClientContext& context,
    google::monitoring::v3::ListUptimeCheckConfigsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.UptimeCheckService",
                                     "ListUptimeCheckConfigs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListUptimeCheckConfigs(context, request));
}

StatusOr<google::monitoring::v3::UptimeCheckConfig>
UptimeCheckServiceTracingStub::GetUptimeCheckConfig(
    grpc::ClientContext& context,
    google::monitoring::v3::GetUptimeCheckConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.UptimeCheckService",
                                     "GetUptimeCheckConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetUptimeCheckConfig(context, request));
}

StatusOr<google::monitoring::v3::UptimeCheckConfig>
UptimeCheckServiceTracingStub::CreateUptimeCheckConfig(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateUptimeCheckConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.UptimeCheckService",
                                     "CreateUptimeCheckConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateUptimeCheckConfig(context, request));
}

StatusOr<google::monitoring::v3::UptimeCheckConfig>
UptimeCheckServiceTracingStub::UpdateUptimeCheckConfig(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateUptimeCheckConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.UptimeCheckService",
                                     "UpdateUptimeCheckConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateUptimeCheckConfig(context, request));
}

Status UptimeCheckServiceTracingStub::DeleteUptimeCheckConfig(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteUptimeCheckConfigRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.UptimeCheckService",
                                     "DeleteUptimeCheckConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteUptimeCheckConfig(context, request));
}

StatusOr<google::monitoring::v3::ListUptimeCheckIpsResponse>
UptimeCheckServiceTracingStub::ListUptimeCheckIps(
    grpc::ClientContext& context,
    google::monitoring::v3::ListUptimeCheckIpsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.monitoring.v3.UptimeCheckService",
                                     "ListUptimeCheckIps");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListUptimeCheckIps(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<UptimeCheckServiceStub> MakeUptimeCheckServiceTracingStub(
    std::shared_ptr<UptimeCheckServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<UptimeCheckServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
