// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v2/service.proto

#include "google/cloud/notebooks/v2/notebook_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace notebooks_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

NotebookServiceConnectionIdempotencyPolicy::
    ~NotebookServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<NotebookServiceConnectionIdempotencyPolicy>
NotebookServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<NotebookServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::ListInstances(
    google::cloud::notebooks::v2::ListInstancesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::GetInstance(
    google::cloud::notebooks::v2::GetInstanceRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::CreateInstance(
    google::cloud::notebooks::v2::CreateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::UpdateInstance(
    google::cloud::notebooks::v2::UpdateInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::DeleteInstance(
    google::cloud::notebooks::v2::DeleteInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::StartInstance(
    google::cloud::notebooks::v2::StartInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::StopInstance(
    google::cloud::notebooks::v2::StopInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::ResetInstance(
    google::cloud::notebooks::v2::ResetInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
NotebookServiceConnectionIdempotencyPolicy::CheckInstanceUpgradability(
    google::cloud::notebooks::v2::CheckInstanceUpgradabilityRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::UpgradeInstance(
    google::cloud::notebooks::v2::UpgradeInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::RollbackInstance(
    google::cloud::notebooks::v2::RollbackInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency NotebookServiceConnectionIdempotencyPolicy::DiagnoseInstance(
    google::cloud::notebooks::v2::DiagnoseInstanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<NotebookServiceConnectionIdempotencyPolicy>
MakeDefaultNotebookServiceConnectionIdempotencyPolicy() {
  return std::make_unique<NotebookServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v2
}  // namespace cloud
}  // namespace google
