// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/policytroubleshooter/iam/v3/troubleshooter.proto

#include "google/cloud/policytroubleshooter/iam/v3/internal/policy_troubleshooter_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace policytroubleshooter_iam_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PolicyTroubleshooterTracingStub::PolicyTroubleshooterTracingStub(
    std::shared_ptr<PolicyTroubleshooterStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<
    google::cloud::policytroubleshooter::iam::v3::TroubleshootIamPolicyResponse>
PolicyTroubleshooterTracingStub::TroubleshootIamPolicy(
    grpc::ClientContext& context,
    google::cloud::policytroubleshooter::iam::v3::
        TroubleshootIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter",
      "TroubleshootIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->TroubleshootIamPolicy(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<PolicyTroubleshooterStub> MakePolicyTroubleshooterTracingStub(
    std::shared_ptr<PolicyTroubleshooterStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<PolicyTroubleshooterTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace policytroubleshooter_iam_v3_internal
}  // namespace cloud
}  // namespace google
