// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#include "google/cloud/vmwareengine/v1/vmware_engine_connection.h"
#include "google/cloud/vmwareengine/v1/internal/vmware_engine_connection_impl.h"
#include "google/cloud/vmwareengine/v1/internal/vmware_engine_option_defaults.h"
#include "google/cloud/vmwareengine/v1/internal/vmware_engine_stub_factory.h"
#include "google/cloud/vmwareengine/v1/internal/vmware_engine_tracing_connection.h"
#include "google/cloud/vmwareengine/v1/vmware_engine_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace vmwareengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VmwareEngineConnection::~VmwareEngineConnection() = default;

StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineConnection::ListPrivateClouds(
    google::cloud::vmwareengine::v1::
        ListPrivateCloudsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>>();
}

StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineConnection::GetPrivateCloud(
    google::cloud::vmwareengine::v1::GetPrivateCloudRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnection::CreatePrivateCloud(
    google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnection::UpdatePrivateCloud(
    google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnection::DeletePrivateCloud(
    google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnection::UndeletePrivateCloud(
    google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineConnection::ListClusters(
    google::cloud::vmwareengine::v1::
        ListClustersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::Cluster>>();
}

StatusOr<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineConnection::GetCluster(
    google::cloud::vmwareengine::v1::GetClusterRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineConnection::CreateCluster(
    google::cloud::vmwareengine::v1::CreateClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineConnection::UpdateCluster(
    google::cloud::vmwareengine::v1::UpdateClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::Cluster>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineConnection::DeleteCluster(
    google::cloud::vmwareengine::v1::DeleteClusterRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineConnection::ListSubnets(
    google::cloud::vmwareengine::v1::
        ListSubnetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::Subnet>>();
}

StatusOr<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineConnection::GetSubnet(
    google::cloud::vmwareengine::v1::GetSubnetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>
VmwareEngineConnection::UpdateSubnet(
    google::cloud::vmwareengine::v1::UpdateSubnetRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::Subnet>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineConnection::ListNodeTypes(
    google::cloud::vmwareengine::v1::
        ListNodeTypesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::NodeType>>();
}

StatusOr<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineConnection::GetNodeType(
    google::cloud::vmwareengine::v1::GetNodeTypeRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineConnection::ShowNsxCredentials(
    google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineConnection::ShowVcenterCredentials(
    google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnection::ResetNsxCredentials(
    google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineConnection::ResetVcenterCredentials(
    google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
VmwareEngineConnection::CreateHcxActivationKey(
    google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineConnection::ListHcxActivationKeys(
    google::cloud::vmwareengine::v1::
        ListHcxActivationKeysRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>>();
}

StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineConnection::GetHcxActivationKey(
    google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineConnection::GetNetworkPolicy(
    google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineConnection::ListNetworkPolicies(
    google::cloud::vmwareengine::v1::
        ListNetworkPoliciesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>>();
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineConnection::CreateNetworkPolicy(
    google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineConnection::UpdateNetworkPolicy(
    google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineConnection::DeleteNetworkPolicy(
    google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineConnection::CreateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineConnection::UpdateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineConnection::DeleteVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineConnection::GetVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineConnection::ListVmwareEngineNetworks(
    google::cloud::vmwareengine::v1::
        ListVmwareEngineNetworksRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>();
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineConnection::CreatePrivateConnection(
    google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineConnection::GetPrivateConnection(
    google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineConnection::ListPrivateConnections(
    google::cloud::vmwareengine::v1::
        ListPrivateConnectionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>>();
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineConnection::UpdatePrivateConnection(
    google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineConnection::DeletePrivateConnection(
    google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
VmwareEngineConnection::ListPrivateConnectionPeeringRoutes(
    google::cloud::vmwareengine::v1::
        ListPrivateConnectionPeeringRoutesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>>();
}

std::shared_ptr<VmwareEngineConnection> MakeVmwareEngineConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 VmwareEnginePolicyOptionList>(options,
                                                               __func__);
  options =
      vmwareengine_v1_internal::VmwareEngineDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = vmwareengine_v1_internal::CreateDefaultVmwareEngineStub(
      background->cq(), options);
  return vmwareengine_v1_internal::MakeVmwareEngineTracingConnection(
      std::make_shared<vmwareengine_v1_internal::VmwareEngineConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1
}  // namespace cloud
}  // namespace google
