// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/websecurityscanner/v1/web_security_scanner.proto

#include "google/cloud/websecurityscanner/v1/internal/web_security_scanner_connection_impl.h"
#include "google/cloud/websecurityscanner/v1/internal/web_security_scanner_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace websecurityscanner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<websecurityscanner_v1::WebSecurityScannerRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<websecurityscanner_v1::WebSecurityScannerRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<websecurityscanner_v1::WebSecurityScannerBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    websecurityscanner_v1::WebSecurityScannerConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<websecurityscanner_v1::
               WebSecurityScannerConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

WebSecurityScannerConnectionImpl::WebSecurityScannerConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<websecurityscanner_v1_internal::WebSecurityScannerStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), WebSecurityScannerConnection::options())) {}

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerConnectionImpl::CreateScanConfig(
    google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateScanConfig(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&
              request) { return stub_->CreateScanConfig(context, request); },
      request, __func__);
}

Status WebSecurityScannerConnectionImpl::DeleteScanConfig(
    google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteScanConfig(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&
              request) { return stub_->DeleteScanConfig(context, request); },
      request, __func__);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerConnectionImpl::GetScanConfig(
    google::cloud::websecurityscanner::v1::GetScanConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetScanConfig(request),
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::GetScanConfigRequest const&
                 request) { return stub_->GetScanConfig(context, request); },
      request, __func__);
}

StreamRange<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerConnectionImpl::ListScanConfigs(
    google::cloud::websecurityscanner::v1::ListScanConfigsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListScanConfigs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::websecurityscanner::v1::ScanConfig>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           websecurityscanner_v1::WebSecurityScannerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::websecurityscanner::v1::ListScanConfigsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::websecurityscanner::v1::
                       ListScanConfigsRequest const& request) {
              return stub->ListScanConfigs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::websecurityscanner::v1::ListScanConfigsResponse r) {
        std::vector<google::cloud::websecurityscanner::v1::ScanConfig> result(
            r.scan_configs().size());
        auto& messages = *r.mutable_scan_configs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::websecurityscanner::v1::ScanConfig>
WebSecurityScannerConnectionImpl::UpdateScanConfig(
    google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateScanConfig(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&
              request) { return stub_->UpdateScanConfig(context, request); },
      request, __func__);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerConnectionImpl::StartScanRun(
    google::cloud::websecurityscanner::v1::StartScanRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StartScanRun(request),
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::StartScanRunRequest const&
                 request) { return stub_->StartScanRun(context, request); },
      request, __func__);
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerConnectionImpl::GetScanRun(
    google::cloud::websecurityscanner::v1::GetScanRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetScanRun(request),
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::GetScanRunRequest const&
                 request) { return stub_->GetScanRun(context, request); },
      request, __func__);
}

StreamRange<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerConnectionImpl::ListScanRuns(
    google::cloud::websecurityscanner::v1::ListScanRunsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListScanRuns(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::websecurityscanner::v1::ScanRun>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           websecurityscanner_v1::WebSecurityScannerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::websecurityscanner::v1::ListScanRunsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::websecurityscanner::v1::
                       ListScanRunsRequest const& request) {
              return stub->ListScanRuns(context, request);
            },
            r, function_name);
      },
      [](google::cloud::websecurityscanner::v1::ListScanRunsResponse r) {
        std::vector<google::cloud::websecurityscanner::v1::ScanRun> result(
            r.scan_runs().size());
        auto& messages = *r.mutable_scan_runs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::websecurityscanner::v1::ScanRun>
WebSecurityScannerConnectionImpl::StopScanRun(
    google::cloud::websecurityscanner::v1::StopScanRunRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->StopScanRun(request),
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::StopScanRunRequest const&
                 request) { return stub_->StopScanRun(context, request); },
      request, __func__);
}

StreamRange<google::cloud::websecurityscanner::v1::CrawledUrl>
WebSecurityScannerConnectionImpl::ListCrawledUrls(
    google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListCrawledUrls(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::websecurityscanner::v1::CrawledUrl>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           websecurityscanner_v1::WebSecurityScannerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::websecurityscanner::v1::
                       ListCrawledUrlsRequest const& request) {
              return stub->ListCrawledUrls(context, request);
            },
            r, function_name);
      },
      [](google::cloud::websecurityscanner::v1::ListCrawledUrlsResponse r) {
        std::vector<google::cloud::websecurityscanner::v1::CrawledUrl> result(
            r.crawled_urls().size());
        auto& messages = *r.mutable_crawled_urls();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::websecurityscanner::v1::Finding>
WebSecurityScannerConnectionImpl::GetFinding(
    google::cloud::websecurityscanner::v1::GetFindingRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFinding(request),
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::GetFindingRequest const&
                 request) { return stub_->GetFinding(context, request); },
      request, __func__);
}

StreamRange<google::cloud::websecurityscanner::v1::Finding>
WebSecurityScannerConnectionImpl::ListFindings(
    google::cloud::websecurityscanner::v1::ListFindingsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListFindings(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::websecurityscanner::v1::Finding>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           websecurityscanner_v1::WebSecurityScannerRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::websecurityscanner::v1::ListFindingsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::websecurityscanner::v1::
                       ListFindingsRequest const& request) {
              return stub->ListFindings(context, request);
            },
            r, function_name);
      },
      [](google::cloud::websecurityscanner::v1::ListFindingsResponse r) {
        std::vector<google::cloud::websecurityscanner::v1::Finding> result(
            r.findings().size());
        auto& messages = *r.mutable_findings();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::websecurityscanner::v1::ListFindingTypeStatsResponse>
WebSecurityScannerConnectionImpl::ListFindingTypeStats(
    google::cloud::websecurityscanner::v1::ListFindingTypeStatsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListFindingTypeStats(request),
      [this](grpc::ClientContext& context,
             google::cloud::websecurityscanner::v1::
                 ListFindingTypeStatsRequest const& request) {
        return stub_->ListFindingTypeStats(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace websecurityscanner_v1_internal
}  // namespace cloud
}  // namespace google
