/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.basic.TransitiveRelation;
import com.sun.electric.tool.ncc.netlist.Bipolar;
import com.sun.electric.tool.ncc.netlist.ExportGlobal;
import com.sun.electric.tool.ncc.netlist.Mos;
import com.sun.electric.tool.ncc.netlist.NccCellInfo;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.PartType;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Resistor;
import com.sun.electric.tool.ncc.netlist.Subcircuit;
import com.sun.electric.tool.ncc.netlist.UserAbort;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.netlist.Wires;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import com.sun.electric.tool.user.ncc.NccComparisonMismatches;
import com.sun.electric.tool.user.ncc.UnrecognizedPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class Visitor
extends HierarchyEnumerator.Visitor {
    private static final boolean debug = false;
    private static final Technology SCHEMATIC = Technology.findTechnology("schematic");
    private final NccGlobals globals;
    private final String pathPrefix;
    private boolean exportAssertionFailures = false;
    private boolean badPartType = false;
    private int depth = 0;
    private Wires wires;
    private final ArrayList parts = new ArrayList();
    private final ArrayList ports = new ArrayList();
    private final HierarchyInfo hierarchicalCompareInfo;
    private final boolean blackBox;

    private void error(boolean pred, String msg) {
        this.globals.error(pred, msg);
    }

    private String spaces() {
        StringBuffer sp = new StringBuffer();
        for (int i = 0; i < this.depth; ++i) {
            sp.append(" ");
        }
        return sp.toString();
    }

    private void addMatchingNetIDs(List netIDs, NccCellAnnotations.NamePattern pattern, NccCellInfo rootInfo) {
        Iterator it = rootInfo.getExportsAndGlobals();
        while (it.hasNext()) {
            ExportGlobal eg = (ExportGlobal)it.next();
            if (!pattern.matches(eg.name)) continue;
            netIDs.add(new Integer(eg.netID));
        }
    }

    private void doExportsConnAnnot(TransitiveRelation mergedNetIDs, List connected, NccCellInfo rootInfo) {
        ArrayList netIDs = new ArrayList();
        Iterator it = connected.iterator();
        while (it.hasNext()) {
            this.addMatchingNetIDs(netIDs, (NccCellAnnotations.NamePattern)it.next(), rootInfo);
        }
        for (int i = 1; i < netIDs.size(); ++i) {
            mergedNetIDs.theseAreRelated(netIDs.get(0), netIDs.get(i));
        }
    }

    private void doExportsConnAnnots(TransitiveRelation mergedNetIDs, NccCellInfo rootInfo) {
        NccCellAnnotations ann = rootInfo.getAnnotations();
        if (ann == null) {
            return;
        }
        Iterator it = ann.getExportsConnected();
        while (it.hasNext()) {
            this.doExportsConnAnnot(mergedNetIDs, (List)it.next(), rootInfo);
        }
    }

    private void initWires(NccCellInfo rootInfo) {
        TransitiveRelation mergedNetIDs = new TransitiveRelation();
        this.doExportsConnAnnots(mergedNetIDs, rootInfo);
        this.wires = new Wires(mergedNetIDs, rootInfo, this.pathPrefix);
    }

    private void createPortsFromExports(NccCellInfo rootInfo) {
        HashSet<Port> portSet = new HashSet<Port>();
        Iterator it = rootInfo.getExportsAndGlobals();
        while (it.hasNext()) {
            ExportGlobal eg = (ExportGlobal)it.next();
            Wire wire = this.wires.get(eg.netID, rootInfo);
            portSet.add(wire.addExport(eg.name, eg.type));
        }
        it = portSet.iterator();
        while (it.hasNext()) {
            this.ports.add(it.next());
        }
    }

    private Wire getWireForPortInst(PortInst pi, HierarchyEnumerator.CellInfo info) {
        NodeInst ni = pi.getNodeInst();
        NodeProto np = ni.getProto();
        this.error(!(np instanceof PrimitiveNode), "not PrimitiveNode");
        PortProto pp = pi.getPortProto();
        int[] netIDs = info.getPortNetIDs(ni, pp);
        this.error(netIDs.length != 1, "Primitive Port connected to bus?");
        return this.wires.get(netIDs[0], info);
    }

    private boolean isSchematicPrimitive(NodeInst ni) {
        return ni.getProto().getTechnology() == SCHEMATIC;
    }

    private boolean isNmosPrimitive(NodeInst ni) {
        PrimitiveNode.Function func = ni.getFunction();
        return func == PrimitiveNode.Function.TRA4NMOS || func == PrimitiveNode.Function.TRANMOS;
    }

    private boolean isPmosPrimitive(NodeInst ni) {
        PrimitiveNode.Function func = ni.getFunction();
        return func == PrimitiveNode.Function.TRA4PMOS || func == PrimitiveNode.Function.TRAPMOS;
    }

    private boolean isNpnPrimitive(NodeInst ni) {
        PrimitiveNode.Function func = ni.getFunction();
        return func == PrimitiveNode.Function.TRANPN || func == PrimitiveNode.Function.TRA4NPN;
    }

    private boolean isPnpPrimitive(NodeInst ni) {
        PrimitiveNode.Function func = ni.getFunction();
        return func == PrimitiveNode.Function.TRAPNP || func == PrimitiveNode.Function.TRA4PNP;
    }

    private boolean isPrimitivePolyResistor(NodeInst ni) {
        PrimitiveNode.Function func = ni.getFunction();
        return func == PrimitiveNode.Function.PRESIST;
    }

    private PartType getMosType(NodeInst ni, NccCellInfo info) {
        String typeNm;
        if (this.isSchematicPrimitive(ni)) {
            Cell parent = ni.getParent();
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(parent);
            String string = typeNm = ann == null ? null : ann.getTransistorType();
            if (typeNm == null) {
                this.globals.error(!this.isNmosPrimitive(ni) && !this.isPmosPrimitive(ni), "not NMOS nor PMOS");
                typeNm = this.isNmosPrimitive(ni) ? "N-Transistor" : "P-Transistor";
            }
        } else {
            typeNm = ni.getProto().getName();
        }
        PartType t = Mos.TYPES.getTypeFromLongName(typeNm);
        if (t == null) {
            this.badPartType = true;
            this.prln("  Unrecognized transistor type: " + typeNm);
            this.globals.getComparisonResult().addUnrecognizedPart(new UnrecognizedPart(ni.getParent(), info.getContext(), typeNm, ni));
        }
        return t;
    }

    private void buildMos(NodeInst ni, NccCellInfo info) {
        HierarchyEnumerator.NodableNameProxy np = info.getUniqueNodableNameProxy(ni, "/");
        NccNameProxy.PartNameProxy name = new NccNameProxy.PartNameProxy(np, this.pathPrefix);
        double width = 0.0;
        double length = 0.0;
        if (this.globals.getOptions().checkSizes) {
            TransistorSize dim = ni.getTransistorSize(info.getContext());
            width = dim.getDoubleWidth();
            length = dim.getDoubleLength();
        }
        Wire s = this.getWireForPortInst(ni.getTransistorSourcePort(), info);
        Wire g = this.getWireForPortInst(ni.getTransistorGatePort(), info);
        Wire d = this.getWireForPortInst(ni.getTransistorDrainPort(), info);
        PartType type = this.getMosType(ni, info);
        if (type != null) {
            Mos t = new Mos(type, name, width, length, s, g, d);
            this.parts.add(t);
        }
    }

    private void buildBipolar(NodeInst ni, NccCellInfo info) {
        HierarchyEnumerator.NodableNameProxy np = info.getUniqueNodableNameProxy(ni, "/");
        NccNameProxy.PartNameProxy name = new NccNameProxy.PartNameProxy(np, this.pathPrefix);
        double area = 0.0;
        if (this.globals.getOptions().checkSizes) {
            TransistorSize dim = ni.getTransistorSize(info.getContext());
            area = dim != null ? dim.getDoubleArea() : 0.0;
        }
        Wire e = this.getWireForPortInst(ni.getTransistorEmitterPort(), info);
        Wire b = this.getWireForPortInst(ni.getTransistorBasePort(), info);
        Wire c = this.getWireForPortInst(ni.getTransistorCollectorPort(), info);
        Bipolar.Type type = this.isNpnPrimitive(ni) ? Bipolar.Type.NPN : Bipolar.Type.PNP;
        Bipolar t = new Bipolar(type, name, area, e, b, c);
        this.parts.add(t);
    }

    private void buildTransistor(NodeInst ni, NccCellInfo info) {
        if (this.isNmosPrimitive(ni) || this.isPmosPrimitive(ni)) {
            this.buildMos(ni, info);
        } else if (this.isPnpPrimitive(ni) || this.isNpnPrimitive(ni)) {
            this.buildBipolar(ni, info);
        } else {
            this.globals.error(true, "Unrecognized primitive transistor");
        }
    }

    private PartType getResistorType(NodeInst ni, NccCellInfo info) {
        String typeNm;
        if (this.isSchematicPrimitive(ni)) {
            Cell parent = ni.getParent();
            NccCellAnnotations ann = NccCellAnnotations.getAnnotations(parent);
            String string = typeNm = ann == null ? null : ann.getResistorType();
            if (typeNm == null) {
                typeNm = "No type specified. Use resistorType annotation";
            }
        } else {
            typeNm = ni.getProto().getName();
        }
        PartType t = Resistor.TYPES.getTypeFromLongName(typeNm);
        if (t == null) {
            this.badPartType = true;
            this.prln("  Unrecognized resistor type: " + typeNm);
            this.globals.getComparisonResult().addUnrecognizedPart(new UnrecognizedPart(ni.getParent(), info.getContext(), typeNm, ni));
        }
        return t;
    }

    private Wire[] getResistorWires(NodeInst ni, NccCellInfo info) {
        Wire a = this.getWireForPortInst(ni.getPortInst(0), info);
        Wire b = this.getWireForPortInst(ni.getPortInst(1), info);
        return new Wire[]{a, b};
    }

    private double getDoubleVariableValue(String varName, NodeInst ni, VarContext context) {
        Variable var = ni.getVar(varName);
        if (var == null) {
            return 0.0;
        }
        Object obj = context == null ? var.getObject() : context.evalVar(var, ni);
        return VarContext.objectToDouble(obj, 0.0);
    }

    private double[] getResistorSize(NodeInst ni, VarContext context) {
        double w = 0.0;
        double l = 0.0;
        if (this.isSchematicPrimitive(ni)) {
            w = this.getDoubleVariableValue("ATTR_width", ni, context);
            l = this.getDoubleVariableValue("ATTR_length", ni, context);
        } else {
            SizeOffset so = ni.getSizeOffset();
            w = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
            l = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
        }
        return new double[]{w, l};
    }

    private void buildResistor(NodeInst ni, NccCellInfo info) {
        HierarchyEnumerator.NodableNameProxy np = info.getUniqueNodableNameProxy(ni, "/");
        NccNameProxy.PartNameProxy name = new NccNameProxy.PartNameProxy(np, this.pathPrefix);
        double width = 0.0;
        double length = 0.0;
        if (this.globals.getOptions().checkSizes) {
            double[] dim = this.getResistorSize(ni, info.getContext());
            width = dim[0];
            length = dim[1];
        }
        Wire[] wires = this.getResistorWires(ni, info);
        PartType type = this.getResistorType(ni, info);
        if (type != null) {
            Resistor t = new Resistor(type, name, width, length, wires[0], wires[1]);
            this.parts.add(t);
        }
    }

    private void doPrimitiveNode(NodeInst ni, NodeProto np, NccCellInfo info) {
        PrimitiveNode.Function func = ni.getFunction();
        if (ni.isPrimitiveTransistor()) {
            this.buildTransistor(ni, info);
        } else if (this.isPrimitivePolyResistor(ni)) {
            this.buildResistor(ni, info);
        }
    }

    private void addToPins(Wire[] pins, int pinNdx, Wire w) {
        if (pins[pinNdx] == null) {
            pins[pinNdx] = w;
        } else {
            this.globals.error(pins[pinNdx] != w, "exports that should be connected aren't");
        }
    }

    private void pr(String s) {
        System.out.print(s);
    }

    private void prln(String s) {
        System.out.println(s);
    }

    private void printExports(HashSet exportNames) {
        this.pr("{ ");
        Iterator it = exportNames.iterator();
        while (it.hasNext()) {
            this.pr(((ExportGlobal)it.next()).name + " ");
        }
        this.pr("}");
    }

    private void printExportAssertionFailure(HashMap wireToExportGlobals, NccCellInfo info) {
        String instPath = NccNameProxy.removePrefix(this.pathPrefix, info.getContext().getInstPath("/"));
        String cellName = NccUtils.fullName(info.getCell());
        this.prln("  Assertion: exportsConnectedByParent in cell: " + cellName + " fails. Instance path is: " + instPath);
        this.prln("    The exports are connected to " + wireToExportGlobals.size() + " different networks");
        Iterator it = wireToExportGlobals.keySet().iterator();
        while (it.hasNext()) {
            Wire w = (Wire)it.next();
            this.pr("    On network: " + w.getName() + " are exports: ");
            this.printExports((HashSet)wireToExportGlobals.get(w));
            this.prln("");
        }
        VarContext context = info.getContext();
        Cell cell = info.getCell();
        NccComparisonMismatches cm = this.globals.getComparisonResult();
        Object[][] items = new Object[wireToExportGlobals.keySet().size()][];
        String[][] names = new String[wireToExportGlobals.keySet().size()][];
        int j = 0;
        Iterator it2 = wireToExportGlobals.keySet().iterator();
        while (it2.hasNext()) {
            HashSet exportGlobals = (HashSet)wireToExportGlobals.get(it2.next());
            items[j] = new Object[exportGlobals.size()];
            names[j] = new String[exportGlobals.size()];
            int i = 0;
            Iterator it22 = exportGlobals.iterator();
            while (it22.hasNext()) {
                ExportGlobal eg = (ExportGlobal)it22.next();
                names[j][i] = eg.name;
                items[j][i] = eg.isExport() ? eg.getExport() : eg.network;
                ++i;
            }
            ++j;
        }
        cm.addExportAssertionFailure(cell, context, items, names);
    }

    private void matchExports(HashMap wireToExportGlobals, NccCellAnnotations.NamePattern pattern, NccCellInfo info) {
        Iterator it = info.getExportsAndGlobals();
        while (it.hasNext()) {
            ExportGlobal eg = (ExportGlobal)it.next();
            if (!pattern.matches(eg.name)) continue;
            Wire wire = this.wires.get(eg.netID, info);
            HashSet<ExportGlobal> exportGlobals = (HashSet<ExportGlobal>)wireToExportGlobals.get(wire);
            if (exportGlobals == null) {
                exportGlobals = new HashSet<ExportGlobal>();
                wireToExportGlobals.put(wire, exportGlobals);
            }
            exportGlobals.add(eg);
        }
    }

    private boolean exportAssertionFailure(List patterns, NccCellInfo info) {
        HashMap wireToExportGlobals = new HashMap();
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            this.matchExports(wireToExportGlobals, (NccCellAnnotations.NamePattern)it.next(), info);
        }
        if (wireToExportGlobals.size() <= 1) {
            return false;
        }
        this.printExportAssertionFailure(wireToExportGlobals, info);
        return true;
    }

    private boolean exportAssertionFailures(NccCellInfo info) {
        NccCellAnnotations ann = info.getAnnotations();
        if (ann == null) {
            return false;
        }
        boolean gotError = false;
        Iterator it = ann.getExportsConnected();
        while (it.hasNext()) {
            gotError |= this.exportAssertionFailure((List)it.next(), info);
        }
        return gotError;
    }

    private void doSubcircuit(SubcircuitInfo subcktInfo, NccCellInfo info) {
        Cell cell = info.getCell();
        Wire[] pins = new Wire[subcktInfo.numPorts()];
        Iterator it = info.getExportsAndGlobals();
        while (it.hasNext()) {
            ExportGlobal eg = (ExportGlobal)it.next();
            Wire wire = this.wires.get(eg.netID, info);
            int pinNdx = subcktInfo.getPortIndex(eg.name);
            this.addToPins(pins, pinNdx, wire);
        }
        for (int i = 0; i < pins.length; ++i) {
            this.globals.error(pins[i] == null, "disconnected subcircuit pins!");
        }
        HierarchyEnumerator.CellInfo parentInfo = info.getParentInfo();
        Nodable parentInst = info.getParentInst();
        HierarchyEnumerator.NodableNameProxy np = parentInfo.getUniqueNodableNameProxy(parentInst, "/");
        NccNameProxy.PartNameProxy name = new NccNameProxy.PartNameProxy(np, this.pathPrefix);
        this.parts.add(new Subcircuit(name, subcktInfo, pins));
    }

    private boolean parentSaysFlattenMe(NccCellInfo info) {
        if (info.isRootCell()) {
            return false;
        }
        NccCellInfo parentInfo = (NccCellInfo)info.getParentInfo();
        NccCellAnnotations parentAnn = parentInfo.getAnnotations();
        if (parentAnn == null) {
            return false;
        }
        Nodable no = info.getParentInst();
        String instName = no.getName();
        return parentAnn.flattenInstance(instName);
    }

    public HierarchyEnumerator.CellInfo newCellInfo() {
        return new NccCellInfo(this.globals);
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo ci) {
        if (this.globals.userWantsToAbort()) {
            throw new UserAbort();
        }
        NccCellInfo info = (NccCellInfo)ci;
        if (info.isRootCell()) {
            this.initWires(info);
            this.createPortsFromExports(info);
            if (this.blackBox) {
                return false;
            }
        } else {
            boolean exportAssertFail = this.exportAssertionFailures(info);
            this.exportAssertionFailures |= exportAssertFail;
            Cell cell = info.getCell();
            if (!this.parentSaysFlattenMe(info) && this.hierarchicalCompareInfo.treatAsPrimitive(cell) && !exportAssertFail) {
                SubcircuitInfo subcktInfo = this.hierarchicalCompareInfo.getSubcircuitInfo(cell);
                this.doSubcircuit(subcktInfo, info);
                return false;
            }
        }
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo ci) {
        NccCellInfo info = (NccCellInfo)ci;
        NodeProto np = no.getProto();
        if (np instanceof PrimitiveNode) {
            this.doPrimitiveNode((NodeInst)no, np, info);
            return false;
        }
        this.error(!(np instanceof Cell), "expecting Cell");
        return true;
    }

    public ArrayList getWireList() {
        return this.wires.getWireArray();
    }

    public ArrayList getPartList() {
        return this.parts;
    }

    public ArrayList getPortList() {
        return this.ports;
    }

    public boolean exportAssertionFailures() {
        return this.exportAssertionFailures;
    }

    public boolean badTransistorType() {
        return this.badPartType;
    }

    public Visitor(NccGlobals globals, HierarchyInfo hierarchicalCompareInfo, boolean blackBox, VarContext context) {
        this.globals = globals;
        this.hierarchicalCompareInfo = hierarchicalCompareInfo;
        this.blackBox = blackBox;
        this.pathPrefix = context.getInstPath("/");
    }
}

