/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.SetFocus;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.EditWindowFocusBrowser;
import com.sun.electric.tool.user.ui.MessagesWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.KeyStroke;

public class WindowMenu {
    private static EMenu thisWindowMenu = null;
    private static EMenuItem hiddenWindowCycleMenuItem = null;
    private static DynamicEMenuItem messageDynamicMenu = null;

    public static KeyStroke getCloseWindowAccelerator() {
        return EMenuItem.shortcut(87);
    }

    static EMenu makeMenu() {
        EMenu menu;
        int ctrlshift = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1;
        KeyStroke[] numpad4 = new KeyStroke[]{EMenuItem.shortcut(52), EMenuItem.shortcut(100), KeyStroke.getKeyStroke(226, ctrlshift)};
        KeyStroke[] numpad6 = new KeyStroke[]{EMenuItem.shortcut(54), EMenuItem.shortcut(102), KeyStroke.getKeyStroke(227, ctrlshift)};
        KeyStroke[] numpad8 = new KeyStroke[]{EMenuItem.shortcut(56), EMenuItem.shortcut(104), KeyStroke.getKeyStroke(224, ctrlshift)};
        KeyStroke[] numpad2 = new KeyStroke[]{EMenuItem.shortcut(50), EMenuItem.shortcut(98), KeyStroke.getKeyStroke(225, ctrlshift)};
        KeyStroke[] numpad9 = new KeyStroke[]{EMenuItem.shortcut(57), EMenuItem.shortcut(105), KeyStroke.getKeyStroke(33, ctrlshift)};
        KeyStroke[] numpad7 = new KeyStroke[]{EMenuItem.shortcut(55), EMenuItem.shortcut(103), KeyStroke.getKeyStroke(36, ctrlshift)};
        KeyStroke[] numpad0 = new KeyStroke[]{EMenuItem.shortcut(48), EMenuItem.shortcut(96), KeyStroke.getKeyStroke(155, ctrlshift)};
        KeyStroke[] numpad5 = new KeyStroke[]{EMenuItem.shortcut(53), EMenuItem.shortcut(101)};
        thisWindowMenu = menu = new EMenu("_Window", new EMenuItem("_Fill Window", numpad9){

            public void run() {
                WindowMenu.fullDisplay();
            }
        }, new EMenuItem("Redisplay _Window"){

            public void run() {
                ZoomAndPanListener.redrawDisplay();
            }
        }, new EMenuItem("Zoom _Out", numpad0){

            public void run() {
                WindowMenu.zoomOutDisplay();
            }
        }, new EMenuItem("Zoom _In", numpad7){

            public void run() {
                WindowMenu.zoomInDisplay();
            }
        }, new EMenu("Special _Zoom", new EMenuItem("Focus on _Highlighted", 'F'){

            public void run() {
                WindowMenu.focusOnHighlighted();
            }
        }, new EMenuItem("_Zoom Box"){

            public void run() {
                WindowMenu.zoomBoxCommand();
            }
        }, new EMenuItem("Make _Grid Just Visible"){

            public void run() {
                WindowMenu.makeGridJustVisibleCommand();
            }
        }, new EMenuItem("Match Other _Window"){

            public void run() {
                WindowMenu.matchOtherWindowCommand(0);
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("Pan _Left", numpad4){

            public void run() {
                ZoomAndPanListener.panXOrY(0, WindowFrame.getCurrentWindowFrame(), 1);
            }
        }, new EMenuItem("Pan _Right", numpad6){

            public void run() {
                ZoomAndPanListener.panXOrY(0, WindowFrame.getCurrentWindowFrame(), -1);
            }
        }, new EMenuItem("Pan _Up", numpad8){

            public void run() {
                ZoomAndPanListener.panXOrY(1, WindowFrame.getCurrentWindowFrame(), -1);
            }
        }, new EMenuItem("Pan _Down", numpad2){

            public void run() {
                ZoomAndPanListener.panXOrY(1, WindowFrame.getCurrentWindowFrame(), 1);
            }
        }, new EMenu("Special _Pan", new EMenuItem("Center _Selection"){

            public void run() {
                ZoomAndPanListener.centerSelection();
            }
        }, new EMenuItem("Center _Cursor", numpad5){

            public void run() {
                ZoomAndPanListener.centerCursor();
            }
        }, new EMenuItem("Match Other Window in _X"){

            public void run() {
                WindowMenu.matchOtherWindowCommand(1);
            }
        }, new EMenuItem("Match Other Window in _Y"){

            public void run() {
                WindowMenu.matchOtherWindowCommand(2);
            }
        }, new EMenuItem("Match Other Window in X, Y, _and Scale"){

            public void run() {
                WindowMenu.matchOtherWindowCommand(3);
            }
        }), new EMenuItem("Go To Pre_vious Focus"){

            public void run() {
                WindowMenu.goToPreviousSavedFocus();
            }
        }, new EMenuItem("Go To Ne_xt Focus"){

            public void run() {
                WindowMenu.goToNextSavedFocus();
            }
        }, new EMenuItem("_Set Focus..."){

            public void run() {
                SetFocus.showSetFocusDialog();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Toggle _Grid", 'G'){

            public void run() {
                WindowMenu.toggleGridCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenu("Ad_just Position", new EMenuItem("Tile _Horizontally"){

            public void run() {
                WindowMenu.tileHorizontallyCommand();
            }
        }, new EMenuItem("Tile _Vertically", KeyStroke.getKeyStroke(120, 0)){

            public void run() {
                WindowMenu.tileVerticallyCommand();
            }
        }, new EMenuItem("_Cascade"){

            public void run() {
                WindowMenu.cascadeWindowsCommand();
            }
        }), new EMenuItem("Clos_e Window", WindowMenu.getCloseWindowAccelerator()){

            public void run() {
                WindowMenu.closeWindowCommand();
            }
        }, !TopLevel.isMDIMode() ? EMenuItem.SEPARATOR : null, !TopLevel.isMDIMode() && WindowMenu.getAllGraphicsDevices().length >= 2 ? new EMenuItem("Move to Ot_her Display"){

            public void run() {
                WindowMenu.moveToOtherDisplayCommand();
            }
        } : null, !TopLevel.isMDIMode() ? new EMenuItem("Remember Locatio_n of Display"){

            public void run() {
                WindowMenu.rememberDisplayLocation();
            }
        } : null, EMenuItem.SEPARATOR, new EMenu("_Color Schemes", new EMenuItem("_Restore Default Colors"){

            public void run() {
                WindowMenu.defaultBackgroundCommand();
            }
        }, new EMenuItem("_Black Background Colors"){

            public void run() {
                WindowMenu.blackBackgroundCommand();
            }
        }, new EMenuItem("_White Background Colors"){

            public void run() {
                WindowMenu.whiteBackgroundCommand();
            }
        }), new EMenu("W_aveform Window", new EMenuItem("_Save Waveform Window Configuration to Disk..."){

            public void run() {
                WaveformWindow.saveConfiguration();
            }
        }, new EMenuItem("_Restore Waveform Window Configuration from Disk..."){

            public void run() {
                WaveformWindow.restoreConfiguration();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Refresh Simulation _Data"){

            public void run() {
                WaveformWindow.refreshSimulationData();
            }
        }), new EMenu("_Messages Window", new EMenuItem("_Save Messages..."){

            public void run() {
                MessagesStream.getMessagesStream().save();
            }
        }, new EMenuItem("_Clear"){

            public void run() {
                TopLevel.getMessagesWindow().clear();
            }
        }, new EMenuItem("Set F_ont..."){

            public void run() {
                TopLevel.getMessagesWindow().selectFont();
            }
        }), MenuCommands.makeExtraMenu("j3d.ui.J3DMenu"), new EMenu("Side _Bar", new EMenuItem("On _Left"){

            public void run() {
                WindowFrame.setSideBarLocation(true);
            }
        }, new EMenuItem("On _Right"){

            public void run() {
                WindowFrame.setSideBarLocation(false);
            }
        }), EMenuItem.SEPARATOR);
        return menu;
    }

    static EMenuItem getHiddenWindowCycleMenuItem() {
        if (hiddenWindowCycleMenuItem == null) {
            hiddenWindowCycleMenuItem = new EMenuItem("Window Cycle", KeyStroke.getKeyStroke(81, 0)){

                public void run() {
                    WindowFrame.getWindows().next().requestFocus();
                }
            };
        }
        return hiddenWindowCycleMenuItem;
    }

    public static void addDynamicMenu(WindowFrame wf) {
        WindowMenu.setDynamicMenus();
    }

    public static void deleteDynamicMenu(WindowFrame wf) {
        WindowMenu.setDynamicMenus();
    }

    public static void setDynamicMenus() {
        ArrayList<DynamicEMenuItem> list = new ArrayList<DynamicEMenuItem>();
        KeyStroke accelerator = WindowMenu.getHiddenWindowCycleMenuItem().getAccelerator();
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            list.add(new DynamicEMenuItem(wf, accelerator));
            accelerator = null;
        }
        if (messageDynamicMenu == null) {
            messageDynamicMenu = new DynamicEMenuItem(accelerator);
        }
        list.add(messageDynamicMenu);
        Collections.sort(list, new TextUtils.ObjectsByToString());
        thisWindowMenu.setDynamicItems(list);
    }

    public static void fullDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().fillScreen();
    }

    public static void zoomOutDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().zoomOutContents();
    }

    public static void zoomInDisplay() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().zoomInContents();
    }

    public static void zoomBoxCommand() {
        EventListener oldListener = WindowFrame.getListener();
        WindowFrame.setListener(ClickZoomWireListener.theOne);
        ClickZoomWireListener.theOne.zoomBoxSingleShot(oldListener);
    }

    public static void makeGridJustVisibleCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Rectangle2D displayable = wnd.displayableBounds();
        Dimension sz = wnd.getSize();
        double scaleX = wnd.getGridXSpacing() * (double)sz.width / 5.01 / displayable.getWidth();
        double scaleY = wnd.getGridYSpacing() * (double)sz.height / 5.01 / displayable.getHeight();
        double scale = Math.min(scaleX, scaleY);
        wnd.setScale(wnd.getScale() / scale);
        wnd.setGrid(true);
    }

    public static void matchOtherWindowCommand(int how) {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        int numOthers = 0;
        EditWindow other = null;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow wfWnd;
            WindowFrame wf = it.next();
            if (!(wf.getContent() instanceof EditWindow) || (wfWnd = (EditWindow)wf.getContent()) == wnd) continue;
            ++numOthers;
            other = wfWnd;
        }
        if (numOthers != 1) {
            System.out.println("There must be exactly two windows in order for one to match the other");
            return;
        }
        switch (how) {
            case 0: {
                wnd.setScale(other.getScale());
                break;
            }
            case 1: {
                wnd.setOffset(new Point2D.Double(other.getOffset().getX(), wnd.getOffset().getY()));
                break;
            }
            case 2: {
                wnd.setOffset(new Point2D.Double(wnd.getOffset().getX(), other.getOffset().getY()));
                break;
            }
            case 3: {
                wnd.setScale(other.getScale());
                wnd.setOffset(new Point2D.Double(other.getOffset().getX(), other.getOffset().getY()));
            }
        }
        wnd.repaintContents(null, false);
    }

    public static void focusOnHighlighted() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        wf.getContent().focusOnHighlighted();
    }

    public static void toggleGridCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (wf.getContent() instanceof EditWindow) {
            EditWindow wnd = (EditWindow)wf.getContent();
            if (wnd == null) {
                return;
            }
            wnd.setGrid(!wnd.isGrid());
        } else if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            ww.toggleGridPoints();
        } else {
            System.out.println("Cannot draw a grid in this type of window");
        }
    }

    public static void tileHorizontallyCommand() {
        Rectangle[] areas = WindowMenu.getWindowAreas();
        for (int j = 0; j < areas.length; ++j) {
            Rectangle area = areas[j];
            int count = 0;
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int windowHeight = area.height / count;
            count = 0;
            Iterator<WindowFrame> it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                Rectangle windowArea = new Rectangle(area.x, area.y + count * windowHeight, area.width, windowHeight);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    public static void tileVerticallyCommand() {
        Rectangle[] areas = WindowMenu.getWindowAreas();
        for (int j = 0; j < areas.length; ++j) {
            Rectangle area = areas[j];
            int count = 0;
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int windowWidth = area.width / count;
            count = 0;
            Iterator<WindowFrame> it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                Rectangle windowArea = new Rectangle(area.x + count * windowWidth, area.y, windowWidth, area.height);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    public static void cascadeWindowsCommand() {
        Rectangle[] areas = WindowMenu.getWindowAreas();
        for (int j = 0; j < areas.length; ++j) {
            Rectangle area = areas[j];
            int count = 0;
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                ++count;
            }
            if (count == 0) continue;
            int numRuns = 1;
            int windowXSpacing = 0;
            int windowYSpacing = 0;
            int windowWidth = area.width;
            int windowHeight = area.height;
            if (count > 1) {
                windowWidth = area.width * 3 / 4;
                windowHeight = area.height * 3 / 4;
                int windowSpacing = Math.min(area.width - windowWidth, area.height - windowHeight) / (count - 1);
                if (windowSpacing < 70) {
                    numRuns = 70 / windowSpacing;
                    if (70 % windowSpacing != 0) {
                        ++numRuns;
                    }
                    windowSpacing *= numRuns;
                }
                windowXSpacing = (area.width - windowWidth) / (count - 1) * numRuns;
                windowYSpacing = (area.height - windowHeight) / (count - 1) * numRuns;
            }
            count = 0;
            Iterator<WindowFrame> it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = it2.next();
                Rectangle wfBounds = wf.getFrame().getBounds();
                int locX = (int)wfBounds.getCenterX();
                int locY = (int)wfBounds.getCenterY();
                if (locX < area.x || locX >= area.x + area.width || locY < area.y || locY >= area.y + area.height) continue;
                int index = count / numRuns;
                Rectangle windowArea = new Rectangle(area.x + index * windowXSpacing, area.y + index * windowYSpacing, windowWidth, windowHeight);
                ++count;
                wf.setWindowSize(windowArea);
            }
        }
    }

    private static void closeWindowCommand() {
        WindowFrame curWF = WindowFrame.getCurrentWindowFrame();
        curWF.finished();
    }

    private static void nextWindowCommand() {
        Object cur = null;
        ArrayList<Object> frames = new ArrayList<Object>();
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            if (wf.isFocusOwner()) {
                cur = wf;
            }
            frames.add(wf);
        }
        MessagesWindow mw = TopLevel.getMessagesWindow();
        if (mw.isFocusOwner()) {
            cur = mw;
        }
        frames.add(mw);
        int found = -1;
        for (int i = 0; i < frames.size(); ++i) {
            if (cur != frames.get(i)) continue;
            found = i;
            break;
        }
        if (found >= 0) {
            Object newCur;
            if (++found >= frames.size()) {
                found = 0;
            }
            if ((newCur = frames.get(found)) instanceof WindowFrame) {
                ((WindowFrame)newCur).requestFocus();
            } else {
                ((MessagesWindow)newCur).requestFocus();
            }
        }
    }

    private static Rectangle[] getWindowAreas() {
        Rectangle[] areas = null;
        if (TopLevel.isMDIMode()) {
            TopLevel tl = TopLevel.getCurrentJFrame();
            Dimension sz = tl.getContentPane().getSize();
            areas = new Rectangle[]{new Rectangle(0, 0, sz.width, sz.height)};
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            areas = new Rectangle[gs.length];
            for (int j = 0; j < gs.length; ++j) {
                GraphicsDevice gd = gs[j];
                GraphicsConfiguration gc = gd.getDefaultConfiguration();
                areas[j] = gc.getBounds();
            }
        }
        MessagesWindow mw = TopLevel.getMessagesWindow();
        Rectangle mb = mw.getMessagesLocation();
        WindowMenu.removeOccludingRectangle(areas, mb);
        return areas;
    }

    private static void removeOccludingRectangle(Rectangle[] areas, Rectangle occluding) {
        int cX = occluding.x + occluding.width / 2;
        int cY = occluding.y + occluding.height / 2;
        for (int i = 0; i < areas.length; ++i) {
            int lX = (int)areas[i].getMinX();
            int hX = (int)areas[i].getMaxX();
            int lY = (int)areas[i].getMinY();
            int hY = (int)areas[i].getMaxY();
            if (cX <= lX || cX >= hX || cY <= lY || cY >= hY) continue;
            if (occluding.width > occluding.height) {
                if (occluding.getMaxY() - (double)lY < (double)hY - occluding.getMinY()) {
                    lY = (int)occluding.getMaxY();
                } else {
                    hY = (int)occluding.getMinY();
                }
            } else if (occluding.getMaxX() - (double)lX < (double)hX - occluding.getMinX()) {
                lX = (int)occluding.getMaxX();
            } else {
                hX = (int)occluding.getMinX();
            }
            areas[i].x = lX;
            areas[i].width = hX - lX;
            areas[i].y = lY;
            areas[i].height = hY - lY;
        }
    }

    public static void defaultBackgroundCommand() {
        User.setColorBackground(Color.LIGHT_GRAY.getRGB());
        User.setColorGrid(Color.BLACK.getRGB());
        User.setColorHighlight(Color.WHITE.getRGB());
        User.setColorPortHighlight(Color.YELLOW.getRGB());
        User.setColorText(Color.BLACK.getRGB());
        User.setColorInstanceOutline(Color.BLACK.getRGB());
        User.setColorWaveformBackground(Color.BLACK.getRGB());
        User.setColorWaveformForeground(Color.WHITE.getRGB());
        User.setColorWaveformStimuli(Color.RED.getRGB());
        Generic.setBackgroudColor(Color.BLACK);
        WindowMenu.redrawNewColors();
    }

    public static void blackBackgroundCommand() {
        User.setColorBackground(Color.BLACK.getRGB());
        User.setColorGrid(Color.WHITE.getRGB());
        User.setColorHighlight(Color.RED.getRGB());
        User.setColorPortHighlight(Color.YELLOW.getRGB());
        User.setColorText(Color.WHITE.getRGB());
        User.setColorInstanceOutline(Color.WHITE.getRGB());
        User.setColorWaveformBackground(Color.BLACK.getRGB());
        User.setColorWaveformForeground(Color.WHITE.getRGB());
        User.setColorWaveformStimuli(Color.RED.getRGB());
        Generic.setBackgroudColor(Color.WHITE);
        WindowMenu.redrawNewColors();
    }

    public static void whiteBackgroundCommand() {
        User.setColorBackground(Color.WHITE.getRGB());
        User.setColorGrid(Color.BLACK.getRGB());
        User.setColorHighlight(Color.RED.getRGB());
        User.setColorPortHighlight(Color.DARK_GRAY.getRGB());
        User.setColorText(Color.BLACK.getRGB());
        User.setColorInstanceOutline(Color.BLACK.getRGB());
        User.setColorWaveformBackground(Color.WHITE.getRGB());
        User.setColorWaveformForeground(Color.BLACK.getRGB());
        User.setColorWaveformStimuli(Color.RED.getRGB());
        Generic.setBackgroudColor(Color.BLACK);
        WindowMenu.redrawNewColors();
    }

    private static void redrawNewColors() {
        WindowFrame wf;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            wf = it.next();
            WindowContent content = wf.getContent();
            content.fullRepaint();
        }
        it = WindowFrame.getWindows();
        while (it.hasNext()) {
            wf = it.next();
            wf.loadComponentMenuForTechnology();
        }
    }

    private static GraphicsDevice[] getAllGraphicsDevices() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        return gs;
    }

    public static void moveToOtherDisplayCommand() {
        int i;
        if (TopLevel.isMDIMode()) {
            return;
        }
        WindowFrame curWF = WindowFrame.getCurrentWindowFrame();
        WindowContent content = curWF.getContent();
        GraphicsConfiguration curConfig = content.getPanel().getGraphicsConfiguration();
        GraphicsDevice curDevice = curConfig.getDevice();
        GraphicsDevice[] gs = WindowMenu.getAllGraphicsDevices();
        for (int j = 0; j < gs.length; ++j) {
        }
        for (i = 0; i < gs.length && gs[i] != curDevice; ++i) {
        }
        i = i == gs.length - 1 ? 0 : ++i;
        curWF.moveEditWindow(gs[i].getDefaultConfiguration());
    }

    public static void rememberDisplayLocation() {
        if (TopLevel.isMDIMode()) {
            return;
        }
        WindowFrame curWF = WindowFrame.getCurrentWindowFrame();
        TopLevel tl = curWF.getFrame();
        Point pt = tl.getLocation();
        User.setDefaultWindowPos(pt);
        Dimension sz = tl.getSize();
        User.setDefaultWindowSize(sz);
        MessagesWindow mw = TopLevel.getMessagesWindow();
        Rectangle rect = mw.getMessagesLocation();
        User.setDefaultMessagesPos(new Point(rect.x, rect.y));
        User.setDefaultMessagesSize(new Dimension(rect.width, rect.height));
    }

    public static void goToPreviousSavedFocus() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        EditWindowFocusBrowser browser = wnd.getSavedFocusBrowser();
        browser.goBack();
    }

    public static void goToNextSavedFocus() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        EditWindowFocusBrowser browser = wnd.getSavedFocusBrowser();
        browser.goForward();
    }

    private static class DynamicEMenuItem
    extends EMenuItem {
        WindowFrame window;

        public DynamicEMenuItem(WindowFrame w, KeyStroke accelerator) {
            super(w.getTitle(), accelerator);
            this.window = w;
        }

        public DynamicEMenuItem(KeyStroke accelerator) {
            super("Electric Messages", accelerator);
            this.window = null;
        }

        public String getDescription() {
            return "Window Cycle";
        }

        protected void updateButtons() {
        }

        public void run() {
            if (this.window != null) {
                this.window.requestFocus();
            } else {
                TopLevel.getMessagesWindow().requestFocus();
            }
        }
    }
}

