/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.AnnularRing;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.LayoutText;
import com.sun.electric.tool.user.menus.CellMenu;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LayerDrawing;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.VectorCache;
import com.sun.electric.tool.user.ui.VectorDrawing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.VolatileImage;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class TechPalette
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
PaletteFrame.PlaceNodeEventListener,
ComponentListener,
DragGestureListener,
DragSourceListener {
    private int menuX = -1;
    private int menuY = -1;
    private int entrySize;
    private List<Object> inPalette = new ArrayList<Object>();
    private Object highlightedNode;
    private HashMap<Object, Object> elementsMap = new HashMap();
    private VolatileImage paletteImage;
    private boolean paletteImageStale;
    private Rectangle entryRect;
    private DragSource dragSource = null;
    private PixelDrawing offscreen;
    private static final double menuArcLength = 8.0;
    private static final EditWindow0 dummyWnd = new EditWindow0(){

        @Override
        public VarContext getVarContext() {
            return null;
        }

        @Override
        public double getScale() {
            return 1.0;
        }
    };

    TechPalette() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addComponentListener(this);
        this.paletteImage = null;
        this.paletteImageStale = true;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public Dimension loadForTechnology(Technology tech, Cell curCell) {
        this.inPalette.clear();
        this.elementsMap.clear();
        if (tech == Schematics.tech) {
            ArrayList<Serializable> list = null;
            this.menuX = 2;
            this.menuY = 14;
            this.inPalette.add(Schematics.tech.wire_arc);
            this.inPalette.add(Schematics.tech.wirePinNode);
            this.inPalette.add("Spice");
            this.inPalette.add(Schematics.tech.offpageNode);
            list = new ArrayList<Serializable>();
            list.add(Technology.makeNodeInst(Schematics.tech.globalNode, PrimitiveNode.Function.CONNECT, 0, false, "Global Signal", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.globalPartitionNode, PrimitiveNode.Function.CONNECT, 0, false, "Global Partition", 4.5));
            this.inPalette.add(list);
            this.inPalette.add(Schematics.tech.powerNode);
            list = new ArrayList();
            list.add(Technology.makeNodeInst(Schematics.tech.resistorNode, PrimitiveNode.Function.RESIST, 0, false, "Normal Resistor", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.resistorNode, PrimitiveNode.Function.PRESIST, 0, false, "Poly Resistor", 4.5));
            this.inPalette.add(list);
            list = new ArrayList();
            list.add(Technology.makeNodeInst(Schematics.tech.capacitorNode, PrimitiveNode.Function.CAPAC, 0, false, "Normal Capacitor", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.capacitorNode, PrimitiveNode.Function.ECAPAC, 0, false, "Electrolytic Capacitor", 4.5));
            this.inPalette.add(list);
            list = new ArrayList();
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4NPN, 900, false, "NPN 4-port", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4PNP, 900, false, "PNP 4-port", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4NMOS, 900, false, "nMOS 4-port", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4PMOS, 900, false, "PMOS 4-port", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4DMOS, 900, false, "DMOS 4-port", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4DMES, 900, false, "DMES 4-port", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4EMES, 900, false, "EMES 4-port", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4PJFET, 900, false, "PJFET 4-port", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistor4Node, PrimitiveNode.Function.TRA4PJFET, 900, false, "NJFET 4-port", 4.5));
            this.inPalette.add(list);
            list = new ArrayList();
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRANPN, 900, false, "NPN", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRAPNP, 900, false, "PNP", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRANMOS, 900, false, "nMOS", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRAPMOS, 900, false, "PMOS", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRADMOS, 900, false, "DMOS", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRADMES, 900, false, "DMES", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRAEMES, 900, false, "EMES", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRAPJFET, 900, false, "PJFET", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRANJFET, 900, false, "NJFET", 4.5));
            this.inPalette.add(list);
            this.inPalette.add(Schematics.tech.switchNode);
            this.inPalette.add(Schematics.tech.muxNode);
            this.inPalette.add(Schematics.tech.xorNode);
            this.inPalette.add(Schematics.tech.bboxNode);
            this.inPalette.add(Schematics.tech.bus_arc);
            this.inPalette.add(Schematics.tech.busPinNode);
            this.inPalette.add("Cell");
            this.inPalette.add(Schematics.tech.wireConNode);
            this.inPalette.add("Misc.");
            this.inPalette.add(Schematics.tech.groundNode);
            this.inPalette.add(Schematics.tech.inductorNode);
            list = new ArrayList();
            list.add(Technology.makeNodeInst(Schematics.tech.diodeNode, PrimitiveNode.Function.DIODE, 0, false, "Normal Diode", 4.5));
            list.add(Technology.makeNodeInst(Schematics.tech.diodeNode, PrimitiveNode.Function.DIODEZ, 0, false, "Zener Diode", 4.5));
            this.inPalette.add(list);
            this.inPalette.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRAPMOS, 900, false, null, 4.5));
            this.inPalette.add(Technology.makeNodeInst(Schematics.tech.transistorNode, PrimitiveNode.Function.TRANMOS, 900, false, null, 4.5));
            list = new ArrayList();
            this.inPalette.add(list);
            ArrayList<NodeInst> subList = new ArrayList<NodeInst>();
            list.add(subList);
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPRSMS, 0, false, "R-S master/slave", 4.5));
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPRSP, 0, false, "R-S positive", 4.5));
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPRSN, 0, false, "R-S negative", 4.5));
            list.add(new JPopupMenu.Separator());
            subList = new ArrayList();
            list.add(subList);
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPJKMS, 0, false, "J-K master/slave", 4.5));
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPJKP, 0, false, "J-K positive", 4.5));
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPJKN, 0, false, "J-K negative", 4.5));
            list.add(new JPopupMenu.Separator());
            subList = new ArrayList();
            list.add(subList);
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPDMS, 0, false, "D master/slave", 4.5));
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPDP, 0, false, "D positive", 4.5));
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPDN, 0, false, "D negative", 4.5));
            list.add(new JPopupMenu.Separator());
            subList = new ArrayList();
            list.add(subList);
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPTMS, 0, false, "T master/slave", 4.5));
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPTP, 0, false, "T positive", 4.5));
            subList.add(Technology.makeNodeInst(Schematics.tech.flipflopNode, PrimitiveNode.Function.FLIPFLOPTN, 0, false, "T negative", 4.5));
            this.inPalette.add(Schematics.tech.bufferNode);
            this.inPalette.add(Schematics.tech.orNode);
            this.inPalette.add(Schematics.tech.andNode);
        } else if (tech == Artwork.tech) {
            if (curCell != null && curCell.isInTechnologyLibrary()) {
                this.menuX = 1;
                this.menuY = 16;
                this.inPalette.add("Text");
                NodeInst arc = NodeInst.makeDummyInstance(Artwork.tech.circleNode);
                arc.setArcDegrees(0.0, 0.7853981633974483);
                this.inPalette.add(arc);
                NodeInst half = NodeInst.makeDummyInstance(Artwork.tech.circleNode);
                half.setArcDegrees(0.0, Math.PI);
                this.inPalette.add(half);
                this.inPalette.add(Artwork.tech.filledCircleNode);
                this.inPalette.add(Artwork.tech.circleNode);
                this.inPalette.add(Artwork.tech.openedThickerPolygonNode);
                this.inPalette.add(Artwork.tech.openedDashedPolygonNode);
                this.inPalette.add(Artwork.tech.openedDottedPolygonNode);
                this.inPalette.add(Artwork.tech.openedPolygonNode);
                this.inPalette.add(Technology.makeNodeInst(Artwork.tech.closedPolygonNode, PrimitiveNode.Function.ART, 0, false, null, 4.5));
                this.inPalette.add(Technology.makeNodeInst(Artwork.tech.filledPolygonNode, PrimitiveNode.Function.ART, 0, false, null, 4.5));
                this.inPalette.add(Artwork.tech.boxNode);
                this.inPalette.add(Artwork.tech.crossedBoxNode);
                this.inPalette.add(Artwork.tech.filledBoxNode);
                this.inPalette.add("High");
                this.inPalette.add("Port");
            } else {
                this.menuX = 2;
                this.menuY = 12;
                this.inPalette.add(Artwork.tech.solidArc);
                this.inPalette.add(Artwork.tech.thickerArc);
                this.inPalette.add("Cell");
                this.inPalette.add(Artwork.tech.openedPolygonNode);
                this.inPalette.add(Artwork.tech.openedThickerPolygonNode);
                this.inPalette.add(Artwork.tech.filledTriangleNode);
                this.inPalette.add(Artwork.tech.filledBoxNode);
                this.inPalette.add(Technology.makeNodeInst(Artwork.tech.filledPolygonNode, PrimitiveNode.Function.ART, 0, false, null, 4.5));
                this.inPalette.add(Artwork.tech.filledCircleNode);
                this.inPalette.add(Artwork.tech.pinNode);
                this.inPalette.add(Artwork.tech.crossedBoxNode);
                this.inPalette.add(Artwork.tech.thickCircleNode);
                this.inPalette.add(Artwork.tech.dottedArc);
                this.inPalette.add(Artwork.tech.dashedArc);
                this.inPalette.add("Text");
                this.inPalette.add(Artwork.tech.openedDottedPolygonNode);
                this.inPalette.add(Artwork.tech.openedDashedPolygonNode);
                this.inPalette.add(Artwork.tech.triangleNode);
                this.inPalette.add(Artwork.tech.boxNode);
                this.inPalette.add(Technology.makeNodeInst(Artwork.tech.closedPolygonNode, PrimitiveNode.Function.ART, 0, false, null, 4.5));
                this.inPalette.add(Artwork.tech.circleNode);
                this.inPalette.add("Export");
                this.inPalette.add(Artwork.tech.arrowNode);
                this.inPalette.add(Technology.makeNodeInst(Artwork.tech.splineNode, PrimitiveNode.Function.ART, 0, false, null, 4.5));
            }
        } else {
            Object[][] paletteMatrix = tech.getNodesGrouped();
            if (paletteMatrix != null) {
                this.menuX = paletteMatrix[0].length;
                this.menuY = paletteMatrix.length;
                this.inPalette.clear();
                for (int i = 0; i < this.menuX; ++i) {
                    for (int j = 0; j < this.menuY; ++j) {
                        Object item;
                        Object object = item = paletteMatrix[j] == null ? null : paletteMatrix[j][i];
                        if (item instanceof NodeInst) {
                            item = this.rotateTransistor((NodeInst)item);
                        } else if (item instanceof List) {
                            List nodes = (List)item;
                            for (int k = 0; k < nodes.size(); ++k) {
                                Object o = nodes.get(k);
                                if (!(o instanceof NodeInst)) continue;
                                nodes.set(k, this.rotateTransistor((NodeInst)o));
                            }
                        }
                        item = TechPalette.getInUsed(item);
                        this.inPalette.add(item);
                    }
                }
            } else {
                System.out.println("Error: no palette information found for " + tech.getTechName());
            }
        }
        Dimension size = TopLevel.getScreenSize();
        this.entrySize = (int)size.getWidth() / this.menuX;
        int ysize = (int)(size.getHeight() * 0.9) / this.menuY;
        if (ysize < this.entrySize) {
            this.entrySize = ysize;
        }
        size.setSize(this.entrySize * this.menuX + 1, this.entrySize * this.menuY + 1);
        User.getUserTool().setCurrentArcProto(tech.getArcs().next());
        this.paletteImageStale = true;
        return size;
    }

    private NodeInst rotateTransistor(NodeInst ni) {
        PrimitiveNode.Function fun;
        int rot = 0;
        if (User.isRotateLayoutTransistors()) {
            rot = 900;
        }
        if ((fun = ni.getFunction()).isTransistor()) {
            NodeInst newNi = Technology.makeNodeInst(ni.getProto(), fun, rot, false, null, 0.0);
            newNi.copyVarsFrom(ni);
            ni = newNi;
        }
        return ni;
    }

    private static Object getInUsed(Object item) {
        if (item != null) {
            PrimitiveNode p = null;
            if (item instanceof NodeInst && ((NodeInst)item).getProto() instanceof PrimitiveNode) {
                p = (PrimitiveNode)((NodeInst)item).getProto();
            } else if (item instanceof PrimitiveNode) {
                p = (PrimitiveNode)item;
            }
            if (p != null && p.isNotUsed()) {
                item = null;
            }
        }
        return item;
    }

    private static String getItemName(Object item, boolean getVarName) {
        if (item instanceof PrimitiveNode) {
            PrimitiveNode np = (PrimitiveNode)item;
            return np.getName();
        }
        if (item instanceof NodeInst) {
            NodeInst ni = (NodeInst)item;
            Variable var = ni.getVar(Technology.TECH_TMPVAR);
            if (getVarName && var != null && !var.isDisplay()) {
                return var.getObject().toString();
            }
            return ni.getProto().getName();
        }
        if (item instanceof ArcProto) {
            ArcProto ap = (ArcProto)item;
            return ap.getName();
        }
        return "";
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        TechPalette panel = (TechPalette)e.getSource();
        panel.requestFocus();
        Object obj = this.getObjectUnderCursor(e.getX(), e.getY());
        if (obj == null) {
            return;
        }
        if (obj instanceof NodeProto || obj instanceof NodeInst || obj instanceof ArcProto || obj instanceof List) {
            if (obj instanceof List) {
                List list = (List)obj;
                if ((obj = list.get(0)) instanceof List) {
                    obj = ((List)obj).get(0);
                }
                if (list.size() > 1 && this.isCursorOnCorner(e)) {
                    JPopupMenu menu = new JPopupMenu(TechPalette.getItemName(obj, true));
                    for (Object item : list) {
                        JMenuItem menuItem;
                        if (item instanceof JSeparator) {
                            menu.add((JSeparator)item);
                            continue;
                        }
                        if (item instanceof List) {
                            List subList = (List)item;
                            for (Object subItem : subList) {
                                if ((subItem = TechPalette.getInUsed(subItem)) == null) continue;
                                menuItem = new JMenuItem(TechPalette.getItemName(subItem, true));
                                menu.add(menuItem);
                                menuItem.addActionListener(new PlacePopupListListener(panel, subItem, list, subList));
                            }
                            continue;
                        }
                        if ((item = TechPalette.getInUsed(item)) == null) continue;
                        menuItem = new JMenuItem(TechPalette.getItemName(item, true));
                        menu.add(menuItem);
                        menuItem.addActionListener(new PlacePopupListListener(panel, item, list, null));
                    }
                    menu.show(panel, e.getX(), e.getY());
                    return;
                }
            }
            if (obj instanceof ArcProto) {
                User.getUserTool().setCurrentArcProto((ArcProto)obj);
            } else {
                PaletteFrame.placeInstance(obj, panel, false);
            }
        } else if (obj instanceof String) {
            JPopupMenu specialMenu;
            JMenuItem menuItem;
            JPopupMenu cellMenu;
            String msg = (String)obj;
            if (msg.equals("Cell")) {
                cellMenu = new JPopupMenu("Cells");
                Iterator<Cell> it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell cell = it.next();
                    menuItem = new JMenuItem(cell.describe(false));
                    menuItem.addActionListener(new PlacePopupListener(panel, cell));
                    cellMenu.add(menuItem);
                }
                cellMenu.show(panel, e.getX(), e.getY());
            } else if (msg.equals("Misc.")) {
                specialMenu = new JPopupMenu("Miscellaneous");
                menuItem = new JMenuItem("Cell Instance...");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CellMenu.cellBrowserCommand(CellBrowser.DoAction.newInstance);
                    }
                });
                specialMenu.add(menuItem);
                specialMenu.addSeparator();
                menuItem = new JMenuItem("Annotation Text");
                menuItem.addActionListener(new PlacePopupListener(panel, "ART_message"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Layout Text...");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeLayoutTextCommand();
                    }
                });
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Annular Ring...");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AnnularRing.showAnnularRingDialog();
                    }
                });
                specialMenu.add(menuItem);
                specialMenu.addSeparator();
                menuItem = new JMenuItem("Cell Center");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.cellCenterNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Essential Bounds");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.essentialBoundsNode));
                specialMenu.add(menuItem);
                specialMenu.addSeparator();
                menuItem = new JMenuItem("Spice Code");
                menuItem.addActionListener(new PlacePopupListener(panel, "SIM_spice_card"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Spice Declaration");
                menuItem.addActionListener(new PlacePopupListener(panel, "SIM_spice_declaration"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Verilog Code");
                menuItem.addActionListener(new PlacePopupListener(panel, "VERILOG_code"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Verilog Declaration");
                menuItem.addActionListener(new PlacePopupListener(panel, "VERILOG_declaration"));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Simulation Probe");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.simProbeNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("DRC Exclusion");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.drcNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("AFG Exclusion");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.afgNode));
                specialMenu.add(menuItem);
                specialMenu.addSeparator();
                menuItem = new JMenuItem("Invisible Pin");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.invisiblePinNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Universal Pin");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.universalPinNode));
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Unrouted Pin");
                menuItem.addActionListener(new PlacePopupListener(panel, Generic.tech.unroutedPinNode));
                specialMenu.add(menuItem);
                specialMenu.show(panel, e.getX(), e.getY());
            } else if (msg.equals("Pure")) {
                JPopupMenu pureMenu = new JPopupMenu("Pure");
                for (PrimitiveNode np : Technology.getCurrent().getNodesSortedByName()) {
                    Technology.NodeLayer layer;
                    if (np.isNotUsed() || np.getFunction() != PrimitiveNode.Function.NODE || (layer = np.getLayers()[0]).getLayer().getFunction().isContact()) continue;
                    menuItem = new JMenuItem(np.describe(false));
                    menuItem.addActionListener(new PlacePopupListener(panel, np));
                    pureMenu.add(menuItem);
                }
                pureMenu.show(panel, e.getX(), e.getY());
            }
            if (msg.equals("Spice")) {
                cellMenu = new JPopupMenu("Spice");
                String currentSpiceLib = Simulation.getSpicePartsLibrary();
                Library spiceLib = Library.findLibrary(currentSpiceLib);
                if (spiceLib == null) {
                    URL fileURL = LibFile.getLibFile(currentSpiceLib + ".jelib");
                    new ReadSpiceLibrary(fileURL, cellMenu, panel, e.getX(), e.getY());
                } else {
                    ReadSpiceLibrary.loadSpiceCells(spiceLib, panel, cellMenu);
                    cellMenu.show(panel, e.getX(), e.getY());
                }
            }
            if (msg.equals("Export")) {
                specialMenu = new JPopupMenu("Export");
                menuItem = new JMenuItem("Wire");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeExport("wire");
                    }
                });
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Bus");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeExport("bus");
                    }
                });
                specialMenu.add(menuItem);
                menuItem = new JMenuItem("Universal");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TechPalette.this.makeExport("universal");
                    }
                });
                specialMenu.add(menuItem);
                specialMenu.show(panel, e.getX(), e.getY());
            }
            if (msg.equals("Text")) {
                PaletteFrame.placeInstance("ART_message", panel, false);
            }
            if (msg.equals("High")) {
                NodeInst ni = NodeInst.makeDummyInstance(Artwork.tech.boxNode);
                ni.newVar(Info.OPTION_KEY, (Object)new Integer(19));
                PaletteFrame.placeInstance(ni, panel, false);
            }
            if (msg.equals("Port")) {
                PaletteFrame.placeInstance(Generic.tech.portNode, panel, false);
            }
        }
        this.repaint();
    }

    private void makeExport(String type) {
        if (type.equals("wire")) {
            PaletteFrame.placeInstance(Schematics.tech.wirePinNode, this, true);
        } else if (type.equals("bus")) {
            PaletteFrame.placeInstance(Schematics.tech.busPinNode, this, true);
        } else if (type.equals("universal")) {
            PaletteFrame.placeInstance(Generic.tech.invisiblePinNode, this, true);
        }
    }

    public void makeLayoutTextCommand() {
        LayoutText dialog = new LayoutText((Frame)TopLevel.getCurrentJFrame(), true);
        if (!Job.BATCHMODE) {
            dialog.setVisible(true);
        }
    }

    @Override
    public void placeNodeStarted(Object nodeToBePlaced) {
        this.highlightedNode = nodeToBePlaced;
    }

    @Override
    public void placeNodeFinished(boolean cancelled) {
        this.highlightedNode = null;
        this.repaint();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Object obj = this.getObjectUnderCursor(e.getDragOrigin().x, e.getDragOrigin().y);
        EditWindow.NodeProtoTransferable transferable = new EditWindow.NodeProtoTransferable(obj, null);
        this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private Object getObjectUnderCursor(int xp, int yp) {
        int index;
        int x = xp / (this.entrySize + 1);
        int y = this.menuY - yp / (this.entrySize + 1) - 1;
        if (y < 0) {
            y = 0;
        }
        if ((index = x * this.menuY + y) < 0 || index >= this.inPalette.size()) {
            return null;
        }
        Object obj = this.inPalette.get(index);
        return obj;
    }

    private boolean isCursorOnCorner(MouseEvent e) {
        int entryS = this.entrySize + 1;
        int x = e.getX() / entryS;
        int y = this.menuY - e.getY() / entryS - 1;
        if (y < 0) {
            y = 0;
        }
        double deltaX = (double)(e.getX() - x * entryS) / (double)entryS;
        double deltaY = (double)(e.getY() - (this.menuY - y - 1) * entryS) / (double)entryS;
        return deltaX > 0.75 && deltaY > 0.75;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object obj = this.getObjectUnderCursor(e.getX(), e.getY());
        if (obj instanceof List && (obj = ((List)obj).get(0)) instanceof List) {
            obj = ((List)obj).get(0);
        }
        if (obj instanceof PrimitiveNode) {
            StatusBar.setSelectionOverride("CREATE NODE: " + ((PrimitiveNode)obj).describe(false));
        } else if (obj instanceof NodeInst) {
            StatusBar.setSelectionOverride("CREATE NODE: " + ((NodeInst)obj).describe(false));
        } else if (obj instanceof NodeProto) {
            StatusBar.setSelectionOverride("CREATE NODE: " + ((NodeProto)obj).describe(false));
        } else if (obj instanceof ArcProto) {
            ArcProto ap = (ArcProto)obj;
            StatusBar.setSelectionOverride("USE ARC: " + ap.describe());
        } else if (obj instanceof String) {
            StatusBar.setSelectionOverride(null);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        StatusBar.setSelectionOverride(null);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.paletteImageStale = true;
    }

    @Override
    public void paint(Graphics g) {
        int index;
        if (this.menuX < 0 || this.menuY < 0) {
            return;
        }
        Dimension size = this.getSize();
        int wid = (int)size.getWidth();
        int hei = (int)size.getHeight();
        this.entrySize = Math.min(wid / this.menuX - 1, hei / this.menuY - 1);
        if (wid <= 0 || hei <= 0) {
            return;
        }
        do {
            int returnCode;
            if (this.paletteImage == null) {
                this.paletteImage = this.createVolatileImage(this.getWidth(), this.getHeight());
                returnCode = 1;
            } else {
                returnCode = this.paletteImage.validate(this.getGraphicsConfiguration());
                if (returnCode == 2 || this.paletteImage.getWidth() != wid || this.paletteImage.getHeight() != hei) {
                    returnCode = 2;
                    this.paletteImage.flush();
                    this.paletteImage = this.createVolatileImage(this.getWidth(), this.getHeight());
                }
            }
            if (returnCode != 0 || this.paletteImageStale) {
                this.renderPaletteImage();
            }
            g.drawImage(this.paletteImage, 0, 0, this);
        } while (this.paletteImage.contentsLost());
        this.paletteImageStale = false;
        if (this.highlightedNode != null && (index = this.inPalette.indexOf(this.highlightedNode)) >= 0) {
            int x = index / this.menuY;
            int y = index % this.menuY;
            int imgX = x * (this.entrySize + 1) + 1;
            int imgY = (this.menuY - y - 1) * (this.entrySize + 1) + 1;
            g.setColor(Color.BLUE);
            g.drawRect(imgX + 1, imgY + 1, this.entrySize - 3, this.entrySize - 3);
            g.drawRect(imgX + 2, imgY + 2, this.entrySize - 5, this.entrySize - 5);
        }
        ArcProto arcObj = User.getUserTool().getCurrentArcProto();
        int index2 = -1;
        for (int i = 0; i < this.inPalette.size(); ++i) {
            Object obj = this.inPalette.get(i);
            if (obj == null) continue;
            if (obj instanceof List) {
                obj = ((List)obj).get(0);
            }
            if (obj != arcObj) continue;
            index2 = i;
            break;
        }
        if (index2 >= 0) {
            int x = index2 / this.menuY;
            int y = index2 % this.menuY;
            int imgX = x * (this.entrySize + 1) + 1;
            int imgY = (this.menuY - y - 1) * (this.entrySize + 1) + 1;
            g.setColor(Color.RED);
            g.drawRect(imgX + 1, imgY + 1, this.entrySize - 3, this.entrySize - 3);
            g.drawRect(imgX + 2, imgY + 2, this.entrySize - 5, this.entrySize - 5);
        }
    }

    private void renderPaletteImage() {
        int i;
        if (this.entrySize < 2) {
            return;
        }
        this.entryRect = new Rectangle(new Dimension(this.entrySize - 2, this.entrySize - 2));
        this.offscreen = new PixelDrawing(new Dimension(this.entrySize, this.entrySize));
        Graphics2D g = (Graphics2D)this.paletteImage.getGraphics();
        g.setBackground(new Color(User.getColorBackground()));
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        for (int x = 0; x < this.menuX; ++x) {
            for (int y = 0; y < this.menuY; ++y) {
                int index = x * this.menuY + y;
                if (index >= this.inPalette.size()) continue;
                Object toDraw = this.inPalette.get(index);
                boolean drawArrow = false;
                if (toDraw instanceof List) {
                    List list = (List)toDraw;
                    if ((toDraw = list.get(0)) instanceof List) {
                        toDraw = ((List)toDraw).get(0);
                    }
                    drawArrow = list.size() > 1;
                }
                int imgX = x * (this.entrySize + 1) + 1;
                int imgY = (this.menuY - y - 1) * (this.entrySize + 1) + 1;
                if (toDraw instanceof ArcProto) {
                    ArcProto ap = (ArcProto)toDraw;
                    double largest = 0.0;
                    Iterator<ArcProto> it = ap.getTechnology().getArcs();
                    while (it.hasNext()) {
                        double wid;
                        ArcProto otherAp = it.next();
                        if (otherAp.isSpecialArc() || otherAp.isSkipSizeInPalette() || !((wid = DBMath.gridToLambda(2L * (otherAp.getDefaultGridExtendOverMin() + (long)otherAp.getMaxLayerGridExtend()))) + 8.0 > largest)) continue;
                        largest = wid + 8.0;
                    }
                    double scalex = (double)this.entrySize / largest * 0.8;
                    double scaley = (double)this.entrySize / largest * 0.8;
                    double scale = Math.min(scalex, scaley);
                    VectorCache.VectorBase[] shapes = VectorCache.drawPolys(ap.getShapeOfDummyArc(8.0));
                    this.drawShapes(g, imgX, imgY, scale, shapes);
                    g.setColor(Color.RED);
                    g.drawRect(imgX, imgY, this.entrySize - 1, this.entrySize - 1);
                }
                if (toDraw instanceof NodeProto || toDraw instanceof NodeInst) {
                    NodeInst ni;
                    if (toDraw instanceof NodeInst) {
                        ni = (NodeInst)toDraw;
                        if (ni.getFunction() == PrimitiveNode.Function.TRAPNP || ni.getFunction() == PrimitiveNode.Function.TRA4PNP) {
                            drawArrow = true;
                        }
                    } else {
                        NodeProto np = (NodeProto)toDraw;
                        ni = NodeInst.makeDummyInstance(np);
                        if (np == Schematics.tech.diodeNode || np == Schematics.tech.capacitorNode || np == Schematics.tech.flipflopNode) {
                            drawArrow = true;
                        }
                    }
                    PrimitiveNode np = (PrimitiveNode)ni.getProto();
                    double largest = 0.0;
                    PrimitiveNode.Function groupFunction = np.getGroupFunction();
                    Iterator<Comparable<PrimitiveNode>> it = np.getTechnology().getNodes();
                    while (it.hasNext()) {
                        PrimitiveNode otherNp = it.next();
                        if (otherNp.getGroupFunction() != groupFunction || otherNp.isSkipSizeInPalette()) continue;
                        if (otherNp.getDefHeight() > largest) {
                            largest = otherNp.getDefHeight();
                        }
                        if (!(otherNp.getDefWidth() > largest)) continue;
                        largest = otherNp.getDefWidth();
                    }
                    if (groupFunction == PrimitiveNode.Function.PIN) {
                        largest = 0.0;
                        it = np.getTechnology().getArcs();
                        while (it.hasNext()) {
                            double wid;
                            ArcProto otherAp = (ArcProto)it.next();
                            if (otherAp.isSpecialArc() || otherAp.isSkipSizeInPalette() || !((wid = DBMath.gridToLambda(2L * (otherAp.getDefaultGridExtendOverMin() + (long)otherAp.getMaxLayerGridExtend()))) + 8.0 > largest)) continue;
                            largest = wid + 8.0;
                        }
                    }
                    double scalex = (double)this.entrySize / largest * 0.8;
                    double scaley = (double)this.entrySize / largest * 0.8;
                    double scale = Math.min(scalex, scaley);
                    VectorCache.VectorBase[] shapes = VectorCache.drawNode(ni);
                    this.drawShapes(g, imgX, imgY, scale, shapes);
                    g.setColor(Color.BLUE);
                    g.drawRect(imgX, imgY, this.entrySize - 1, this.entrySize - 1);
                }
                if (toDraw instanceof String) {
                    String str = (String)toDraw;
                    if (str.equals("Cell") || str.equals("Spice") || str.equals("Misc.") || str.equals("Pure")) {
                        drawArrow = true;
                    }
                    int defSize = 18;
                    Font f = new Font(User.getDefaultFont(), 1, defSize);
                    FontMetrics fm = g.getFontMetrics(f);
                    float width = fm.stringWidth(str);
                    if (width > (float)this.entryRect.width) {
                        f = new Font(User.getDefaultFont(), 1, (int)((float)(defSize * this.entryRect.width) / width));
                        fm = g.getFontMetrics(f);
                        width = fm.stringWidth(str);
                    }
                    g.setFont(f);
                    g.setColor(new Color(User.getColorText()));
                    g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    g.drawString(str, (float)imgX + ((float)this.entryRect.width - width) / 2.0f, (float)imgY + ((float)this.entryRect.height + (float)fm.getAscent()) / 2.0f);
                }
                if (!drawArrow) continue;
                this.drawArrow(g, x, y);
            }
        }
        this.offscreen = null;
        g.setColor(new Color(User.getColorGrid()));
        for (i = 0; i <= this.menuX; ++i) {
            int xPos = (this.entrySize + 1) * i;
            g.drawLine(xPos, 0, xPos, this.menuY * (this.entrySize + 1));
        }
        for (i = 0; i <= this.menuY; ++i) {
            int yPos = (this.entrySize + 1) * i;
            g.drawLine(0, yPos, this.menuX * (this.entrySize + 1), yPos);
        }
        g.dispose();
    }

    private void drawArrow(Graphics g, int x, int y) {
        int imgX = x * (this.entrySize + 1) + 1;
        int imgY = (this.menuY - y - 1) * (this.entrySize + 1) + 1;
        int[] arrowX = new int[3];
        int[] arrowY = new int[3];
        arrowX[0] = imgX - 2 + this.entrySize * 7 / 8;
        arrowY[0] = imgY - 2 + this.entrySize;
        arrowX[1] = imgX - 2 + this.entrySize;
        arrowY[1] = imgY - 2 + this.entrySize * 7 / 8;
        arrowX[2] = imgX - 2 + this.entrySize * 7 / 8;
        arrowY[2] = imgY - 2 + this.entrySize * 3 / 4;
        g.setColor(new Color(User.getColorGrid()));
        g.fillPolygon(arrowX, arrowY, 3);
    }

    private void drawShapes(Graphics2D g, int imgX, int imgY, double scale, VectorCache.VectorBase[] shapes) {
        if (User.getDisplayAlgorithm() < 2 || User.isLegacyComposite()) {
            this.offscreen.initDrawing(scale);
            VectorDrawing vd = new VectorDrawing();
            vd.render(this.offscreen, scale, EPoint.ORIGIN, shapes, true);
            Image img = this.offscreen.composite(null);
            g.drawImage(img, imgX, imgY, null);
        } else {
            LayerDrawing.drawTechPalette(g, imgX, imgY, this.entryRect, scale, shapes);
        }
    }

    static class PlacePopupListListener
    extends PlacePopupListener
    implements ActionListener {
        List list;
        List subList;

        PlacePopupListListener(TechPalette panel, Object obj, List list, List subList) {
            super(panel, obj);
            this.list = list;
            this.subList = subList;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.obj instanceof ArcProto) {
                User.getUserTool().setCurrentArcProto((ArcProto)this.obj);
            } else {
                PaletteFrame.placeInstance(this.obj, this.panel, false);
            }
            if (this.subList == null) {
                Collections.swap(this.list, 0, this.list.indexOf(this.obj));
            } else {
                Collections.swap(this.list, 0, this.list.indexOf(this.subList));
                Collections.swap(this.subList, 0, this.subList.indexOf(this.obj));
            }
            this.panel.paletteImageStale = true;
        }
    }

    static class PlacePopupListener
    implements ActionListener {
        TechPalette panel;
        Object obj;

        PlacePopupListener(TechPalette panel, Object obj) {
            this.panel = panel;
            this.obj = obj;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PaletteFrame.placeInstance(this.obj, this.panel, false);
        }
    }

    private static class ReadSpiceLibrary
    extends Job {
        private URL fileURL;
        private transient JPopupMenu cellMenu;
        private transient TechPalette panel;
        private transient int x;
        private transient int y;
        private Library lib;

        protected ReadSpiceLibrary(URL fileURL, JPopupMenu cellMenu, TechPalette panel, int x, int y) {
            super("Read Spice Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.fileURL = fileURL;
            this.cellMenu = cellMenu;
            this.panel = panel;
            this.x = x;
            this.y = y;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.lib = LibraryFiles.readLibrary(this.fileURL, null, FileType.JELIB, false);
            if (this.lib == null) {
                return false;
            }
            this.fieldVariableChanged("lib");
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.lib == null) {
                return;
            }
            ReadSpiceLibrary.loadSpiceCells(this.lib, this.panel, this.cellMenu);
            this.cellMenu.show(this.panel, this.x, this.y);
        }

        public static void loadSpiceCells(Library lib, TechPalette panel, JPopupMenu cellMenu) {
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                if (cell.getView() != View.ICON) continue;
                JMenuItem menuItem = new JMenuItem(cell.getName());
                menuItem.addActionListener(new PlacePopupListener(panel, cell));
                cellMenu.add(menuItem);
            }
        }
    }
}

