/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.io.input.Input;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class Applicon860
extends Input {
    private static final int POLYSPLIT = 999;
    private static final int BYTESSWAPPED = 1;
    private static final int TAPEFORMAT = 2;
    private static final int INITIALIZED = 4;
    private Map<Integer, PrimitiveNode> appleNodeMap = new HashMap<Integer, PrimitiveNode>();
    private int appleState;
    private int[] polylist;
    private int polylistcount = 0;
    private int[] px;
    private int[] py;
    private Point2D[] ptrace;
    static Poly poly = null;

    protected Library importALibrary(Library lib) {
        try {
            if (!this.readAppleLibrary(lib)) {
                return null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lib;
    }

    private boolean readAppleLibrary(Library lib) throws IOException {
        int[] cidata = new int[32];
        int xoff = 0;
        int yoff = 0;
        Cell subnp = null;
        PrimitiveNode layernp = null;
        ElectricObject ni = null;
        double scale = 0.0;
        this.setupAppleLayers();
        Cell curfacet = null;
        HashSet<Integer> notFound = new HashSet<Integer>();
        this.appleState = 0;
        block20: while (true) {
            int chain;
            if ((chain = this.appleGetChain()) != 3 && chain != 1) {
                System.out.println("CHAIN=" + chain + " at byte " + this.byteCount);
                return false;
            }
            int length = this.appleGetWord();
            int type = this.appleGetWord();
            switch (type) {
                case 2: 
                case 254: {
                    int k;
                    if (length != 26) {
                        if (type == 2) {
                            System.out.println("Top global parameter length=" + length);
                        } else {
                            System.out.println("Cell global parameter length=" + length);
                        }
                        return false;
                    }
                    String name = "";
                    for (k = 0; k < 30; ++k) {
                        name = name + this.dataInputStream.readByte();
                    }
                    int st = name.indexOf(93) + 1;
                    int i = name.indexOf(46, st);
                    if (i >= 0) {
                        name = name.substring(0, i);
                    }
                    String units = "";
                    for (k = 0; k < 4; ++k) {
                        units = units + this.dataInputStream.readByte();
                    }
                    int nfl = this.appleGetWord();
                    int nfh = this.appleGetWord();
                    int nfe = this.appleGetWord();
                    scale = this.appleFloat(nfl, nfh, nfe) / 2.147483648E9;
                    if (units.equals("MIL ")) {
                        scale = TextUtils.convertFromDistance(scale * 25.4, Technology.getCurrent(), TextUtils.UnitScale.MICRO);
                    } else if (units.equals("INCH")) {
                        TextUtils.convertFromDistance(scale * 25400.0, Technology.getCurrent(), TextUtils.UnitScale.MICRO);
                    } else {
                        scale = TextUtils.convertFromDistance(scale, Technology.getCurrent(), TextUtils.UnitScale.MICRO);
                    }
                    xoff = this.appleGetWord() & 0xFFFF;
                    xoff |= (this.appleGetWord() & 0xFFFF) << 16;
                    yoff = this.appleGetWord() & 0xFFFF;
                    yoff |= (this.appleGetWord() & 0xFFFF) << 16;
                    curfacet = Cell.makeInstance(lib, name.substring(st));
                    if (curfacet != null) continue block20;
                    System.out.println("Cannot create facet '" + name.substring(st) + "'");
                    return false;
                }
                case 3: {
                    Integer layerInt;
                    int i;
                    if (length != 9) {
                        System.out.println("Element instance length=" + length);
                        return false;
                    }
                    int lvlgrp = this.appleGetWord();
                    int levels = this.appleGetWord() & 0xFFFF;
                    levels |= (this.appleGetWord() & 0xFFFF) << 16;
                    for (i = 0; i < 32 && levels != 1 << i; ++i) {
                    }
                    if (i >= 32) {
                        System.out.println("Unknown layer code " + levels);
                        return false;
                    }
                    int layer = lvlgrp * 32 + i + 1;
                    this.appleGetWord();
                    int eitype = this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    switch (eitype) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    if ((layernp = this.appleNodeMap.get(layerInt = new Integer(layer))) != null || notFound.contains(layerInt)) continue block20;
                    System.out.println("Warning: Apple layer " + layer + " not found");
                    notFound.add(layerInt);
                    break;
                }
                case 101: {
                    int hy;
                    int hx;
                    int i;
                    this.appleGetWord();
                    this.appleGetWord();
                    int offset = 4;
                    if (length - offset > this.polylistcount) {
                        this.polylistcount = 0;
                        this.polylist = new int[length - offset];
                        this.px = new int[(length - offset + 4) / 5];
                        this.py = new int[(length - offset + 4) / 5];
                        this.ptrace = new Point2D[(length - offset + 4) / 5];
                        this.polylistcount = length - offset;
                    }
                    int polyptr = 0;
                    while (length > 999) {
                        for (i = 0; i < 999 - offset; ++i) {
                            this.polylist[polyptr++] = this.appleGetWord();
                        }
                        chain = this.appleGetChain();
                        if (chain != 2 && chain != 0) {
                            System.out.println("END CHAIN=" + chain + " at byte " + this.byteCount);
                            return false;
                        }
                        length -= 999;
                        offset = 0;
                    }
                    for (i = 0; i < length - offset; ++i) {
                        this.polylist[polyptr++] = this.appleGetWord();
                    }
                    if (polyptr > this.polylistcount) {
                        System.out.println("Just overflowed " + this.polylistcount + " long array with " + polyptr + " points");
                    }
                    if ((chain & 2) == 0) {
                        this.appleGetWord();
                    }
                    polyptr /= 5;
                    for (i = 0; i < polyptr; ++i) {
                        this.px[i] = this.polylist[i * 5] & 0xFFFF;
                        int n = i;
                        this.px[n] = this.px[n] | (this.polylist[i * 5 + 1] & 0xFFFF) << 16;
                        this.py[i] = this.polylist[i * 5 + 2] & 0xFFFF;
                        int n2 = i;
                        this.py[n2] = this.py[n2] | (this.polylist[i * 5 + 3] & 0xFFFF) << 16;
                        this.px[i] = this.appleScale(this.px[i], xoff, scale);
                        this.py[i] = this.appleScale(this.py[i], yoff, scale);
                        if ((this.polylist[i * 5 + 4] & 2) != 0 && i != 0) {
                            System.out.println("Warning: point " + i + " of polygon has s=" + this.polylist[i * 5 + 4]);
                        }
                        if ((this.polylist[i * 5 + 4] & 1) == 0 || i == polyptr - 1) continue;
                        System.out.println("Warning: point " + i + " of polygon has s=" + this.polylist[i * 5 + 4]);
                    }
                    if (this.px[polyptr - 1] == this.px[0] && this.py[polyptr - 1] == this.py[0]) {
                        --polyptr;
                    }
                    int lx = hx = this.px[0];
                    int ly = hy = this.py[0];
                    for (i = 1; i < polyptr; ++i) {
                        if (this.px[i] < lx) {
                            lx = this.px[i];
                        }
                        if (this.px[i] > hx) {
                            hx = this.px[i];
                        }
                        if (this.py[i] < ly) {
                            ly = this.py[i];
                        }
                        if (this.py[i] <= hy) continue;
                        hy = this.py[i];
                    }
                    for (i = 0; i < polyptr; ++i) {
                        this.ptrace[i] = new Point2D.Double(this.px[i] - (lx + hx) / 2, this.py[i] - (ly + hy) / 2);
                    }
                    if (layernp == null || curfacet == null) continue block20;
                    Point2D.Double center = new Point2D.Double((lx + hx) / 2, (ly + hy) / 2);
                    ni = NodeInst.newInstance(layernp, center, hx - lx, hy - ly, curfacet);
                    if (ni == null) {
                        return false;
                    }
                    ni.newVar(NodeInst.TRACE, (Object)this.ptrace);
                    break;
                }
                case 107: {
                    if (length != 3) {
                        System.out.println("Flag length=" + length);
                        return false;
                    }
                    this.appleGetWord();
                    break;
                }
                case 117: {
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    int tcount = this.appleGetWord();
                    if ((tcount & 1) != 0) {
                        ++tcount;
                    }
                    String str = "";
                    for (int k = 0; k < tcount; ++k) {
                        str = str + this.dataInputStream.readByte();
                    }
                    int i = 0;
                    StringBuffer sb = new StringBuffer();
                    for (int k = 0; k < str.length(); ++k) {
                        char ch = str.charAt(k);
                        if (ch == '\r') {
                            sb.append('\n');
                            ++i;
                            continue;
                        }
                        if (ch == '\n') continue;
                        sb.append(ch);
                    }
                    str = sb.toString();
                    if (ni == null) continue block20;
                    if (i <= 1) {
                        int crPos = str.indexOf(10);
                        if (crPos >= 0) {
                            str = str.substring(0, crPos);
                        }
                        TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withDisplay(true);
                        ni.newVar(Artwork.ART_MESSAGE, (Object)str, td);
                        break;
                    }
                    String[] message = str.split("\n");
                    TextDescriptor td = TextDescriptor.getNodeTextDescriptor().withDisplay(true);
                    ni.newVar(Artwork.ART_MESSAGE, (Object)message, td);
                    break;
                }
                case 4: {
                    if (length != 17) {
                        System.out.println("Cell name length=" + length);
                        return false;
                    }
                    String cellname = "";
                    for (int k = 0; k < 30; ++k) {
                        cellname = cellname + this.dataInputStream.readByte();
                    }
                    int st = cellname.indexOf(93) + 1;
                    int i = cellname.indexOf(46, st);
                    if (i >= 0) {
                        cellname = cellname.substring(0, i);
                    }
                    if ((subnp = lib.findNodeProto(cellname)) != null) continue block20;
                    System.out.println("Instance of cell '" + cellname.substring(st) + "' not found");
                    return false;
                }
                case 5: {
                    if (length != 6) {
                        System.out.println("Cell instance header length=" + length);
                        return false;
                    }
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    this.appleGetWord();
                    break;
                }
                case 105: {
                    int i;
                    length -= 2;
                    for (i = 0; i < length; ++i) {
                        cidata[i] = this.appleGetWord();
                    }
                    int x1 = cidata[0] & 0xFFFF;
                    x1 |= (cidata[1] & 0xFFFF) << 16;
                    int y1 = cidata[2] & 0xFFFF;
                    y1 |= (cidata[3] & 0xFFFF) << 16;
                    x1 = this.appleScale(x1, xoff, scale);
                    y1 = this.appleScale(y1, yoff, scale);
                    i = 5;
                    if ((cidata[length - 1] & 2) != 0) {
                        i += 5;
                    }
                    int rot = 0;
                    boolean trans = false;
                    if ((cidata[length - 1] & 4) != 0) {
                        int a1 = cidata[i] & 0xFFFF;
                        a1 = (a1 |= (cidata[i + 1] & 0xFFFF) << 16) == -2147483647 ? -1 : (a1 == Integer.MAX_VALUE ? 1 : 0);
                        int a2 = cidata[i + 2] & 0xFFFF;
                        a2 = (a2 |= (cidata[i + 3] & 0xFFFF) << 16) == -2147483647 ? -1 : (a2 == Integer.MAX_VALUE ? 1 : 0);
                        int a3 = cidata[i + 4] & 0xFFFF;
                        a3 = (a3 |= (cidata[i + 5] & 0xFFFF) << 16) == -2147483647 ? -1 : (a3 == Integer.MAX_VALUE ? 1 : 0);
                        int a4 = cidata[i + 6] & 0xFFFF;
                        a4 = (a4 |= (cidata[i + 7] & 0xFFFF) << 16) == -2147483647 ? -1 : (a4 == Integer.MAX_VALUE ? 1 : 0);
                        if (a1 == 0 && a2 == -1 && a3 == 1 && a4 == 0) {
                            rot = 900;
                        }
                        if (a1 == -1 && a2 == 0 && a3 == 0 && a4 == -1) {
                            rot = 1800;
                        }
                        if (a1 == 0 && a2 == 1 && a3 == -1 && a4 == 0) {
                            rot = 2700;
                        }
                        if (a1 == 0 && a2 == -1 && a3 == -1 && a4 == 0) {
                            trans = true;
                        }
                        if (a1 == -1 && a2 == 0 && a3 == 0 && a4 == 1) {
                            rot = 900;
                            trans = true;
                        }
                        if (a1 == 0 && a2 == 1 && a3 == 1 && a4 == 0) {
                            rot = 1800;
                            trans = true;
                        }
                        if (a1 == 1 && a2 == 0 && a3 == 0 && a4 == -1) {
                            rot = 2700;
                            trans = true;
                        }
                        i += 8;
                    }
                    if (subnp == null || curfacet == null) continue block20;
                    Orientation orient = Orientation.fromC(rot, trans);
                    AffineTransform mat = orient.pureRotate();
                    ERectangle subBounds = subnp.getBounds();
                    Point2D.Double dest = new Point2D.Double(0.0, 0.0);
                    mat.transform(new Point2D.Double(subBounds.getCenterX(), subBounds.getCenterY()), dest);
                    double vx = ((Point2D)dest).getX() + (double)x1;
                    double vy = ((Point2D)dest).getY() + (double)y1;
                    Point2D.Double center = new Point2D.Double(((RectangularShape)subBounds).getWidth(), ((RectangularShape)subBounds).getHeight());
                    ni = NodeInst.newInstance(subnp, center, vx * 2.0, vy * 2.0, curfacet, orient, null, 0);
                    if (ni != null) continue block20;
                    return false;
                }
                case 255: {
                    if (length != 2) {
                        System.out.println("End definition length=" + length);
                        return false;
                    }
                    if (curfacet == null) {
                        System.out.println("End definition has no associated begin");
                        return false;
                    }
                    curfacet = null;
                    break;
                }
                case 0: {
                    int i = 0;
                    while (true) {
                        if (i >= length - 2) continue block20;
                        this.appleGetWord();
                        ++i;
                    }
                }
                case 1: {
                    int i = 0;
                    while (true) {
                        if (i >= length - 2) continue block20;
                        this.appleGetWord();
                        ++i;
                    }
                }
                case 100: {
                    int i = 0;
                    while (true) {
                        if (i >= length - 2) continue block20;
                        this.appleGetWord();
                        ++i;
                    }
                }
                case 104: {
                    int i = 0;
                    while (true) {
                        if (i >= length - 2) continue block20;
                        this.appleGetWord();
                        ++i;
                    }
                }
                default: {
                    System.out.println("Unknown record type: " + type);
                    return true;
                }
            }
        }
    }

    private int appleGetChain() throws IOException {
        if ((this.appleState & 4) == 0) {
            this.appleState |= 4;
            int chain = this.appleGetWord();
            if (chain == 3 || chain == 1) {
                return chain;
            }
            if (Character.isDigit(chain & 0xFF) && Character.isDigit(chain >> 8 & 0xFF)) {
                this.appleGetWord();
                this.appleState |= 2;
                chain = this.appleGetWord();
            }
            if (chain == 768 || chain == 256) {
                this.appleState |= 1;
                chain >>= 8;
            }
            return chain;
        }
        if ((this.appleState & 2) != 0) {
            for (int i = 0; i < 4; ++i) {
                byte val = this.dataInputStream.readByte();
                this.updateProgressDialog(2);
                if (Character.isDigit(val)) continue;
                --i;
            }
        }
        int chain = this.appleGetWord();
        return chain;
    }

    private int appleGetWord() throws IOException {
        byte low = this.dataInputStream.readByte();
        byte high = this.dataInputStream.readByte();
        this.updateProgressDialog(2);
        if ((this.appleState & 1) == 0) {
            return low & 0xFF | (high & 0xFF) << 8;
        }
        return high & 0xFF | (low & 0xFF) << 8;
    }

    private double appleFloat(int lo, int hi, int exp) {
        int i = lo & 0xFFFF | (hi & 0xFFFF) << 16;
        exp = 31 - exp;
        double fl = i & Integer.MAX_VALUE;
        fl /= (double)(1 << exp);
        if ((i & Integer.MIN_VALUE) != 0) {
            fl = -fl;
        }
        return fl;
    }

    private void setupAppleLayers() {
        Technology tech = Technology.getCurrent();
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (pn.getFunction() != PrimitiveNode.Function.NODE) continue;
            Technology.NodeLayer[] nls = pn.getLayers();
            for (int i = 0; i < nls.length; ++i) {
                Technology.NodeLayer nl = nls[i];
                Layer lay = nl.getLayer();
                int appleLayer = lay.getIndex();
                this.appleNodeMap.put(new Integer(appleLayer), pn);
            }
        }
    }

    private int appleScale(int value, int offset, double scale) {
        double temp = value - offset;
        value = (int)(temp *= scale);
        if (value % 25 != 0) {
            value = value > 0 ? (value + 12) / 25 * 25 : (value - 12) / 25 * 25;
        }
        return value;
    }
}

