/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry.btree;

import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.PageStorage;
import java.util.LinkedHashMap;
import java.util.WeakHashMap;

public class CachingPageStorageWrapper
extends CachingPageStorage {
    private final PageStorage ps;
    private final WeakHashMap<Integer, CachedPageImpl> allCachedPages = new WeakHashMap();
    private final LinkedHashMap<Integer, CachedPageImpl> cache;
    private int cacheSize = 0;

    public CachingPageStorageWrapper(PageStorage ps, int cacheSize, boolean asyncFlush) {
        super(ps.getPageSize());
        this.ps = ps;
        this.cacheSize = cacheSize;
        this.cache = new LinkedHashMap(cacheSize + 3, 0.75f, true);
        if (asyncFlush) {
            throw new RuntimeException("asyncFlush is not yet supported");
        }
    }

    public int createPage() {
        return this.ps.createPage();
    }

    public int getNumPages() {
        return this.ps.getNumPages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachingPageStorage.CachedPage getPage(int pageid, boolean readBytes) {
        CachedPageImpl page = null;
        boolean doWait = false;
        boolean doNotify = false;
        Object object = this;
        synchronized (object) {
            page = this.cache.get(pageid);
            if (page != null) {
                readBytes = false;
            } else {
                page = this.allCachedPages.get(pageid);
                if (page != null) {
                    readBytes = false;
                    doWait = true;
                } else {
                    page = new CachedPageImpl(pageid, new byte[this.ps.getPageSize()]);
                    doNotify = true;
                }
            }
        }
        if (doWait) {
            object = page;
            synchronized (object) {
                if (!page.initialized) {
                    try {
                        page.wait();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if (readBytes) {
            this.ps.readPage(pageid, page.buf, 0);
        }
        page.touch();
        if (doNotify) {
            object = page;
            synchronized (object) {
                if (!page.initialized) {
                    page.initialized = true;
                    page.notifyAll();
                }
            }
        }
        return page;
    }

    public void writePage(int pageid, byte[] buf, int ofs) {
        CachingPageStorage.CachedPage page = this.getPage(pageid, false);
        System.arraycopy(buf, ofs, page.getBuf(), 0, this.ps.getPageSize());
        page.setDirty();
        page.flush();
    }

    public void readPage(int pageid, byte[] buf, int ofs) {
        CachingPageStorage.CachedPage page = this.getPage(pageid, true);
        System.arraycopy(page.getBuf(), 0, buf, ofs, this.ps.getPageSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int cacheSize) {
        CachingPageStorageWrapper cachingPageStorageWrapper = this;
        synchronized (cachingPageStorageWrapper) {
            this.cacheSize = cacheSize;
        }
        while (true) {
            CachedPageImpl cp = null;
            CachingPageStorageWrapper cachingPageStorageWrapper2 = this;
            synchronized (cachingPageStorageWrapper2) {
                if (this.cache.size() <= this.cacheSize) {
                    return;
                }
                cp = this.cache.entrySet().iterator().next().getValue();
            }
            cp.evict();
        }
    }

    public void fsync(int pageid) {
        this.ps.fsync(pageid);
    }

    public void fsync() {
        this.ps.fsync();
    }

    public synchronized void close() {
        for (CachedPageImpl cp : this.allCachedPages.values()) {
            cp.evict();
        }
        this.ps.close();
        this.cache.clear();
        this.allCachedPages.clear();
    }

    public class CachedPageImpl
    extends CachingPageStorage.CachedPage {
        private final int pageid;
        private final byte[] buf;
        private boolean isDirty;
        private boolean initialized = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CachedPageImpl(int pageid, byte[] buf) {
            this.pageid = pageid;
            this.buf = buf;
            this.isDirty = false;
            CachingPageStorageWrapper cachingPageStorageWrapper2 = CachingPageStorageWrapper.this;
            synchronized (cachingPageStorageWrapper2) {
                assert (!CachingPageStorageWrapper.this.allCachedPages.containsKey(this));
                CachingPageStorageWrapper.this.allCachedPages.put(pageid, this);
            }
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getPageId() {
            return this.pageid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void evict() {
            boolean needFlush = false;
            CachingPageStorageWrapper cachingPageStorageWrapper = CachingPageStorageWrapper.this;
            synchronized (cachingPageStorageWrapper) {
                CachedPageImpl cachedPageImpl = this;
                synchronized (cachedPageImpl) {
                    CachingPageStorageWrapper.this.cache.remove(this.pageid);
                    needFlush = this.isDirty();
                }
            }
            if (needFlush) {
                this.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void touch() {
            if (CachingPageStorageWrapper.this.cacheSize == 0) {
                return;
            }
            CachingPageStorageWrapper cachingPageStorageWrapper = CachingPageStorageWrapper.this;
            synchronized (cachingPageStorageWrapper) {
                CachingPageStorageWrapper.this.cache.remove(this.pageid);
            }
            block6: while (true) {
                cachingPageStorageWrapper = CachingPageStorageWrapper.this;
                synchronized (cachingPageStorageWrapper) {
                    if (CachingPageStorageWrapper.this.cache.size() < CachingPageStorageWrapper.this.cacheSize) {
                        CachingPageStorageWrapper.this.cache.put(this.pageid, this);
                        return;
                    }
                }
                while (true) {
                    if (CachingPageStorageWrapper.this.cache.size() < CachingPageStorageWrapper.this.cacheSize) continue block6;
                    ((CachedPageImpl)CachingPageStorageWrapper.this.cache.entrySet().iterator().next().getValue()).evict();
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDirty() {
            CachedPageImpl cachedPageImpl = this;
            synchronized (cachedPageImpl) {
                this.isDirty = true;
            }
            this.touch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            CachedPageImpl cachedPageImpl = this;
            synchronized (cachedPageImpl) {
                if (!this.isDirty) {
                    return;
                }
                CachingPageStorageWrapper.this.ps.writePage(this.pageid, this.buf, 0);
                this.isDirty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDirty() {
            CachedPageImpl cachedPageImpl = this;
            synchronized (cachedPageImpl) {
                return this.isDirty;
            }
        }
    }
}

