/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.WindowMenu;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvisibleLayerConfiguration {
    public static final int NUM_CONFIGS = EGraphics.getMaxTransparentLayer() + 1;
    private static InvisibleLayerConfiguration onlyOne = new InvisibleLayerConfiguration();
    private Map<String, List<String>> configurations = new HashMap<String, List<String>>();

    public static InvisibleLayerConfiguration getOnly() {
        return onlyOne;
    }

    private InvisibleLayerConfiguration() {
        int closePos;
        int openPos;
        String sc = User.savedConfigurations.getString();
        boolean[] overridden = new boolean[NUM_CONFIGS];
        while ((openPos = sc.indexOf(91)) >= 0 && (closePos = sc.indexOf(93)) >= 0) {
            String config = sc.substring(openPos + 1, closePos);
            sc = sc.substring(closePos + 1);
            String[] techParts = config.split("\t");
            if (techParts.length <= 1) continue;
            String cName = techParts[0];
            ArrayList<String> techPartsList = new ArrayList<String>();
            for (int i = 1; i < techParts.length; ++i) {
                if (techParts[i].startsWith("(")) {
                    int index = TextUtils.atoi(techParts[i].substring(1));
                    overridden[index] = true;
                }
                techPartsList.add(techParts[i]);
            }
            this.configurations.put(cName, techPartsList);
        }
        for (int i = 0; i < NUM_CONFIGS; ++i) {
            if (overridden[i]) continue;
            String menuName = this.getDefaultHardwiredName(i);
            String value = "(" + i + ")";
            ArrayList<String> techPartsList = new ArrayList<String>();
            techPartsList.add(value);
            this.configurations.put(menuName, techPartsList);
        }
    }

    private String getDefaultHardwiredName(int index) {
        String menuName = "Set ";
        menuName = index == 0 ? menuName + "All" : menuName + "M" + index;
        menuName = menuName + " Visible";
        return menuName;
    }

    public String getMenuName(int index) {
        String cName = this.findHardWiredConfiguration(index);
        if (cName == null) {
            return this.getDefaultHardwiredName(index);
        }
        return cName;
    }

    private void saveConfigurations() {
        StringBuffer sb = new StringBuffer();
        for (String cName : this.configurations.keySet()) {
            List<String> techParts = this.configurations.get(cName);
            sb.append('[');
            sb.append(cName);
            for (String techPart : techParts) {
                sb.append('\t');
                sb.append(techPart);
            }
            sb.append(']');
        }
        User.savedConfigurations.setString(sb.toString());
        WindowMenu.setDynamicVisibleLayerMenus();
    }

    public boolean exists(String cName) {
        List<String> techParts = this.configurations.get(cName);
        return techParts != null;
    }

    public void addConfiguration(String cName, int hardWiredIndex, Technology tech, List<Layer> layers) {
        StringBuffer sb = new StringBuffer();
        if (hardWiredIndex >= 0) {
            sb.append("(" + hardWiredIndex + ")");
        }
        sb.append(tech.getTechName());
        for (Layer layer : layers) {
            sb.append(',');
            if (layer.getTechnology() != tech) {
                sb.append(layer.getTechnology().getTechName() + ":");
            }
            sb.append(layer.getName());
        }
        List<String> techParts = this.configurations.get(cName);
        ArrayList<String> newTechParts = new ArrayList<String>();
        boolean found = false;
        if (techParts != null) {
            for (String techPart : techParts) {
                Technology thisTech;
                String[] iLayers = techPart.split(",");
                if (iLayers.length == 0) continue;
                String techName = iLayers[0];
                int endPos = techName.indexOf(41);
                if (endPos >= 0) {
                    techName = techName.substring(endPos + 1);
                }
                if ((thisTech = Technology.findTechnology(techName)) == null) continue;
                if (thisTech == tech) {
                    techPart = sb.toString();
                    found = true;
                }
                newTechParts.add(techPart);
            }
        }
        if (!found) {
            newTechParts.add(sb.toString());
        }
        this.configurations.put(cName, newTechParts);
        this.saveConfigurations();
    }

    public void renameConfiguration(String cName, String newName) {
        List<String> techParts = this.configurations.get(cName);
        if (techParts == null) {
            return;
        }
        this.configurations.remove(cName);
        this.configurations.put(newName, techParts);
        this.saveConfigurations();
    }

    public void deleteConfiguration(String cName, Technology tech) {
        List<String> techParts = this.configurations.get(cName);
        ArrayList<String> newTechParts = new ArrayList<String>();
        int hardIndex = -1;
        if (techParts != null) {
            for (String techPart : techParts) {
                Technology thisTech;
                String[] iLayers = techPart.split(",");
                if (iLayers.length == 0) continue;
                String techName = iLayers[0];
                int endPos = techName.indexOf(41);
                if (endPos >= 0) {
                    hardIndex = TextUtils.atoi(techName.substring(1));
                    techName = techName.substring(endPos + 1);
                }
                if ((thisTech = Technology.findTechnology(techName)) == tech) continue;
                newTechParts.add(techPart);
            }
        }
        if (newTechParts.size() == 0 && hardIndex >= 0) {
            String value = "(" + hardIndex + ")";
            newTechParts.add(value);
        }
        if (newTechParts.size() == 0) {
            this.configurations.remove(cName);
        } else {
            this.configurations.put(cName, newTechParts);
        }
        this.saveConfigurations();
    }

    public List<String> getConfigurationNames() {
        ArrayList<String> configs = new ArrayList<String>();
        for (String key : this.configurations.keySet()) {
            configs.add(key);
        }
        Collections.sort(configs);
        return configs;
    }

    public List<Technology> getConfigurationTechnology(String cName) {
        ArrayList<Technology> techs = new ArrayList<Technology>();
        List<String> techParts = this.configurations.get(cName);
        if (techParts != null) {
            for (String techPart : techParts) {
                Technology tech;
                String[] iLayers = techPart.split(",");
                if (iLayers.length == 0) continue;
                String techName = iLayers[0];
                int endPos = techName.indexOf(41);
                if (endPos >= 0) {
                    techName = techName.substring(endPos + 1);
                }
                if ((tech = Technology.findTechnology(techName)) == null) continue;
                techs.add(tech);
            }
        }
        return techs;
    }

    public String findHardWiredConfiguration(int index) {
        for (String cName : this.configurations.keySet()) {
            List<String> techLayers = this.configurations.get(cName);
            if (techLayers == null) continue;
            for (String techLayer : techLayers) {
                if (!techLayer.startsWith("(") || index != TextUtils.atoi(techLayer.substring(1))) continue;
                return cName;
            }
        }
        return null;
    }

    public int getConfigurationHardwiredIndex(String cName) {
        List<String> techLayers = this.configurations.get(cName);
        if (techLayers != null) {
            for (String techLayer : techLayers) {
                String techName;
                String[] iLayers = techLayer.split(",");
                if (iLayers.length == 0 || !(techName = iLayers[0]).startsWith("(")) continue;
                return TextUtils.atoi(techName.substring(1));
            }
        }
        return -1;
    }

    public Map<Technology, List<Layer>> getConfigurationValue(String cName) {
        HashMap<Technology, List<Layer>> invisibleLayers = new HashMap<Technology, List<Layer>>();
        List<String> techParts = this.configurations.get(cName);
        if (techParts != null) {
            for (String techPart : techParts) {
                Technology tech;
                String[] iLayers = techPart.split(",");
                if (iLayers.length == 0) continue;
                String techName = iLayers[0];
                int endPos = techName.indexOf(41);
                if (endPos >= 0) {
                    techName = techName.substring(endPos + 1);
                }
                if ((tech = Technology.findTechnology(techName)) == null) continue;
                for (int i = 1; i < iLayers.length; ++i) {
                    Layer lay;
                    String iLayer = iLayers[i];
                    int colonPos = iLayer.indexOf(58);
                    Technology findTech = tech;
                    if (colonPos >= 0) {
                        findTech = Technology.findTechnology(iLayer.substring(0, colonPos));
                        iLayer = iLayer.substring(colonPos + 1);
                    }
                    if ((lay = findTech.findLayer(iLayer)) == null) continue;
                    ArrayList<Layer> curLays = (ArrayList<Layer>)invisibleLayers.get(tech);
                    if (curLays == null) {
                        curLays = new ArrayList<Layer>();
                        invisibleLayers.put(tech, curLays);
                    }
                    curLays.add(lay);
                }
            }
        }
        return invisibleLayers;
    }
}

