/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input.bookshelf;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.bookshelf.BookshelfInputParser;
import com.sun.electric.tool.io.input.bookshelf.BookshelfNodes;
import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BookshelfNets
implements BookshelfInputParser<Void> {
    private String fileName;
    private Library lib;
    private final EditingPreferences ep;
    private Map<String, PortInst> netIndex = CollectionFactory.createHashMap();

    public BookshelfNets(String fileName, Library lib, EditingPreferences ep) {
        this.fileName = fileName;
        this.lib = lib;
        this.ep = ep;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Void parse() throws IOException {
        String line;
        BufferedReader rin;
        Job.getUserInterface().setProgressNote("Parse Net List File: Step 1/4");
        this.netIndex.clear();
        try {
            File file = new File(this.fileName);
            FileReader freader = new FileReader(file);
            rin = new BufferedReader(freader);
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR: Cannot find Bookshelf Nets file: " + this.fileName);
            return null;
        }
        HashMap pins = CollectionFactory.createHashMap();
        HashMap<BookshelfNodes.BookshelfNode, TreeSet<CallSite>> nodePorts = new HashMap<BookshelfNodes.BookshelfNode, TreeSet<CallSite>>();
        Technology mocmos = Technology.getMocmosTechnology();
        ArrayList<BookshelfNet> allNets = new ArrayList<BookshelfNet>();
        while ((line = rin.readLine()) != null) {
            if (!line.startsWith("NetDegree")) continue;
            NetDesc desc = this.parseNetDesc(line);
            BookshelfNet net = new BookshelfNet(desc.netName);
            allNets.add(net);
            for (int i = 0; i < desc.elements; ++i) {
                line = rin.readLine();
                BookshelfNodes.BookshelfPin pin = this.parsePin(line, net);
                if (!pins.containsKey(pin.getNodeName())) {
                    pins.put(pin.getNodeName(), (String)((Object)new ArrayList()));
                }
                ((List)pins.get(pin.getNodeName())).add(pin);
                net.getPins().add(pin);
                BookshelfNodes.BookshelfNode bookshelfNode = BookshelfNodes.BookshelfNode.findNode(pin.getNodeName());
                if (bookshelfNode == null) continue;
                TreeSet<CallSite> portsOnNode = (TreeSet<CallSite>)nodePorts.get(bookshelfNode);
                if (portsOnNode == null) {
                    portsOnNode = new TreeSet<CallSite>();
                    nodePorts.put(bookshelfNode, portsOnNode);
                }
                portsOnNode.add((CallSite)((Object)(pin.getLocation().getX() + "," + pin.getLocation().getY())));
            }
        }
        rin.close();
        Job.getUserInterface().setProgressNote("Parse Net List File: Step 2/4");
        LinkedHashMap nodesBySize = new LinkedHashMap();
        int allNodesNum = BookshelfNodes.BookshelfNode.getAllNodes().size();
        int counter = 0;
        for (BookshelfNodes.BookshelfNode bookshelfNode : BookshelfNodes.BookshelfNode.getAllNodes()) {
            void var14_21;
            List list;
            Job.getUserInterface().setProgressValue(counter * 100 / allNodesNum);
            String bnName = bookshelfNode.getWidth() + "X" + bookshelfNode.getHeight();
            bnName = bnName + "Y" + Boolean.toString(bookshelfNode.isTerminal());
            Set ports = (Set)nodePorts.get(bookshelfNode);
            if (ports != null) {
                for (String portName : ports) {
                    bnName = bnName + "/" + portName;
                }
            }
            if ((list = (List)nodesBySize.get(bnName)) == null) {
                ArrayList arrayList = new ArrayList();
                nodesBySize.put((CallSite)((Object)bnName), arrayList);
            }
            var14_21.add(bookshelfNode);
            ++counter;
        }
        Job.getUserInterface().setProgressNote("Parse Net List File: Step 3/4");
        int cellNumber = 1;
        counter = 0;
        allNodesNum = nodesBySize.keySet().size();
        for (String desc : nodesBySize.keySet()) {
            Job.getUserInterface().setProgressValue(counter * 100 / allNodesNum);
            List nodes = (List)nodesBySize.get(desc);
            String[] stringArray = desc.split("/");
            String[] size = stringArray[0].split("Y")[0].split("X");
            String terminal = stringArray[0].split("Y")[1];
            double width = TextUtils.atof(size[0]);
            double height = TextUtils.atof(size[1]);
            Cell cell = Cell.makeInstance(this.ep, this.lib, "Cell" + cellNumber + "{lay}");
            cell.setTechnology(mocmos);
            for (BookshelfNodes.BookshelfNode bn : nodes) {
                bn.setPrototype(cell);
            }
            ++cellNumber;
            PrimitiveNode np = Artwork.tech().boxNode;
            NodeInst nInst = NodeInst.makeInstance(np, this.ep, EPoint.fromLambda(0.0, 0.0), width, height, cell);
            if (terminal.equals(Boolean.toString(true))) {
                nInst.setLocked();
            }
            int portNum = 1;
            for (int i = 1; i < stringArray.length; ++i) {
                String[] xy = stringArray[i].split(",");
                double x = TextUtils.atof(xy[0]);
                double y = TextUtils.atof(xy[1]);
                PrimitiveNode pin = mocmos.findNodeProto("Metal-1-Pin");
                NodeInst ni = NodeInst.makeInstance(pin, this.ep, EPoint.fromLambda(x, y), 0.0, 0.0, cell);
                PortInst pi = ni.getOnlyPortInst();
                Export.newInst(cell, pi, "P" + portNum, this.ep);
                ++portNum;
            }
            ++counter;
        }
        Cell cell = Cell.makeInstance(this.ep, this.lib, this.lib.getName() + "{lay}");
        cell.setTechnology(mocmos);
        Collection<BookshelfNodes.BookshelfNode> allNodes = BookshelfNodes.BookshelfNode.getAllNodes();
        for (BookshelfNodes.BookshelfNode bookshelfNode : allNodes) {
            Cell np = bookshelfNode.getPrototype();
            NodeInst ni = NodeInst.newInst(np, this.ep, new Point2D.Double(bookshelfNode.getX(), bookshelfNode.getY()), bookshelfNode.getWidth(), bookshelfNode.getHeight(), cell, Orientation.IDENT, bookshelfNode.getName());
            Variable.Key key = Variable.newKey("weight");
            Variable var = Variable.newInst(key, bookshelfNode.getWeight(), this.ep.getNodeTextDescriptor());
            ni.addVar(var);
            bookshelfNode.setInstance(ni);
        }
        Job.getUserInterface().setProgressNote("Parse Net List File: Step 4/4");
        allNodesNum = allNets.size();
        counter = 0;
        for (BookshelfNet bookshelfNet : allNets) {
            Job.getUserInterface().setProgressValue(counter * 100 / allNodesNum);
            Job.getUserInterface().setProgressNote("Parse Net List File: Step 4/4 (" + counter + "/" + allNodesNum + ")");
            BookshelfNodes.BookshelfPin lastPin = null;
            for (BookshelfNodes.BookshelfPin bp : bookshelfNet.getPins()) {
                if (lastPin != null) {
                    BookshelfNodes.BookshelfNode bn1 = BookshelfNodes.BookshelfNode.findNode(lastPin.getNodeName());
                    BookshelfNodes.BookshelfNode bn2 = BookshelfNodes.BookshelfNode.findNode(bp.getNodeName());
                    EPoint ep1 = EPoint.fromLambda(lastPin.getLocation().getX(), lastPin.getLocation().getY());
                    EPoint ep2 = EPoint.fromLambda(bp.getLocation().getX(), bp.getLocation().getY());
                    PortInst pi1 = null;
                    Iterator<Export> it = bn1.getPrototype().getExports();
                    while (it.hasNext()) {
                        Export e = it.next();
                        NodeInst ni = e.getOriginalPort().getNodeInst();
                        if (ni.getAnchorCenterX() != ep1.getX() || ni.getAnchorCenterY() != ep1.getY()) continue;
                        pi1 = bn1.getInstance().findPortInstFromProto(e);
                        break;
                    }
                    PortInst pi2 = null;
                    Iterator<Export> it2 = bn2.getPrototype().getExports();
                    while (it2.hasNext()) {
                        Export e = it2.next();
                        NodeInst ni = e.getOriginalPort().getNodeInst();
                        if (ni.getAnchorCenterX() != ep2.getX() || ni.getAnchorCenterY() != ep2.getY()) continue;
                        pi2 = bn2.getInstance().findPortInstFromProto(e);
                        break;
                    }
                    if (pi1 == null) {
                        System.out.println("UNABLE TO FIND PORT AT (" + lastPin.getLocation().getX() + "," + lastPin.getLocation().getY() + ") ON INSTANCE " + bn1.getName() + " (CELL " + bn1.getPrototype().describe(false) + ")");
                        continue;
                    }
                    if (pi2 == null) {
                        System.out.println("UNABLE TO FIND PORT AT (" + bp.getLocation().getX() + "," + bp.getLocation().getY() + ") ON INSTANCE " + bn2.getName() + " (CELL " + bn2.getPrototype().describe(false) + ")");
                        continue;
                    }
                    EPoint p1 = EPoint.fromLambda(bn1.getX() + ep1.getLambdaX(), bn1.getY() + ep1.getLambdaY());
                    EPoint p2 = EPoint.fromLambda(bn2.getX() + ep2.getLambdaX(), bn2.getY() + ep2.getLambdaY());
                    ArcProto ap = Generic.tech().unrouted_arc;
                    this.newInst(cell, ap, bookshelfNet.name, pi1, pi2, p1, p2, 0L, 0, 0);
                }
                lastPin = bp;
                ++counter;
            }
        }
        return null;
    }

    public void newInst(Cell parent, ArcProto protoType, String name, PortInst headPort, PortInst tailPort, EPoint headPt, EPoint tailPt, long gridExtendOverMin, int angle, int flags) {
        TextDescriptor td = this.ep.getArcTextDescriptor();
        ArcInst.newInstanceNoCheck(parent, protoType, name, td, headPort, tailPort, headPt, tailPt, gridExtendOverMin, angle, flags);
    }

    private BookshelfNodes.BookshelfPin parsePin(String line, BookshelfNet net) {
        String[] splited = line.trim().split(" ");
        double xPos = 0.0;
        double yPos = 0.0;
        if (splited.length == 6) {
            xPos = Double.parseDouble(splited[4]);
            yPos = Double.parseDouble(splited[5]);
        }
        Point2D.Double location = new Point2D.Double(xPos, yPos);
        return new BookshelfNodes.BookshelfPin(location, net, splited[0]);
    }

    private NetDesc parseNetDesc(String line) {
        NetDesc result = new NetDesc();
        String[] splited = line.split(" ");
        result.elements = Integer.parseInt(splited[2]);
        result.netName = splited[splited.length - 1];
        return result;
    }

    private class NetDesc {
        public String netName;
        public int elements;

        private NetDesc() {
        }
    }

    public static class BookshelfNet {
        private List<BookshelfNodes.BookshelfNode> nodes = CollectionFactory.createArrayList();
        private List<BookshelfNodes.BookshelfPin> pins = CollectionFactory.createArrayList();
        private String name;

        public BookshelfNet(String name) {
            this.name = name;
        }

        public void setNodes(List<BookshelfNodes.BookshelfNode> nodes) {
            this.nodes = nodes;
        }

        public List<BookshelfNodes.BookshelfNode> getNodes() {
            return this.nodes;
        }

        public void setPins(List<BookshelfNodes.BookshelfPin> pins) {
            this.pins = pins;
        }

        public List<BookshelfNodes.BookshelfPin> getPins() {
            return this.pins;
        }
    }
}

