
(progn
 (setq prefs-home-emacs-p t)
 (setq prefs-lcd-emacs-p nil)
 (setq prefs-advanced-user-p t)
 (setq prefs-windows-bindings-p nil)
 (setq prefs-calendar-online-p nil)

 (setq prefs-font-p t)
 (setq prefs-font-libd-p t)
 (setq prefs-font-xtra-p t)
 (setq prefs-font-lisp++-p t)
 (setq prefs-scratch-java-online-p t)
 (setq prefs-scratch-libd-online-p t)
 (setq prefs-safe-comands-online-p t)
 (setq os-type--linux-p t)
)

(progn
  (setq debug-ignored-errors (cdr debug-ignored-errors))
  (setq debug-ignored-errors (remove 'beginning-of-buffer debug-ignored-errors))
  (setq debug-ignored-errors (remove "Args out of range" debug-ignored-errors))
  (setq debug-ignored-errors (remove 'search-failed debug-ignored-errors))
  (setq debug-ignored-errors (remove "Symbol's function definition is void" debug-ignored-errors))
  (setq debug-ignored-errors (add-to-list 'debug-ignored-errors 'beginning-of-buffer))
  (setq debug-ignored-errors (remove "Selecting deleted buffer" debug-ignored-errors))
  )

(progn
  (setq load-path (cons "~/cedet-1.1/" load-path))
  ;;(setq load-path (cons "~davin/emacs/lisp/" load-path))
  (if (boundp 'safe-expand-file-name)
      (setq load-path (cons (safe-expand-file-name "~/dlisp/imported-stuff/") load-path))
    (setq load-path (cons "~/dlisp/imported-stuff/" load-path)))
  (setq load-path (cons "~/dlisp" load-path))
)

(require 'eieio)

(load-file (concat (car load-path) "/emergency-bindings.el"))
(load-file (concat (car load-path) "/d-start.el"))

;;(assert nil)

(setq file-name-history (cons "~/dlisp/" file-name-history))

(setq inhibit-splash-screen t)

(defun beep ()
  (if visible-bell
      (ding)
    (if (file-exists-p "/media/www/C80GB/WINDOWS/Media/ding.wav")
        (play-sound (list 'sound :file "/media/www/C80GB/WINDOWS/Media/ding.wav" :volume 1.0))
      (if (file-exists-p "/media/www/C1TB/Windows/Media/ding.wav")
          (play-sound (list 'sound :file "/media/www/C1TB/Windows/Media/ding.wav"))))
    ))

;;(let ((visible-bell nil)) (beep))

;;; NOTE: Inits frame to appear as fullscreen maximized
(add-to-list 'default-frame-alist '(fullscreen . maximized))

(setq tags-table-list
      '("/media/www/C1TB/Program Files (x86)/emacs-23.1/lisp/"
        "~/dlisp/TAGS"
        "~/c2java/TAGS"))

(defadvice d-super-f3 (around patch-many activate)
  (if (y-or-n-p "Really save *.c files?")
      ad-do-it))

(defadvice d-f2 (around patch-many activate)
  (if (y-or-n-p "Really save *.c files?")
      ad-do-it))

(defun d-f3-a ()
  (interactive)
  (let ((ptr (buffer-list)))
    (while ptr
      (when (buffer-live-p (car ptr))
        (set-buffer (car ptr))
        (if (buffer-file-name)
            (if (and (not (string-match "/TAGS" (buffer-file-name)))
                     (not (string= (buffer-file-name) "/media/www/C80GB/allegro-403/docs/txt/allegro.txt"))
                     (not (string-match "/A[0-9]+\\.c$" (buffer-file-name)))
                     (not (string-match "/A[0-9]+\\.c2j$" (buffer-file-name)))
                     )
                (kill-buffer (car ptr)))))
      (setq ptr (cdr ptr))) ;; END WHILE!
    ))

(defun d-f3-b ()
  "kills dired buffers"
  (let ((ptr (buffer-list)))
    (while ptr
      (if (and (buffer-live-p (car ptr))
               (save-excursion
                 (set-buffer (car ptr))
                 (and (eq major-mode 'dired-mode)
                      (not (string-match "/bamboo_system_files/"  default-directory))
                      (not (string-match "/Driver Pack Solution/" default-directory))
                      (not (string-match "/wordpress/"            default-directory))
                      )))
          (kill-buffer (car ptr)))
      (setq ptr (cdr ptr)))))

(defun d-f3-c ()
  "Also kills dired buffers"
  (let ((ptr (buffer-list)))
    (while ptr ;;(setq ptr (list (get-buffer " SPEEDBAR")))
      (cond
       ((and (buffer-live-p (car ptr))
             (buffer-name (car ptr))
             (= (aref (buffer-name (car ptr)) 0) ?*)
             (not (d-is-good-buffer (car ptr))))
        (kill-buffer (car ptr)))
       ((and (buffer-live-p (car ptr))
             (save-excursion
               (set-buffer (car ptr))
               (and (not (buffer-file-name))
                    (buffer-name)
                    (eq major-mode 'dired-mode)
                    (not (string-match "/bamboo_system_files/"  default-directory))
                    (not (string-match "/Driver Pack Solution/" default-directory))
                    (not (string-match "/wordpress/"            default-directory))
                    )))
        (kill-buffer (car ptr)))
       ((and (buffer-live-p (car ptr))
             (save-excursion
               (set-buffer (car ptr))
               (and (not (buffer-file-name))
                    (buffer-name)
                    (/= (aref (buffer-name) 0) ?\ )
                    (/= (aref (buffer-name) 0) ?*)
                    (not (string= "bamboo_system_files"  (buffer-name)))
                    (not (string= "Driver Pack Solution" (buffer-name)))
                    (not (string= "wordpress"            (buffer-name)))
                    )))
        (kill-buffer (car ptr))))
      (setq ptr (cdr ptr)))))

(safe-require 'dired-colours)

(defun d-init-dired-colours ()
  (let ((d-message-on t))
    (message "BEG d-init-dired-colours")
    (setq dc-files-list--text        (append '("lzz") dc-files-list--text))
    (setq dc-files-list--sources     (append `(,(regexp-quote "c++")
                                               ,(regexp-quote "ch++")
                                               ,(regexp-quote "h++")
                                               "c2j" "glued" "ch" "inc" "mk" "src" "jtw" "el[+][+]" ,(regexp-quote "lisp++"))
                                             dc-files-list--sources))

    (setq dc-files-list--sources     (remove "cpp" dc-files-list--sources))

    (setq dc-files-list--executable  (append '("run" "swf")       dc-files-list--executable))
    (setq dc-files-list--unimportant (append '("dep" "num" "tm4") dc-files-list--unimportant))
    (setq dc-files-list--web         (append '("hts" "htz" "tes" "ist" "latex") dc-files-list--web))
    (setq dc-files-list--binaries    (append '("p2a2")            dc-files-list--binaries))
    (setq dc-files-list--graphics    (append '("a2d" "rle")       dc-files-list--graphics))
    ;;(message "END d-init-dired-colours")
    ;;(beep)
    ;;(sit-for 1)
    ))

(d-init-dired-colours)

;;(run-with-timer 5 nil 'd-init-dired-colours)
;;(describe-variable 'timer-list)

(global-auto-revert-mode 1)

;;(dired "~/")

(setq debug-ignored-errors (remove "Containing expression ends prematurely" debug-ignored-errors))

;;; NOTE CAREFUL: error in this file causes the rest of .emacs to fail loading
(unwind-protect
    (if (file-exists-p "~/c2java/patch-c2j.el")
        (load-file "~/c2java/patch-c2j.el"))
  (message "Failed to load ~/c2java/patch-c2j.el"))

(d-xmodmap)

(global-set-key [pause] 'electric-buffer-list)

(if (file-exists-p "~/c2java/")
    (d-find-file "~/c2java/A*.c"))

(require 'speedbar)

(run-with-timer 5 nil 'd-fonts--init-dired-colours)

(setq d-done t)

(put 'scroll-left 'disabled nil)

(setq use-file-dialog nil)

;;(setq view-read-only nil)
;;(load-file "~/dlisp/d-speedbar.el")

(put 'dired-find-alternate-file 'disabled nil)

(load-file "~davin/emacs/lisp/emacs-lisp/generator.el")

