/*

  logclass.cc

  class definitions for xlogmaster.cc
  Copyright (C) 1998 Georg C. F. Greve
  This is a GNU program
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  
  
  Contact: 
           mailto:xlogmaster-bugs@gnu.org
           http://www.gnu.org/software/xlogmaster/
  Secondary sources:
           http://porter.desy.de/~greve/xlogmaster/
           http://www.fusebox.hanse.de/xlogmaster/
	 
*/

/*{{{  Header  */

#include "../config.h"
#include "sysinc.H"
#include "logclass.H"
#include "extern.H"

/*}}}*/

/*
  Log Class Routines:
 */
/*{{{  Constructor & Destructor  */
Log::Log(){
  mode = EMPTY;
  interval = -1;
  filename = NULL;
  help = NULL;
  buttontext = NULL;
  commandline = NULL;
  tag =  0;
  filter = NULL;
  filterclass = NO_FILTER;
  wd_tag = 0;
  buffer = NULL;
  rbuffer = NULL;
  length = 0;
  chunk = (long) RDBLCK * INTERVAL;

  // to be used out of alert.cc:
  alert_tag = 0;
  fade = last_fade = fadestep = 0;
  pixels[0] = 0;
  pixels[1] = 0;

  active = FALSE;

  return;
};
Log::~Log(){
  if ( filename != NULL ) delete filename;
  if ( help != NULL ) delete help;
  if ( buttontext != NULL ) delete buttontext;
  if ( commandline != NULL ){
    int i = 0;
    while ( commandline[i] != NULL ) delete commandline[i++];
    delete commandline;
  }
  if ( filter != NULL ){
    int i = 0;
    while ( filter[i] != NULL ) delete filter[i++];
    delete filter;
  }
  if ( buffer != NULL ) delete buffer;
  if ( rbuffer != NULL ) delete rbuffer;
  buffer = rbuffer = NULL;

  return;
};
/*}}}*/


/*  
  Filter Class Routines
*/

/*{{{  Constructor & Destructor  */
Filter::Filter(){
 
  string = NULL;
  pattern = NULL;
  execline = NULL;
  mode = NO_CHANGE;

  return;
};
Filter::~Filter(){
  
  if ( string != NULL ) delete string;
  if ( pattern != NULL ) delete pattern;
  if ( execline != NULL ) delete execline;
  mode = NO_CHANGE;

  return;
};
/*}}}*/

/*{{{  init()  */
Filter::init(const char* str, gint new_mode){
  mode = new_mode;

  string = new char[strlen(str)+2];
  strcpy(string, str);

  pattern = new char[strlen(str)+2];
  int a = 0;
  int b = 0;
  char last = 0;
  while ( string[a] != 0 ){
    if ( b == 0 && ( string[a] == '*' || string[a] == '?' ) ){
      // suppress leading wildcards
      a++;
    } else if ( string[a] == '*' && last == '*' ){
      // We don't want *'s in a row ...
      a++;
    } else {
      last = string[a];
      pattern[b] = string[a];
      if ( pattern[b] >= 'a' && pattern[b] <= 'z' ) pattern[b] -= 'a' - 'A';
      b++;
      a++;
    }
  }
  while ( pattern[b-1] == '?' || pattern[b-1] == '*' ) b--; // suppress trailing wildcards
  pattern[b] = 0; // set 0 termination
  
}
/*}}}*/

/*{{{  purge()  */
Filter::purge(){

  if ( string != NULL ) delete string;
  if ( pattern != NULL ) delete pattern;
  if ( execline != NULL ) delete execline;
  string = NULL;
  pattern = NULL;
  execline = NULL;
  mode = NO_CHANGE;

}
/*}}}*/
