/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.ConsoleTextArea;
import com.izforge.izpack.util.StdIn;
import com.izforge.izpack.util.StdOut;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class Console {
    public static int INITIAL_WIDTH = 800;
    public static int INITIAL_HEIGHT = 600;
    private StdOut so;
    private StdOut se;

    public static void main(String[] stringArray) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(stringArray);
            new Console(process);
            System.exit(process.exitValue());
        }
        catch (IOException iOException) {
            System.out.println("Error starting: " + stringArray[0]);
            System.out.println(iOException);
        }
    }

    public String getOutputData() {
        if (this.so != null) {
            return this.so.getData();
        }
        return "";
    }

    public String getErrorData() {
        if (this.se != null) {
            return this.se.getData();
        }
        return "";
    }

    public Console(Process process) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Console");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - INITIAL_WIDTH / 2, dimension.height / 2 - INITIAL_HEIGHT / 2);
        ConsoleTextArea consoleTextArea = new ConsoleTextArea();
        JScrollPane jScrollPane = new JScrollPane(consoleTextArea);
        jScrollPane.setPreferredSize(new Dimension(INITIAL_WIDTH, INITIAL_HEIGHT));
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        this.so = new StdOut(process, consoleTextArea);
        this.se = new StdOut(process, consoleTextArea);
        StdIn stdIn = new StdIn(process, consoleTextArea);
        this.so.start();
        this.se.start();
        stdIn.start();
        try {
            jFrame.setVisible(true);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error during execution");
            System.out.println(interruptedException);
        }
        try {
            this.so.done();
            this.se.done();
            stdIn.done();
            this.so.join();
            this.se.join();
            stdIn.join();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error in StdOut, StdErr or StdIn.");
            System.out.println(interruptedException);
        }
        jFrame.setVisible(false);
    }
}

