/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal class DtdFile : NameValueFile
{

private readonly static string m_commExp = @"<!--.*?-->";


//public const string m_quotExp = @"<!ENTITY\s*([\w\.]+)\s*(\""([^\""]*)\"")\s*>";
//public cont string m_aposExp = @"<!ENTITY\s*([\w\.]+)\s*(\'([^\']*)\')\s*>";

public const string m_quotExp = @"<!ENTITY\s*([^\s\""]+)\s*(\""([^\""]*)\"")\s*>";
public const string m_aposExp = @"<!ENTITY\s*([^\s\']+)\s*(\'([^\']*)\')\s*>";


private List<string> m_mergeCommentsLog = null;
private string m_content2;
//private readonly static string m_quotExp = @"<!ENTITY\s*([\w\.]*)\s*(?<quot>[\""\'])([^\k<quot>]*)\k<quot>\s*>";


public DtdFile(string path) : base(path)
{
}


public override void LoadContent()
{
    m_content = this.LoadText();
}


public override Merge GetMerge()
{
    return new MergeDtd(this);
}


public string SanitizeContent(List<string> commentsLog)
{
    m_mergeCommentsLog = commentsLog;
    string txt = this.SanitizeComments(m_content);
    m_mergeCommentsLog = null;
    return txt;
}


/*
    <!-- localization credits look like this: -->
    <!--  XXX
    <!ENTITY credit.translation
      "<h3>Translators</h3><ul><li>Name Here</li></ul>">
       ***
    -->
    <!ENTITY credit.translation "">
*/
private string SanitizeComments(string sourceFile)
{
    // remove comments: they could contain <!ENTITY ... >
    MatchEvaluator myDelegate = new MatchEvaluator(this.ReplaceCommentCallback);
    return Regex.Replace(sourceFile, m_commExp, myDelegate, RegexOptions.Singleline);
}


// [0] "<!--...-->"
private string ReplaceCommentCallback(Match match)
{
    if (m_mergeCommentsLog == null) {
        return string.Empty;
    }
    GroupCollection groups = match.Groups;
    m_mergeCommentsLog.Add(groups[0].Value);
    return "<&SAFEPLACEHOLDER#" + (m_mergeCommentsLog.Count - 1).ToString() + "&>";
}


public Dictionary<string, string> LoadHashtableQuoted()
{
    Dictionary<string, string> keys = new Dictionary<string, string>();
    m_content2 = this.SanitizeComments(m_content);
    LoadHashtableCore(m_quotExp, keys, 2, false);
    LoadHashtableCore(m_aposExp, keys, 2, false);
    m_content2 = null;
    return keys;
}


public override Dictionary<string, string> LoadHashtableLogged()
{
    Dictionary<string, string> keys = new Dictionary<string, string>();
    m_content2 = this.SanitizeComments(m_content);
    LoadHashtableCore(m_quotExp, keys, 3, true);
    LoadHashtableCore(m_aposExp, keys, 3, true);
    m_content2 = null;
    return keys;
}


private Dictionary<string, string> m_hashtableCache = null;


public override Dictionary<string, string> LoadHashtable()
{
    if (m_hashtableCache == null) {
        Dictionary<string, string> keys = new Dictionary<string, string>();
        m_content2 = this.SanitizeComments(m_content);
        LoadHashtableCore(m_quotExp, keys, 3, false);
        LoadHashtableCore(m_aposExp, keys, 3, false);
        m_content2 = null;
        m_hashtableCache = keys;
    }
    return m_hashtableCache;
}


public override Dictionary<string, string> LoadHashtableDecoded()
{
    Dictionary<string, string> table = this.LoadHashtable();
    Dictionary<string, string> decodedTable = new Dictionary<string, string>();

    Dictionary<string, string>.Enumerator allKeys = table.GetEnumerator();
    while (allKeys.MoveNext()) {
        string key = allKeys.Current.Key;
        string content = allKeys.Current.Value;
        decodedTable[key] = content;
    }

    return decodedTable;
}


private void LoadHashtableCore(string expr, Dictionary<string, string> table, int idxMatch, bool logError)
{
    // extract key-value
    Regex regex = new Regex(expr);
    MatchCollection originalMatches = regex.Matches(m_content2);
    for (int idx = 0; idx < originalMatches.Count; idx++) {
        // [0] "<!ENTITY copyright              "Credits">"
        // [1] copyright
        // [2] "Credits"
        // [3] Credits
        GroupCollection groups = originalMatches[idx].Groups;
        if (groups.Count < 4) {
            continue;
        }
        string val = groups[idxMatch].Value;
        val = Decode(val);
        NameValueFile.AddToHashtable(table, groups[1].Value, val, logError ? m_path : null);
    }
}


private static string Decode(string txt)
{
    txt = txt.Replace("\r\n", "\n");
    txt = txt.Replace("\r",   "\n");

    MatchEvaluator myDelegate;
    myDelegate = new MatchEvaluator(ReplaceEntityCallback);
    txt = Regex.Replace(txt, @"&#([0-9]+);", myDelegate);
    //txt = Escape.UnEscape(txt);

    //txt = txt.Replace("&quote;", "\"");
    //txt = txt.Replace("&lt;",    "<");

    return txt;
}


// [0] "&#123;"
// [1] "123"
private static string ReplaceEntityCallback(Match match)
{
    GroupCollection groups = match.Groups;
    int code = int.Parse(groups[1].Value);
    return ((char) code).ToString();
}


}//class
}//ns
