/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.security.AccessController;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.dom.DocumentLoadListener;
import org.mozilla.dom.JavaDOMPermission;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class DOMAccessor {
    private static Vector documentLoadListeners = new Vector();
    private static JavaDOMPermission permission = new JavaDOMPermission("JavaDOM");

    private void DOMAccessorImpl() {
    }

    private static native void register();

    private static native void unregister();

    private static native Node getNodeByHandle(long var0);

    private static native void doGC();

    public static native void initialize();

    public static synchronized void addDocumentLoadListener(DocumentLoadListener documentLoadListener) {
        if (documentLoadListeners.size() == 0) {
            DOMAccessor.register();
        }
        documentLoadListeners.addElement(documentLoadListener);
    }

    public static synchronized void removeDocumentLoadListener(DocumentLoadListener documentLoadListener) {
        documentLoadListeners.removeElement(documentLoadListener);
        if (documentLoadListeners.size() == 0) {
            DOMAccessor.unregister();
        }
    }

    public static synchronized void startURLLoad(String string, String string2, long l) {
        AccessController.checkPermission(permission);
        Enumeration enumeration = documentLoadListeners.elements();
        while (enumeration.hasMoreElements()) {
            DocumentLoadListener documentLoadListener = (DocumentLoadListener)enumeration.nextElement();
            documentLoadListener.startURLLoad(string, string2, (Document)DOMAccessor.getNodeByHandle(l));
        }
        DOMAccessor.doGC();
    }

    public static synchronized void endURLLoad(String string, int n, long l) {
        AccessController.checkPermission(permission);
        Enumeration enumeration = documentLoadListeners.elements();
        while (enumeration.hasMoreElements()) {
            DocumentLoadListener documentLoadListener = (DocumentLoadListener)enumeration.nextElement();
            documentLoadListener.endURLLoad(string, n, (Document)DOMAccessor.getNodeByHandle(l));
        }
        DOMAccessor.doGC();
    }

    public static synchronized void progressURLLoad(String string, int n, int n2, long l) {
        AccessController.checkPermission(permission);
        Enumeration enumeration = documentLoadListeners.elements();
        while (enumeration.hasMoreElements()) {
            DocumentLoadListener documentLoadListener = (DocumentLoadListener)enumeration.nextElement();
            documentLoadListener.progressURLLoad(string, n, n2, (Document)DOMAccessor.getNodeByHandle(l));
        }
        DOMAccessor.doGC();
    }

    public static synchronized void statusURLLoad(String string, String string2, long l) {
        AccessController.checkPermission(permission);
        Enumeration enumeration = documentLoadListeners.elements();
        while (enumeration.hasMoreElements()) {
            DocumentLoadListener documentLoadListener = (DocumentLoadListener)enumeration.nextElement();
            documentLoadListener.statusURLLoad(string, string2, (Document)DOMAccessor.getNodeByHandle(l));
        }
        DOMAccessor.doGC();
    }

    public static synchronized void startDocumentLoad(String string) {
        AccessController.checkPermission(permission);
        Enumeration enumeration = documentLoadListeners.elements();
        while (enumeration.hasMoreElements()) {
            DocumentLoadListener documentLoadListener = (DocumentLoadListener)enumeration.nextElement();
            documentLoadListener.startDocumentLoad(string);
        }
        DOMAccessor.doGC();
    }

    public static synchronized void endDocumentLoad(String string, int n, long l) {
        AccessController.checkPermission(permission);
        Enumeration enumeration = documentLoadListeners.elements();
        while (enumeration.hasMoreElements()) {
            DocumentLoadListener documentLoadListener = (DocumentLoadListener)enumeration.nextElement();
            documentLoadListener.endDocumentLoad(string, n, (Document)DOMAccessor.getNodeByHandle(l));
        }
        DOMAccessor.doGC();
    }

    static {
        System.loadLibrary("javadomjni");
    }
}

