/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.test;

import java.awt.BorderLayout;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.mozilla.webclient.test.DOMAccessPanel;
import org.mozilla.webclient.test.DOMCellRenderer;
import org.mozilla.webclient.test.DOMTreeModel;
import org.mozilla.webclient.test.EmbeddedMozilla;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;

public class DOMViewerFrame
extends JFrame
implements EventListener {
    private EmbeddedMozilla creator;
    private Node rootNode;
    private Node mouseOverNode = null;
    private DOMAccessPanel elementPanel;
    private JScrollPane treePane;
    private JSplitPane splitPane;
    private JPanel panel;
    private JTree tree;
    private Document doc;
    private Stack pathStack;

    public DOMViewerFrame(String string, EmbeddedMozilla embeddedMozilla) {
        super(string);
        this.creator = embeddedMozilla;
        this.getContentPane().setLayout(new BorderLayout());
        this.treePane = new JScrollPane();
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add("Center", this.treePane);
        this.elementPanel = new DOMAccessPanel();
        this.splitPane = new JSplitPane(0, this.panel, this.elementPanel);
        this.getContentPane().add(this.splitPane);
        this.pack();
        this.splitPane.setDividerLocation(0.35);
    }

    public void setDocument(Document document) {
        if (null == document) {
            return;
        }
        EventTarget eventTarget = null;
        if (null != this.doc && this.doc instanceof EventTarget) {
            eventTarget = (EventTarget)((Object)this.doc);
            eventTarget.removeEventListener("mousedown", this, false);
        }
        this.doc = document;
        if (this.doc instanceof EventTarget) {
            eventTarget = (EventTarget)((Object)this.doc);
            eventTarget.addEventListener("click", this, false);
            eventTarget.addEventListener("mouseover", this, false);
        }
        try {
            Element element = this.doc.getDocumentElement();
            element.normalize();
            this.rootNode = element;
            DOMTreeModel dOMTreeModel = new DOMTreeModel(this.rootNode);
            this.elementPanel.setTreeNotifier(dOMTreeModel);
            this.tree = new JTree(dOMTreeModel);
            this.tree.addTreeSelectionListener(this.elementPanel);
            this.tree.setCellRenderer(new DOMCellRenderer(this.tree.getCellRenderer()));
            this.tree.getSelectionModel().setSelectionMode(4);
            this.treePane.setViewportView(this.tree);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleEvent(Event event) {
        if (!(event instanceof MouseEvent)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        Node node = (Node)((Object)mouseEvent.getRelatedTarget());
        if (null != node) {
            this.mouseOverNode = node;
        }
        if (mouseEvent.getShiftKey() && 0 != mouseEvent.getDetail() && 0 == mouseEvent.getButton() && null != this.mouseOverNode) {
            this.selectNodeInTree(this.mouseOverNode);
        }
    }

    protected void selectNodeInTree(Node node) {
        if (null == node) {
            return;
        }
        if (null != this.pathStack) {
            this.pathStack.removeAllElements();
        }
        this.populatePathStackFromNode(node);
        if (null == this.pathStack || this.pathStack.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = this.pathStack.size() - 1;
        Object[] objectArray = new Object[n2];
        int n3 = n2;
        while (n3 > 0) {
            objectArray[n++] = this.pathStack.elementAt(n3 - 1);
            --n3;
        }
        TreePath treePath = new TreePath(objectArray);
        this.tree.clearSelection();
        this.tree.setSelectionPath(treePath);
        this.tree.scrollPathToVisible(treePath);
    }

    protected void populatePathStackFromNode(Node node) {
        if (null == node) {
            return;
        }
        if (null == this.pathStack) {
            this.pathStack = new Stack();
        }
        if (null == this.pathStack) {
            return;
        }
        this.pathStack.push(node);
        Node node2 = node.getParentNode();
        if (null != node2) {
            this.populatePathStackFromNode(node2);
        }
    }
}

