/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import sunw.demo.classfile.ClassFile;
import sunw.demo.classfile.ConstantPoolEntry;

class DoubleConstant
extends ConstantPoolEntry {
    private double doubler;

    DoubleConstant(double d, ClassFile classFile) {
        super((byte)6, classFile);
        this.doubler = d;
        this.addToConstantPool();
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.getTag());
        dataOutputStream.writeDouble(this.doubler);
    }

    double getValue() {
        return this.doubler;
    }

    public boolean equals(Object object) {
        if (object instanceof Double) {
            return this.doubler == (Double)object;
        }
        if (object instanceof DoubleConstant) {
            DoubleConstant doubleConstant = (DoubleConstant)object;
            return this.doubler == doubleConstant.getValue();
        }
        return false;
    }

    public int hashCode() {
        return (int)this.doubler;
    }
}

