/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number
implements Comparable {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class TYPE = Class.getPrimitiveClass("short");
    private short value;
    private static final long serialVersionUID = 7515723908773894738L;

    public static String toString(short s) {
        return Integer.toString(s, 10);
    }

    public static short parseShort(String string) throws NumberFormatException {
        return Short.parseShort(string, 10);
    }

    public static short parseShort(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)n2;
    }

    public static Short valueOf(String string, int n) throws NumberFormatException {
        return new Short(Short.parseShort(string, n));
    }

    public static Short valueOf(String string) throws NumberFormatException {
        return Short.valueOf(string, 10);
    }

    public static Short decode(String string) throws NumberFormatException {
        Short s;
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            ++n2;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > 1 + n2) {
            ++n2;
            n = 8;
        }
        if (string.startsWith("-", n2)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            s = Short.valueOf(string.substring(n2), n);
            s = bl ? new Short(-s.shortValue()) : s;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl ? new String("-" + string.substring(n2)) : string.substring(n2);
            s = Short.valueOf(string2, n);
        }
        return s;
    }

    public Short(short s) {
        this.value = s;
    }

    public Short(String string) throws NumberFormatException {
        this.value = Short.parseShort(string);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Short) {
            return this.value == (Short)object;
        }
        return false;
    }

    public int compareTo(Short s) {
        return this.value - s.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Short)object);
    }
}

